// Arduino code for actuation the Pneumatic Ovipositor Needle
// Authors: Jette Bloemberg (j.bloemberg@tudelft.nl), Bruce Hoppener
// Last update: 30/05/2023

// Setup milliseconds count 
unsigned long startMillis;  
unsigned long currentMillis;

// Period between the piston movements in (ms)
int DELAY = 500; // 0.5 s
// int DELAY = 300; // 0.3 s
// int DELAY = 100; // 0.1 s

// Number of Cycles
unsigned long totalCycles = 30;

// Set the current cycle to zero
unsigned long currentCycle = 0;

// Declaring pins
int PIST1 = 13; // green
int PIST2 = 12; // brown
int PIST3 = 11; // yellow
int PIST4 = 10; // purple
int PIST5 = 9; // white
int PIST6 = 8; // orange
// GND = black


void setup() {
  // put your setup code here, to run once:
  pinMode(PIST1, OUTPUT);
  pinMode(PIST2, OUTPUT);
  pinMode(PIST3, OUTPUT);
  pinMode(PIST4, OUTPUT);
  pinMode(PIST5, OUTPUT);
  pinMode(PIST6, OUTPUT);
  startMillis = millis();  //initial start time
}

void loop() {

    currentMillis = millis();  //get the current "time" (actually the number of milliseconds since the program started)

    if (currentMillis - startMillis >= DELAY && totalCycles - currentCycle > 0)  //test whether the period has elapsed
      {
       digitalWrite(PIST1, HIGH);
    }

    if (currentMillis - startMillis >= 2*DELAY && totalCycles - currentCycle > 0)  //test whether the period has elapsed
      {
       digitalWrite(PIST2, HIGH);
   }

   if (currentMillis - startMillis >= 3*DELAY && totalCycles - currentCycle > 0)  //test whether the period has elapsed
      {
        digitalWrite(PIST3, HIGH);
    }
  
    if (currentMillis - startMillis >= 4*DELAY && totalCycles - currentCycle > 0)  //test whether the period has elapsed
      {
       digitalWrite(PIST4, HIGH);
    }

    if (currentMillis - startMillis >= 5*DELAY && totalCycles - currentCycle > 0)  //test whether the period has elapsed
      {
       digitalWrite(PIST5, HIGH);
    }

    if (currentMillis - startMillis >= 6*DELAY && totalCycles - currentCycle > 0)  //test whether the period has elapsed
      {
       digitalWrite(PIST6, HIGH);
      }

   if (currentMillis - startMillis >= 7*DELAY && totalCycles - currentCycle > 0)  //test whether the period has elapsed
     {
       digitalWrite(PIST1, LOW);
        digitalWrite(PIST2, LOW);
        digitalWrite(PIST3, LOW);
        digitalWrite(PIST4, LOW);
        digitalWrite(PIST5, LOW);
        digitalWrite(PIST6, LOW);
        startMillis = currentMillis; // update the time
        currentCycle = currentCycle + 1;
     }
}

