# -*- coding: utf-8 -*-
"""
Created on Mon Mar 20 08:28:44 2023

@author: necjgerzinic
"""

import pandas as pd
import biogeme.database as db
import biogeme.biogeme as bio
from biogeme.expressions import Beta, log, MonteCarlo, PanelLikelihoodTrajectory, bioDraws
import biogeme.models as models
import biogeme.messaging as msg

df = pd.read_csv("formatted_dataset.csv",sep=',', engine='python')

# Specify the type of memory storage and weights
memory  = 'event_based'
weights = 'absolute'

# Specify the inertia parameters
# NOTE: 0 = estimate, 1 = fixed
inertia_one       = 1 
inertia_sum       = 1
inertia_log_sum   = 1
inertia_reset     = 0
inertia_log_reset = 1

database = db.Database('Reliability',df)
globals().update(database.variables)
database.panel('PERSID')

# Select which columns to use, based on if the memory is assumed to be time-based or event-based
# In the dataset, two sets of columns are specified, one for each memory storage appraoch
if memory == 'time_based':
    # wA is the set of columns that contain waiting times for service A, with n being the most recent, n_1 one before that etc.
    wA=[wA_n, wA_n_1,wA_n_2,wA_n_3,wA_n_4,wA_n_5,wA_n_6,wA_n_7,wA_n_8,wA_n_9,wA_n_10,wA_n_11,wA_n_12,wA_n_13,wA_n_14,wA_n_15,
        wA_n_16,wA_n_17,wA_n_18,wA_n_19,wA_n_20,wA_n_21,wA_n_22,wA_n_23,wA_n_24,wA_n_25,wA_n_26,wA_n_27,wA_n_28,wA_n_29,wA_n_30] 
    # wB is the set of columns that contain waiting times for service B
    wB=[wB_n, wB_n_1,wB_n_2,wB_n_3,wB_n_4,wB_n_5,wB_n_6,wB_n_7,wB_n_8,wB_n_9,wB_n_10,wB_n_11,wB_n_12,wB_n_13,wB_n_14,wB_n_15,
        wB_n_16,wB_n_17,wB_n_18,wB_n_19,wB_n_20,wB_n_21,wB_n_22,wB_n_23,wB_n_24,wB_n_25,wB_n_26,wB_n_27,wB_n_28,wB_n_29,wB_n_30] 
    # dA and dB are cancellation dummies for services A and B respectively. The dummy is coded 1 if the services was cancelled and 0 if not.
    dA=[dA_n, dA_n_1,dA_n_2,dA_n_3,dA_n_4,dA_n_5,dA_n_6,dA_n_7,dA_n_8,dA_n_9,dA_n_10,dA_n_11,dA_n_12,dA_n_13,dA_n_14,dA_n_15,
        dA_n_16,dA_n_17,dA_n_18,dA_n_19,dA_n_20,dA_n_21,dA_n_22,dA_n_23,dA_n_24,dA_n_25,dA_n_26,dA_n_27,dA_n_28,dA_n_29,dA_n_30] 
    dB=[dB_n, dB_n_1,dB_n_2,dB_n_3,dB_n_4,dB_n_5,dB_n_6,dB_n_7,dB_n_8,dB_n_9,dB_n_10,dB_n_11,dB_n_12,dB_n_13,dB_n_14,dB_n_15,
        dB_n_16,dB_n_17,dB_n_18,dB_n_19,dB_n_20,dB_n_21,dB_n_22,dB_n_23,dB_n_24,dB_n_25,dB_n_26,dB_n_27,dB_n_28,dB_n_29,dB_n_30]
    
elif memory == 'event_based': 
    wA=[wA_N, wA_N_1,wA_N_2,wA_N_3,wA_N_4,wA_N_5,wA_N_6,wA_N_7,wA_N_8,wA_N_9,wA_N_10,wA_N_11,wA_N_12,wA_N_13,wA_N_14,wA_N_15,
        wA_N_16,wA_N_17,wA_N_18,wA_N_19,wA_N_20,wA_N_21,wA_N_22,wA_N_23,wA_N_24,wA_N_25,wA_N_26,wA_N_27,wA_N_28,wA_N_29,wA_N_30] 
    wB=[wB_N, wB_N_1,wB_N_2,wB_N_3,wB_N_4,wB_N_5,wB_N_6,wB_N_7,wB_N_8,wB_N_9,wB_N_10,wB_N_11,wB_N_12,wB_N_13,wB_N_14,wB_N_15,
        wB_N_16,wB_N_17,wB_N_18,wB_N_19,wB_N_20,wB_N_21,wB_N_22,wB_N_23,wB_N_24,wB_N_25,wB_N_26,wB_N_27,wB_N_28,wB_N_29,wB_N_30]
    dA=[dA_N, dA_N_1,dA_N_2,dA_N_3,dA_N_4,dA_N_5,dA_N_6,dA_N_7,dA_N_8,dA_N_9,dA_N_10,dA_N_11,dA_N_12,dA_N_13,dA_N_14,dA_N_15,
        dA_N_16,dA_N_17,dA_N_18,dA_N_19,dA_N_20,dA_N_21,dA_N_22,dA_N_23,dA_N_24,dA_N_25,dA_N_26,dA_N_27,dA_N_28,dA_N_29,dA_N_30] 
    dB=[dB_N, dB_N_1,dB_N_2,dB_N_3,dB_N_4,dB_N_5,dB_N_6,dB_N_7,dB_N_8,dB_N_9,dB_N_10,dB_N_11,dB_N_12,dB_N_13,dB_N_14,dB_N_15,
        dB_N_16,dB_N_17,dB_N_18,dB_N_19,dB_N_20,dB_N_21,dB_N_22,dB_N_23,dB_N_24,dB_N_25,dB_N_26,dB_N_27,dB_N_28,dB_N_29,dB_N_30]  
    
# column sets wA_late and wB_late are dummy coded, where 1 means the service was late (later than anticipated) and 0 if on time or early
wA_late=[wA_N_late,wA_N_late_1,wA_N_late_2,wA_N_late_3,wA_N_late_4,wA_N_late_5,wA_N_late_6,wA_N_late_7,wA_N_late_8,wA_N_late_9,wA_N_late_10,wA_N_late_11,wA_N_late_12,wA_N_late_13,wA_N_late_14,wA_N_late_15,wA_N_late_16,
        wA_N_late_17,wA_N_late_18,wA_N_late_19,wA_N_late_20,wA_N_late_21,wA_N_late_22,wA_N_late_23,wA_N_late_24,wA_N_late_25,wA_N_late_26,wA_N_late_27,wA_N_late_28,wA_N_late_29,wA_N_late_30,wA_N_late_31]
wB_late=[wB_N_late,wB_N_late_1,wB_N_late_2,wB_N_late_3,wB_N_late_4,wB_N_late_5,wB_N_late_6,wB_N_late_7,wB_N_late_8,wB_N_late_9,wB_N_late_10,wB_N_late_11,wB_N_late_12,wB_N_late_13,wB_N_late_14,wB_N_late_15,wB_N_late_16,
        wB_N_late_17,wB_N_late_18,wB_N_late_19,wB_N_late_20,wB_N_late_21,wB_N_late_22,wB_N_late_23,wB_N_late_24,wB_N_late_25,wB_N_late_26,wB_N_late_27,wB_N_late_28,wB_N_late_29,wB_N_late_30,wB_N_late_31]

# Define the parameters
ASC_B        = Beta('ASC_B',             0,None,None,0)
B_DENIED     = Beta('B_denied',          0,None,None,0)
B_TIME_LATE  = Beta('B_wait_time_late',  0,None,None,0)
B_TIME_EARLY = Beta('B_wait_time_early', 0,None,None,0)
B_COST       = Beta('B_cost',            0,None,None,0)
B_BARRIER    = Beta('B_barrier_to_entry',0,None,None,0)  

# Define the exponents for exponential function
A_TIME   = Beta('A_time',                0,None,None,0)
A_DENIED = Beta('A_denied',              0,None,None,0)

# Define the random paramters
B_COST_S       = Beta('B_cost_S',        1,None,None,0)
B_TIME_LATE_S  = Beta('B_time_late_S',   1,None,None,0)
B_TIME_EARLY_S = Beta('B_time_early_S',  1,None,None,0)
B_DENIED_S     = Beta('B_denied_S',      1,None,None,0)

# Define the different inertia parameters
# The final argument is binary coded, where 0 means estimate and 1 means fixed to starting value (0 in this case)
I_one       = Beta('I_one',      0,None,None,inertia_one)
I_sum       = Beta('I_sum',      0,None,None,inertia_sum)
I_log_sum   = Beta('I_log_sum',  0,None,None,inertia_log_sum)
I_reset     = Beta('I_reset',    0,None,None,inertia_reset)
I_log_reset = Beta('I_log_reset',0,None,None,inertia_log_reset)

# Join  the parameter with it's respective random parameter and define draws
B_COST_RND       = B_COST       + B_COST_S       * bioDraws('B_COST_RND',    'NORMAL_MLHS')
B_TIME_LATE_RND  = B_TIME_LATE  + B_TIME_LATE_S  * bioDraws('B_TIME_LATE_S', 'NORMAL_MLHS')
B_TIME_EARLY_RND = B_TIME_EARLY + B_TIME_EARLY_S * bioDraws('B_TIME_EARLY_S','NORMAL_MLHS')
B_DENIED_RND     = B_DENIED     + B_DENIED_S     * bioDraws('B_DENIED_RND',  'NORMAL_MLHS')

# Utility functions for descriptive information
V1 =         B_COST_RND * cost_A + B_BARRIER * barrier_A
V2 = ASC_B + B_COST_RND * cost_B + B_BARRIER * barrier_B

# Utility function for the experiential information of waiting time and cancelled service
# Specify if weights are absolute or relative
if weights == 'absolute':
    for i in range(len(wA)):
        V1 = V1 + dA[i] * B_DENIED_RND * (i+1)**A_DENIED + wA[i] * (i+1)**A_TIME * (B_TIME_LATE_RND * wA_late[i] + B_TIME_EARLY_RND * (1-wA_late[i]))
        V2 = V2 + dB[i] * B_DENIED_RND * (i+1)**A_DENIED + wB[i] * (i+1)**A_TIME * (B_TIME_LATE_RND * wB_late[i] + B_TIME_EARLY_RND * (1-wB_late[i]))

elif weights == 'relative':
    # Define the weights upfront, to allow the relative calculation
    time_weights =   [j**A_TIME for j in range(1,33)]
    denied_weights = [j**A_DENIED for j in range(1,33)]
    for i in range(len(wA)):
        V1 = V1 + dA[i] * B_DENIED_RND * denied_weights[i]/sum(denied_weights[0:i+1]) + wA[i] * time_weights[i]/sum(time_weights[0:i+1]) * (B_TIME_LATE_RND * wA_late[i] + B_TIME_EARLY_RND * (1-wA_late[i]))
        V2 = V2 + dB[i] * B_DENIED_RND * denied_weights[i]/sum(denied_weights[0:i+1]) + wB[i] * time_weights[i]/sum(time_weights[0:i+1]) * (B_TIME_LATE_RND * wB_late[i] + B_TIME_EARLY_RND * (1-wB_late[i]))

# Utility function for the different inertia specifications
V1 = V1 + I_one * inertia_one_A + I_sum * inertia_sum_A + I_log_sum * inertia_log_sum_A + I_reset * inertia_reset_A + I_log_reset * inertia_log_reset_A
V2 = V2 + I_one * inertia_one_B + I_sum * inertia_sum_B + I_log_sum * inertia_log_sum_B + I_reset * inertia_reset_B + I_log_reset * inertia_log_reset_B

# Specify the logit model and estimate
V =  {1:V1,2:V2}
av = {1:AV,2:AV}

obsprob = models.logit(V,av,c_n)
condprobIndv = PanelLikelihoodTrajectory(obsprob)
logprob = log(MonteCarlo(condprobIndv))

logger = msg.bioMessage()
logger.setGeneral()

biogeme = bio.BIOGEME(database,logprob, numberOfDraws=5000)
biogeme.modelName = "Model_name"
biogeme.saveIterations = False
biogeme.generatePickle = False
results=biogeme.estimate()
# parameters variable is a DataFrame with the parameters, standard errors, t and p-values.
parameters = results.getEstimatedParameters()
# statistics varaible is a DataFrame with the 
statistics = pd.DataFrame(data=results.getGeneralStatistics()).transpose()
    


