#########################################################################################################
# Analysis for the paper  - Factors Affecting User's Behavioral Intention and Use of a Mobile-Phone-
# Delivered Cognitive Behavioral Therapy for Insomnia: a Small-Scale UTAUT Analysis -
# Imputation of missing data
# 2018 TUDelft
# Output file "89_imputed_#.csv", "89_imputed_#.txt" and "89_imputed_#.sav" will be created 
#
# required datafile
# - 89_beforeimputation.sav
#
# note:
# The imputation process in this study was only conducted once using data for n=89. 
#########################################################################################################

#adjust this to folder that contain data files
setwd("/Users/Siska/Documents/temp-berkas/my work/Corine's paper/BMC/stat/")

########### libraries
library(foreign)
library(MASS)
library(psych)
###########

################################################# Data ##########################################################################
d89=read.spss("Acceptance research/smartpls scripts, data & results/Data/89_beforeImputation.sav", to.data.frame=TRUE, use.value.labels = FALSE, reencode=NA)

# data fields
# PPnr: Participant number
# conditie: Trial condition, 0 <- waiting list, 1 <- app 
# Performance Expectancy:
# PE1	The SleepCare app provides me information about sleep
# PE2	I feel relax assisting by the SleepCare app
# PE3	The SleepCare app helps me to sleep better
# PE4	The SleepCare app provides me clear insight about my sleep pattern
# PE5	The SleepCare app provides me enough controls over my own intervention
# PE6	Using the SleepCare app, I can do the exercises independently and stay anonymous 
# PE7	The SleepCare app fits my personality
#
# Effort Expectancy:
# EE1	The use of the SleepCare app gives me no ambiguities
# EE2	The SleepCare app is easy to use
# EE3	Learning to work with the SleepCare app is easy for me
# EE4	Utilizing the app gives me little trouble
# EE5_R	Using the SleepCare app is too complicated so I find it hard to understand
# EE6	The app fits in with my daily life
#
# Social Influence
# SI1	I think that my friends would recommend me to use the SleepCare app
# SI2	I think that my family would think I should use the SleepCare app
# SI3	I think that the people in my work environment would encourage me to use the SleepCare app
# SI4	I think that other people with sleep problems would encourage me to use the SleepCare app
# SI5_R	I think that my surrounding would think negatively to a person who use the SleepCare app 
#
# Self_Efficacy
# SE1	I can work well with the SleepCare app without help from others
# SE2	I will be able to use the SleepCare app as long as nothing abnormal happens
# SE3	I can work independently with the SleepCare app
# SE4	I am sure that I'm using the SleepCare app in a good way
#
# Trust
# TR1	I trust the information that SleepCare app provides me with
# TR2_R	I think the SleepCare app will put my privacy at risk
# TR3	I am confident that the SleepCare app will work well
#
# Hedonic Motivation
# HM1	Using the SleepCare app is a good idea
# HM2_R	I hate using the SleepCare app
# HM3	I find that using the SleepCare app is fun
# HM4	I find that using the SleepCare app is interesting
# HM5	The SleepCare app gives me the feeling that my problem is taken seriously
# HM6	The approach of the SleepCare app makes me feel safe
# HM7_R	I feel apprehensive when using the SleepCare app
#
# Anxiety
# AN1_R	I'm worried about using the app
# AN2_R	I'm sometime afraid of losing information if I press a wrong button 
# AN3_R	I'm afraid to make mistakes in the SleepCare app that I cannot turn them back
# AN4_R	I feel somewhat intimidated by the SleepCare app 
#
# Behavioral Intention
# BI1	I will definitely finish the training
# BI2	I will definitely fill in the sleep diary everyday
# BI3	I will definitely do the relaxation exercise everyday
# BI4	I will certainly stay compliant to the bedtimes that I have agreed with the coach
# BI5	I am going to follow up on the sleep tips
# BI6	I am going to fill in my sleep_times in the sleep diary as well as possible
# BI7	I am going to take the time to do the relaxation exercise everyday 
#
# Facilitating Condition
# FC1	I have enough knowledge necessary for using the SleepCare app
# FC2	My mobile phone works perfectly for running the SleepCare app
# FC3	Where necessary, the SleepCare team will help me to use the SleepCare app
# FC4	Where necessary, my friends and/or family will help me to use the SleepCare app
#
# Experienced Therapy Outcome Questionnaire
# TO1_R	Because of the SleepCare app, the number of minutes that I lie awake at night is [less .. more]
# TO2	The SleepCare app provides [less .. more] insight about my sleep behavior
# TO3	Because of the SleepCare app, my bed_times are [shorter .. longer]
# TO4_R	Because of the SleepCare app, my tiredness during the day is [less .. more]
# TO5_R	Because of the SleepCare app, the amount of concerns that I experience when I go to sleep is [less .. more] 
# TO6	Because of the SleepCare app, my knowledge about sleep is [worst .. better]
# TO7	Because of the SleepCare app, the quality of my sleep is [worst .. better]
# TO8_R	Because of the SleepCare app, the time it takes to fall asleep is [less .. more]
# TO9_R	Because of the SleepCare app, the amount of times that I wake up too early in the morning and cannot go back to sleep is [less .. more]
#
# Insomnia Severity Index (ISI)
# ISI1	Please rate the current (at the last 2 weeks) severity of your insomnia problems: Difficulty failing asleep [None .. Severe]
# ISI2	Please rate the current (at the last 2 weeks) severity of your insomnia problems: Difficulty staying asleep [None .. Severe]
# ISI3	Please rate the current (at the last 2 weeks) severity of your insomnia problems: Problem waking up too early [None .. Severe]
# ISI4	How satisfied are you with your current sleep pattern? [Very satisfied .. Very dissatisfied]
# ISI5	How noticeable to others do you think your sleep problem is in terms of impairing the quality of your life? [Not at all noticeable .. Very much noticeable]
# ISI6	How worried/distressed are you about your current sleep problem [Not at all worried .. Very much worried]
# ISI7	To what extend do you consider your sleep problem to interfere with your daily functioning (e.g. daytime fatigue, mood, ability to function at work/daily chores, concentration, memory, mood, etc.) currently? [Not at all interfering .. Very much interfering]
#
# User Behavioral Data:
# SD_DO	The number of days a participant entered the sleep diary
# CONV_DO	The number of completed conversations
# RE_DO	The number of days the participant completed one or more relaxation exercise
# SR_DO	The number of weeks in which a participant agreed to do the sleep restriction exercises 
# SR_DEV	The mean absolute deviation between agreed and actual time in bed (in minutes)

# Excluding variables from the imputation process
drops<-c("PPnr", "conditie", "TO3", "PHYSIC", "MED", "PRESCRIBED")
db<-d89[, !(names(d89) %in% drops), drop=F]

# Assigning one type to each variable
library(dplyr) 
db <- db %>% mutate(
  BI1 = as.numeric(BI1),
  BI2 = as.numeric(BI2),
  BI3 = as.numeric(BI3),
  BI4 = as.numeric(BI4),
  BI5 = as.numeric(BI5),
  BI6 = as.numeric(BI6),
  BI7 = as.numeric(BI7),
  PE1 = as.numeric(PE1),
  PE2 = as.numeric(PE2),
  PE3 = as.numeric(PE3),
  PE4 = as.numeric(PE4),
  PE5 = as.numeric(PE5),
  PE6 = as.numeric(PE6),
  PE7 = as.numeric(PE7),
  EE1 = as.numeric(EE1),
  EE2 = as.numeric(EE2),
  EE3 = as.numeric(EE3),
  EE4 = as.numeric(EE4),
  EE5_R = as.numeric(EE5_R),
  EE6 = as.numeric(EE6),
  SI1 = as.numeric(SI1),
  SI2 = as.numeric(SI2),
  SI3 = as.numeric(SI3),
  SI4 = as.numeric(SI4),
  SI5_R = as.numeric(SI5_R),
  HM1 = as.numeric(HM1),
  HM2_R = as.numeric(HM2_R),
  HM3 = as.numeric(HM3),
  HM4 = as.numeric(HM4),
  HM5 = as.numeric(HM5),
  HM6 = as.numeric(HM6),
  HM7_R = as.numeric(HM7_R),
  SE1 = as.numeric(SE1),
  SE2 = as.numeric(SE2),
  SE3 = as.numeric(SE3),
  SE4 = as.numeric(SE4),
  TR1 = as.numeric(TR1),
  TR2_R = as.numeric(TR2_R),
  TR3 = as.numeric(TR3),
  AN1_R = as.numeric(AN1_R),
  AN2_R = as.numeric(AN2_R),
  AN3_R = as.numeric(AN3_R),
  AN4_R = as.numeric(AN4_R),
  FC1 = as.numeric(FC1),
  FC2 = as.numeric(FC2),
  FC3 = as.numeric(FC3),
  FC4 = as.numeric(FC4),
  SD_Adh = as.numeric(SD_Adh),
  RE_Adh = as.numeric(RE_Adh),
  CONV_Adh = as.numeric(CONV_Adh),
  NOTI_SEND = as.numeric(NOTI_SEND),
  CONV_OFFER = as.numeric(CONV_OFFER),
  CONV_DO = as.numeric(CONV_DO),
  SD_DO = as.numeric(SD_DO),
  RE_DO = as.numeric(RE_DO),
  PRE_ISI1 = as.numeric(PRE_ISI1),
  PRE_ISI2 = as.numeric(PRE_ISI2),
  PRE_ISI3 = as.numeric(PRE_ISI3),
  PRE_ISI4 = as.numeric(PRE_ISI4),
  PRE_ISI5 = as.numeric(PRE_ISI5),
  PRE_ISI6 = as.numeric(PRE_ISI6),
  PRE_ISI7 = as.numeric(PRE_ISI7),
  PRE_ISI = as.numeric(PRE_ISI),
  B_ISI1 = as.numeric(B_ISI1),
  B_ISI2 = as.numeric(B_ISI2),
  B_ISI3 = as.numeric(B_ISI3),
  B_ISI4 = as.numeric(B_ISI4),
  B_ISI5 = as.numeric(B_ISI5),
  B_ISI6 = as.numeric(B_ISI6),
  B_ISI7 = as.numeric(B_ISI7),
  B_ISI = as.numeric(B_ISI),
  POST_ISI1 = as.numeric(POST_ISI1),
  POST_ISI2 = as.numeric(POST_ISI2),
  POST_ISI3 = as.numeric(POST_ISI3),
  POST_ISI4 = as.numeric(POST_ISI4),
  POST_ISI5 = as.numeric(POST_ISI5),
  POST_ISI6 = as.numeric(POST_ISI6),
  POST_ISI7 = as.numeric(POST_ISI7),
  POST_ISI = as.numeric(POST_ISI),
  TO1_R = as.numeric(TO1_R),
  TO2 = as.numeric(TO2),
  TO4_R = as.numeric(TO4_R),
  TO5_R = as.numeric(TO5_R),
  TO6 = as.numeric(TO6),
  TO7 = as.numeric(TO7),
  TO8_R = as.numeric(TO8_R),
  TO9_R = as.numeric(TO9_R),
  AGE = as.numeric(AGE),
  GEN = as.factor(GEN),
  EDU = as.factor(EDU),
  JOB = as.factor(JOB),
  ALONE = as.factor(ALONE),
  SUFF_Y = as.factor(SUFF_Y)
)

# Imputation process
library(mice)
init = mice(db, maxit=0)
meth<-init$method
predM<-init$predictorMatrix
meth=c("ppm","logreg","polyreg","logreg","logreg","polyreg",                                     #categorical data
       "pmm","pmm","pmm","pmm","pmm","pmm","pmm",             #PE
       "pmm","pmm","pmm","pmm","pmm","pmm",                   #EE
       "pmm","pmm","pmm","pmm","pmm",                         #SI
       "pmm","pmm","pmm","pmm","pmm","pmm","pmm",             #HM
       "pmm","pmm","pmm","pmm",                               #SE
       "pmm","pmm","pmm",                                     #TR
       "pmm","pmm","pmm","pmm",                               #AN
       "pmm","pmm","pmm","pmm","pmm","pmm","pmm",             #BI
       "pmm","pmm","pmm","pmm",                               #FC
       "pmm","pmm","pmm","pmm","pmm","pmm","pmm","pmm",                        #UB
       "pmm","pmm","pmm","pmm","pmm","pmm","pmm",                                  #PRE-ISI
       "pmm","pmm","pmm","pmm","pmm","pmm","pmm",                                  #B-ISI
       "pmm","pmm","pmm","pmm","pmm","pmm","pmm",                                  #POST-ISI
       "pmm","pmm","pmm",                                                          #TOT-ISI
       "pmm","pmm","pmm","pmm","pmm","pmm","pmm","pmm"                              #TO
)

imp = mice(db, method=meth, predictorMatrix=predM, maxit=100, seed=916700)

# Checking the results
d <- complete(imp)
sapply(d, function(x) sum(is.na(x)))

# Writing the results
write.csv(d, file="Acceptance research/smartpls scripts, data & results/Data/89_imputed_2.csv", row.names = FALSE)
write.foreign(d, "Acceptance research/smartpls scripts, data & results/Data/89_imputed_2.txt", "Acceptance research/smartpls scripts, data & results/Intention-Behavior/Data/89_imputed_2.sav", package="SPSS")

############################## End of the imputation process ##############
