#########################################################################################################
# Analysis for the paper  - Factors Affecting User's Behavioral Intention and Use of a Mobile-Phone-
# Delivered Cognitive Behavioral Therapy for Insomnia: a Small-Scale UTAUT Analysis
# Section: Additional File Behavioral Constructs Calculation
# 2018 TUDelft
# Output file (append to) "raw data/AppData.sav" will be created 
#
# required datafiles
# - raw data/AppData.sav
#########################################################################################################
#adjust this to folder that contain data files
setwd("/Users/Siska/Documents/temp-berkas/my work/Corine's paper/BMC/stat/")

########### libraries
library(foreign)
library(MASS)
library(psych)
###########

################################################# Data ##########################################################################
app=read.spss("Acceptance research/raw data/AppData.sav", to.data.frame=TRUE, use.value.labels = FALSE, reencode=NA)

# data fields
# PPnr: Participant number
# conditie: Trial condition, 0 <- waiting list, 1 <- app 
# Diary1..49: filling in daily sleep diary, 0 <- no, 1 <- yes
# Weekdiary1..7: the amount of completed sleep diary in a week
# DiaryReminder1..49: app sending a remider to fill in the diary, 0 <- no, 1 <- yes
# Exercis1..49: the amount of completed relaxation exercises in a day
# WeekExercise1..7: the amount of completed relaxation exercise in a week
# ConversationNotify1..49: app sending a notification to attend a conversation with the app, 0 <- no, 1 <- yes
# ConversationReminder1..49: app sending a reminder to attend a conversation with the app, 0 <- no, 1 <- yes
# CV_??_*: day# when the corresponding conversation was conducted
# STATUS_*_*: status of the corresponding conversation (related to the negotiation in the Sleep Restriction exercise) INTROREFUSED = -1; SUCCESS = 1; NEGREFUSED = 2; POSTPONED = 3; EXCLUDED = 4;
# CONV_OFFER: the total offered conversations

# Behavioral Data:
# CONV_DO: the number of completed conversations
# SD_DO: the number of days the sleep diary was completed 
# RE_DO: the number of days the participant did at least one relaxation exercise

# the number of completed conversations
app$CONV_DO

# the number of days the sleep diary was completed 
colWeekdiary <- data.frame(app[c(52:58)])
app$SD_DO<- rowSums(colWeekdiary, na.rm=FALSE)

# the number of days the participant did at least one relaxation exercise
colExercise <- data.frame(app[c(108:156)])
app$RE_DO <- 49-rowSums(colExercise == 0, na.rm=FALSE)


# Writing the results
write.csv(app, file="Acceptance research/raw data/AppData.csv", row.names = FALSE)

############################ End of Behavioural Data Calculation #######################
  


  