function [x] = Config2Arms(p, r)
%Transforms vector from parameter space p to vector random vector x
% Vector p in parameter space P
% p(1)    = mu_f, the friction coefficient of the dielectric material.
% p(2)    = phi_1, the starting angle of the electroadhesive film
%             relative to hinge point H.
% p(3)    = phi_2, the final angle of the electroadhesive film
%             relative to hinge point H.
% p(4)    = r_frac, the radius of the hinge point H, r_H, over the radius of
%             the clutch pad, r.
% Vector of random variables, x
% x(1)    = u_f
% x(2)    = a_0, the scalar moment arm of electrostatic force F_0
% x(3)    = a_N, the scalar moment arm of normal force F_N
% x(4)    = a_f, the scalar moment arm of friction force F_f
%% Calculate alpha and beta
alpha   = AlphaCalc(p);
beta    = BetaCalc(p);
%% Calculate length of arms
x(1,1)    = p(1);
x(1,2)    = p(4) * r * cos(pi/2 - alpha);
x(1,3)    = p(4) * r * cos(pi/2 - beta);
x(1,4)    = r - p(4) * r * sin(pi/2 - beta);
end

