function [beta] = BetaCalc(p)
%This function calculates the angle beta based on the clutch configuration
%   beta is the point of application of the normal force
%   p(1)    = u_f, the friction coefficient of the dielectric material.
%   p(2)    = phi_1, the starting angle of the electroadhesive film
%             relative to hinge point H.
%   p(3)    = phi_2, the final angle of the electroadhesive film
%             relative to hinge point H.
%   p(4)    = r_frac, the radius of the hinge point H, r_H, over the radius of
%             the clutch pad, r.
beta = ( sin(p(3)) - sin(p(2)) + p(2)*cos(p(2)) - p(3)*cos(p(3)) ) / ...
            ( cos(p(2)) - cos(p(3)) );
end

