function [xi] = AmplificationFactorP(p)
%Calculate the amplification factor for the given configuration p
%   First, calculate the corresponding arm lengths for configuration p.
%   Here, we fill in an arbitrary value for the radius, since the radius
%   does not influence the amplification factor
x       = Config2Arms(p, 1);
%   See equation 3 of paper
q_1     = x(2) / x(3);
q_2     = x(4) / x(3);
xi      = q_1 / (1 - x(1)*q_2);
end

