***Data for "Understanding The Development of Human Trust in Social Robots"***

Authors: C. Ning, M. L. Tielman
Interactive Intelligence group, Intelligent Systems Department, EEMCS Faculty, Delft University of Technology

Corresponding Author: C. Ning

Contact Information: 

w4a2y4<at>gmail<dot>com


***General Introduction***
This data was collected as part of Charlotte Ning's master's thesis in TU Delft. The thesis "Understanding The Development of Human Trust in Social Robots" will be available in TU Delft library repository.

***Data collection***
The data was collected with Qualtrics as a part of repeated-measured in person user study, in which the participant engage with 3 rounds of conversation with a social robot.

***Data analysis***
The quantitative & qualitative data were preprocessed with R. For paranormal belief, trust in card, and affective/cognitive trust in the robot, the average scores were calculated.
The transcripts were pseudonymized by hand to remove possible identifiable information. For example, participant's name is replaced by the string "[user_name]"

***Description of the data in this data set***
* "quantitative" sheet in "data.xlsx": the quantitative results. It contains the following columns:
    - id: the unique id for the participant
    - group: the group the subject is assigned to (Social/Baseline)
    - paranormal: participant's dispositional paranormal belief (1-7 points)
    - age: participant's age range (2="21~25", 3="26~30", 4="31~35")
    - gender: participant's gender (1="Male", 2="Female", 3="Non-binary")
    - experience: experience with social robot and/or conversational agent (2="Never",3="Rarely", 4="Occasionally", 5="Sometimes", 6="Frequently", 7="Daily")
    - intimacy(1-3): subjective topic intimacy for each interaction round (%)
    - card(1-3): trust in card for each interaction round (1-7 points)
    - affective_trust(1-3): affective trust in robot after each interaction round (1-7 points)
    - affective_certainty(1-3): certainty in the affective trust assessment above (%)
    - cognitive_trust(1-3): cognitive trust in robot after each interaction round (1-7 points)
    - cognitive_certainty(1-3): certainty in the cognitive trust assessment above (%)
* "qualitative" sheet in "data.xlsx": the qualitative results. It contains the following columns:
    - id: the unique id for the participant (corresponding to the id in quantitative data)
    - A(1-3): the rationale for the affective trust ratings in each interaction round
    - C(1-3): the rationale for the cognitive trust ratings in each interaction round
    - OP(1-4): these are the answers to the open question after the whole experiment. the questions are:
      - OP1: "How did your impression of Navel’s understanding of you, if at all?"
      - OP2: "How did your affective trust in Navel change as the sessions progress, if at all?"
      - OP3: "How did your cognitive trust in Navel change as the sessions progress, if at all?"
      - OP4: "Is there any additional feedback for the whole experiment?"
* "transcript" folders: Contain the conversation transcript between the robot and the participant. The contents are pseudonymized.