function TprofileCoFlow(param,Tdata)

UA = param(1);
h1A = param(2);
h2A = param(3);

Tc_in = Tdata(1);
Th_in = Tdata(2);

UA = 50; % W/m2/K
h1A = 0; % W/m2/K
h2A = 0; % W/m2/K
Tw = 23; % deg C
Tc_in = 5; % deg C
Th_in = 25; % deg C
Cp = 4184; % J/kg K
Qin = 20; % mL/min
Qin = 20/1e6/60; % m3/s
L = 0.15; % m
rho = 1000; % kg/m3

m_in = rho*Qin;

mCp = m_in*Cp;

Tvec0 = [Th_in Th_in Th_in Tc_in Tc_in Tc_in]';
options = [];

[x,Tvec] = ode15s(@coFlow,[0 L],Tvec0,options,UA,h1A,h2A,mCp,Tw);
Th1 = Tvec(:,1);
Th2 = Tvec(:,2);
Th3 = Tvec(:,3);
Tc1 = Tvec(:,4);
Tc2 = Tvec(:,5);
Tc3 = Tvec(:,6);
plot(x,Th1,'o-',x,Th2,'^-',x,Th3,'x-',x,Tc1,'o-',x,Tc2,'^-',x,Tc3,'x-')
xlabel('Length along Membrane')
ylabel('Temperature Profiles, deg C')
legend('Hot 1','Hot 2','Hot 3','Cold 1','Cold 2','Cold 3')
Thot_out = mean([Th1(end) Th2(end) Th3(end)])
Tcold_out = mean([Tc1(end) Tc2(end) Tc3(end)])

deltaT1 = mean(Th1-Tc1) % from top down, from hot 1 to cold 1
deltaT2 = mean(Tc1-Th2) % from cold 1 to hot 2
deltaT3 = mean(Th2-Tc2) % from hot 2 to cold 2
deltaT4 = mean(Tc2-Th3) % from cold 2 to hot 3 
deltaT5 = mean(Th3 - Tc3) % from cold 3 to hot 3

figure(2)
plot(x,Th1-Tc1,'o-',x,Th2-Tc1,'^-',x,Th2-Tc2,'+-',x,Th3-Tc2,'*-',x,Th3-Tc3,'x-')
xlabel('Length along Membrane')
ylabel('delta T between streams')
legend('Hot 1 - Cold 1','Hot 2 - Cold 1','Hot2 - Cold 2','Hot 3 - Cold 2','Hot 3 - Cold 3')

F = [Tcold_out Thot_out]

function F = coFlow(x,Tvec,UA,h1A,h2A,mCp,Tw)

Th1 = Tvec(1);
Th2 = Tvec(2);
Th3 = Tvec(3);
Tc1 = Tvec(4);
Tc2 = Tvec(5);
Tc3 = Tvec(6);

dTh1 = (-UA*(Th1-Tc1)-h1A*(Th1-Tw))/mCp;
dTh2 = UA*(Tc1+Tc2-2*Th2)/mCp;
dTh3 = UA*(Tc2+Tc3-2*Th3)/mCp;
dTc1 = UA*(Th1+Th2-2*Tc1)/mCp;
dTc2 = UA*(Th2+Th3-2*Tc2)/mCp;
dTc3 = (UA*(Th3-Tc3)+h2A*(Tw-Tc3))/mCp;

F = [dTh1 dTh2 dTh3 dTc1 dTc2 dTc3]';

