clear all
close all
clc

%% Reading the excel file and extracting data

filename = ('20160727_REDstack.xlsx');
IsoTherm_High = xlsread(filename,4);
RivHotSeaCold = xlsread(filename,3);
RivColdSeaHot = xlsread(filename,2);
IsoTherm_Low = xlsread(filename,1);

%% Extracting the IsothermLow data

for ii = 1:4
    IsoThermLow_pot(:,ii) = IsoTherm_Low(:,ii+1+(ii-1)*4);
    IsoThermLow_curr(:,ii) = IsoTherm_Low(:,ii+3+(ii-1)*4);
    IsoThermLow_time(:,ii) = IsoTherm_Low(:,ii+2+(ii-1)*4);
end

IsoThermLow_pot_avg = mean(IsoThermLow_pot,2);
IsoThermLow_pot_std = nanstd(IsoThermLow_pot,0,2);

IsoThermLow_pot_average = mean(IsoThermLow_pot_avg(50:200));
IsoThermLow_power = IsoThermLow_pot_average*0.1498

%% Extracting the IsothermHigh data

for ii = 1:4
    IsoThermHigh_pot(:,ii) = IsoTherm_High(:,ii+1+(ii-1)*4);
    IsoThermHigh_curr(:,ii) = IsoTherm_High(:,ii+3+(ii-1)*4);
    IsoThermHigh_time(:,ii) = IsoTherm_High(:,ii+2+(ii-1)*4);
end

IsoThermHigh_pot_avg = mean(IsoThermHigh_pot,2);
IsoThermHigh_pot_std = nanstd(IsoThermHigh_pot,0,2);

IsoThermHigh_pot_average = mean(IsoThermHigh_pot_avg(50:200));
IsoThermHigh_power = IsoThermHigh_pot_average*0.1498

%% Extracting the River Hot, Sea Cold data

for ii = 1:4
    RivHotSeaCold_pot(:,ii) = RivHotSeaCold(:,ii+1+(ii-1)*4);
    RivHotSeaCold_curr(:,ii) = RivHotSeaCold(:,ii+3+(ii-1)*4);
    RivHotSeaCold_time(:,ii) = RivHotSeaCold(:,ii+2+(ii-1)*4);
end

RivHotSeaCold_pot_avg = mean(RivHotSeaCold_pot,2);
RivHotSeaCold_pot_std = nanstd(RivHotSeaCold_pot,0,2);

RivHotSeaCold_pot_average = mean(RivHotSeaCold_pot_avg(50:200));
RivHotSeaCold_power = RivHotSeaCold_pot_average*0.1498

%% Extracting the River Cold, Sea Hot data

for ii = 1:4
    RivColdSeaHot_pot(:,ii) = RivColdSeaHot(:,ii+1+(ii-1)*4);
    RivColdSeaHot_curr(:,ii) = RivColdSeaHot(:,ii+3+(ii-1)*4);
    RivColdSeaHot_time(:,ii) = RivColdSeaHot(:,ii+2+(ii-1)*4);
end
RivColdSeaHot_pot_avg = mean(RivColdSeaHot_pot,2);
RivColdSeaHot_pot_std = nanstd(RivColdSeaHot_pot,0,2);

RivColdSeaHot_pot_average = mean(RivColdSeaHot_pot_avg(50:200));
RivColdSeaHot_power = RivColdSeaHot_pot_average*0.1498

%%
nn = 1;
figure(nn)
hold on
plot(IsoThermLow_time,IsoThermLow_pot)
% axis([0 150 0.065 0.073])
nn = nn+1;

figure(nn)
hold on
plot(IsoThermHigh_time,IsoThermHigh_pot)
% axis([0 150 0.065 0.073])
nn = nn+1;

figure(nn)
hold on
plot(RivColdSeaHot_time,RivColdSeaHot_pot)
nn = nn+1;

%%  
colormap lines
map = colormap;
map = [242 95 92; 255 224 102;80 81 79; 112 193 179; 36 123 160]./255; 
symbols = {'*','x','.','o','s'};

figure(nn)
hold on
plot(RivHotSeaCold_time,RivHotSeaCold_pot)
% axis([0 150 0.065 0.073])
nn = nn+1;

figure(nn)
hold on
H(1) = shadedErrorBar(RivHotSeaCold_time(:,1),IsoThermLow_pot_avg,IsoThermLow_pot_std, {'color',map(4,:),'marker',symbols{3},'LineStyle','-'})
H(3) = shadedErrorBar(RivHotSeaCold_time(:,1),RivHotSeaCold_pot_avg,RivHotSeaCold_pot_std, {'color',map(3,:),'marker',symbols{3},'LineStyle','-'})
H(2) = shadedErrorBar(RivHotSeaCold_time(:,1),RivColdSeaHot_pot_avg,RivColdSeaHot_pot_std, {'color',map(2,:),'marker',symbols{3},'LineStyle','-'})

H(4) = shadedErrorBar(RivHotSeaCold_time(:,1),IsoThermHigh_pot_avg,IsoThermHigh_pot_std, {'color',map(1,:),'marker',symbols{3},'LineStyle','-'})
legend([H(1).mainLine,H(2).mainLine,H(3).mainLine,H(4).mainLine],['T_D = T_C = 20 \degree C'],['T_D = 20 \degree C, T_C = 40 \degree C'],['T_D = 40 \degree C, T_C = 20 \degree C'],['T_D = T_C = 40 \degree C'], 'Location', 'SouthEast')
legend boxoff
box on
axis([0 250 0.26 0.40])
XaxisLabel = xlabel('Time (s)')
YaxisLabel = ylabel('Potential (V)')
matlab2tikz('ED_potential.tex')
print('-dpng','H:\My Documents\Experiments\Temperature gradients\Plaatjes png\ED_potential')

% h_legend = legend('Isotherm Low','River Cold, Sea Hot','River Hot, Sea Cold','Isotherm High', 'Location', 'SouthEast')
nn = nn+1;


%% 
