clear all
close all
clc


%% Reading the excel file and extracting data

filename = ('Cations.xlsx');
Input = xlsread(filename,4);

cations_enriched = Input(9:12,3);
cations_enriched_std = Input(9:12,10);
cations_depleted = Input(1:4,3);
cations_depleted_std = Input(1:4,10);

anions_enriched = Input(9:12,5);
anions_enriched_std = Input(9:12,12);
anions_depleted = Input(1:4,5);
anions_depleted_std = Input(1:4,12);

%% Make plot
nn = 1;
map = [242 95 92; 255 224 102;80 81 79; 112 193 179; 36 123 160]./255; 
symbols = {'*','x','.','o','s'};
figure(nn)
hold on
errorbar(cations_enriched,cations_enriched_std,'Color',map(4,:),'LineStyle','none','Marker','.','MarkerSize',20)
errorbar(anions_enriched,anions_enriched_std,'Color',map(1,:),'LineStyle','none','Marker','.','MarkerSize',20)
errorbar(cations_depleted,cations_depleted_std,'Color',map(3,:),'LineStyle','none','Marker','.','MarkerSize',20)
errorbar(anions_depleted,anions_depleted_std,'Color',map(2,:),'LineStyle','none','Marker','.','MarkerSize',20)
line([0.5 4.5],[0.02 0.02],'LineStyle','--', 'Color','k')
LOC = [0.4, 0.45, 0.2, 0.13];
legend('Enriched cations','Enriched anions','Depleted cations','Depleted anions','Location',LOC)
legend boxoff
ax = gca;
ax.YTick = [0.01 0.02 0.03];
ax.XTick = [1 2 3 4];
ax.XTickLabel = {'Cold Isotherm','Hot Concentrate','Hot Diluate', 'Hot Isotherm'};
ylabel('Ion concentration (mol/L)')
box on

matlab2tikz('ED_concentration.tex')



