Data for Compilation strategies for quantum network programs using Qoala.

Samuel Oslovich, Bart van der Vecht, Stephanie Wehner

QuTech, Delft University of Technology

Kavli Institute of Nanoscience, Delft University of Technology

Quantum Computer Science, Electrical Engineering, Mathematics and Computer Science, Delft University of Technology


Contact: Samuel Oslovich (s.o.oslovich@tudelft.nl)

** General Info **
This dataset contains results from simulations of the compilation strategies presented in the paper "Compilation strategies for quantum network programs using Qoala."

The simulations were ran on the DelftBlue supercomputing cluster at TU Delft.

** Folder structure **
The data is split into four folders, with each folder corresponding to one of the evaluation sections presented in the paper. E.g. the Hybrid\_Comp\_Exps folder corresponds to the hybrid compilation experiments. 

Inside each folder there is a configs folder and a data folder. 

The configs folder contains a .json file with the seeds used for the simulations and one or more .json files used for the configuration of the simulation runs. 

The data folder contains the .json files that were the results of the simulation runs. The data .json files follow the naming convention of {Date}\_{ID}\_{parameter}\_{number of clients}\_{hardware}\_{seed value}.json.

The .json data files contain a "meta" object, holding all of the metadata, like the timestamp and fixed parameters, such as internal scheduling latency, gate durations, etc. The "data\_points" field contains a list of the gathered data points, including the success probability of the programs, the execution time, the varied paramter, and the parameter value.

** Code **
The qoala-compilation-strategies-eval-main.zip contains the qoala-sim branch code used to generate all of the data, located in the compiler-evaluation folder.
