# -*- coding: utf-8 -*-
"""
Created on Mon Oct 10 14:56:11 2022

@author: soch

Notes:
    1. At the transformer, positive values are net production, negative
        values are net consumption. At nodes, this is opposite.
    2. For the battery, a negative power is discharge, a positive value is charge.

v2.0
"""

#NO GIZMOS model of Ansen area network

#load the relevent modules
import pandapower as pp
import numpy as np
import pandas as pd
import pandapower.control as control
import pandapower.timeseries as ts
from pandapower.timeseries.data_sources.frame_data import DFData
from pandapower.timeseries import OutputWriter
from pandapower.timeseries.run_time_series import run_timeseries
#import matplotlib as plt
from pandapower.plotting.plotly.mapbox_plot import set_mapbox_token
import math
import matplotlib.pyplot as plt
import matplotlib.cm
import os
import sys
import warnings
import time
import winsound
import networkx as nx
import pandapower.topology as top
import random as random
import time
import openpyxl
warnings.simplefilter(action='ignore', category=FutureWarning)
set_mapbox_token('<token>')
pd.set_option('display.max_rows', 50000)
pd.set_option('display.max_columns', 500)
pd.set_option('display.width', 200)
np.set_printoptions(threshold=sys.maxsize)

def Batch():
    Initialize = True           #Set to True to set up grid model on first run
    storage = 'none'
    netGridLoad_0 = Run(Initialize, storage)
    
    strategies = ['selfConsumption', 'priceDriven']
    for storage in strategies:
        
# =============================================================================
#     #test
#     Initialize = False
#     #storage = 'selfConsumption'
#     storage = 'priceDriven'
#     DSO_override = False
#     P_battery_max=12
#     battery_capacity = 8/1000
#     Run(Initialize, storage, DSO_override, P_battery_max/1000, netGridLoad_0, battery_capacity)
#     
# =============================================================================
# =============================================================================
#     #Self-consumption scenario
#     Initialize = False
#     storage = 'selfConsumption'
#     DSO_override = True
#     Run(Initialize, storage, DSO_override)
# =============================================================================
    
# =============================================================================
#     #Price-driven scenarion
#     Initialize = False
#     storage = 'priceDriven'
#     DSO_override = False
#     Run(Initialize, storage, DSO_override)
# =============================================================================
        
# =============================================================================
#         #Test
#         P_battery_max=15
#         storage = 'priceDriven'
#         DSO_override = True
#         Initialize = False
#         Run(Initialize, storage, DSO_override, P_battery_max/1000, netGridLoad_0)
# =============================================================================
    
# =============================================================================
#         #Passive control
#         power_constraints = []
#         for power in [0.5,1,2,4,8,12,15]:
#             power_constraints.append(power/1)
#         print('power constraints: ', power_constraints)
#         #Capacity pricing for powers [5,7.5,10,12.5,15,17.5,20] kW
#         capPrice = [0.0,0.025,0.05,0.075,0.1,0.125,0.15]
#             
#         #divide by 1000 or divide by 1? Price driven seems to divide by 1000 automatically, not sure why...
#         for P_battery_max in power_constraints:
#             Initialize = False
#             #storage = 'selfConsumption'
#             #storage = 'priceDriven'
#             DSO_override = True
#             Run(Initialize, storage, DSO_override, P_battery_max/1000, netGridLoad_0, capPrice=capPrice, capOn = True)
# =============================================================================

        #1) PV scaling
        #2) Load scaling
        #3) Capacity pricing - profits make no sense, rest is fine...
        #4) Reference sceario

# =============================================================================
#         #Passive control - high power
#         power_constraints = []
#         for power in [17.5,20,22.5,25,27.5,30,32.5,35]:#[15]:#[0.5,1,2,4,8,12,15]:
#             power_constraints.append(power/1)
#         print('power constraints: ', power_constraints)
#         #Injection fee
#         injectionFee = 0 #0.05
#             
#         #divide by 1000 or divide by 1? Price driven seems to divide by 1000 automatically, not sure why...
#         for P_battery_max in power_constraints:
#             Initialize = False
#             #storage = 'selfConsumption'
#             #storage = 'priceDriven'
#             DSO_override = True
#             Run(Initialize, storage, DSO_override, P_battery_max/1000, netGridLoad_0, capOn = False,injectionFee=injectionFee)
# =============================================================================

        #Passive control - low power reference
        power_constraints = []
        for power in [15]: # [0.5,1,2,4,8,12,15]:
            power_constraints.append(power/1)
        print('power constraints: ', power_constraints)
        #Injection fee
        injectionFee = 0 #0.05
            
        #divide by 1000 or divide by 1? Price driven seems to divide by 1000 automatically, not sure why...
        for P_battery_max in power_constraints:
            Initialize = False
            #storage = 'selfConsumption'
            #storage = 'priceDriven'
            DSO_override = True
            Run(Initialize, storage, DSO_override, P_battery_max/1000, netGridLoad_0, capOn = False,injectionFee=injectionFee)

# =============================================================================
#         #Passive control
#         power_constraints = []
#         for power in [0.5,1,2,4,8,12,15]:
#             power_constraints.append(power/1)
#         print('power constraints: ', power_constraints)
#         #Capacity pricing for powers [5,7.5,10,12.5,15,17.5,20] kW
#         capPrice = [0.0,0.025,0.05,0.075,0.1,0.125,0.15]
#             
#         #divide by 1000 or divide by 1? Price driven seems to divide by 1000 automatically, not sure why...
# 
#         P_battery_max=15
#         Initialize = False
#         #storage = 'selfConsumption'
#         #storage = 'priceDriven'
#         DSO_override = True
#         Run(Initialize, storage, DSO_override, P_battery_max/1000, netGridLoad_0, capPrice=capPrice, capOn = False)            
# =============================================================================



# =============================================================================
#         capacities =[]
#         for cap in [5,10,15,20,25,30]:
#             capacities.append(cap/1)
#         for cap in capacities:
#             print('battery capacity: ', cap)
#             #storage = 'selfConsumption'
#             #storage = 'priceDriven'
#             Initialize=False
#             DSO_override = True
#             P_battery_max = 15/1000
#             battery_capacity = cap * 0.8 / 1000
#             Run(Initialize, storage, DSO_override, P_battery_max, netGridLoad_0, battery_capacity)
# =============================================================================
        
# =============================================================================
#         for min_cost in [0, 0.025, 0.05, 0.075, 0.1, 0.125, 0.15]:
#             #storage = 'selfConsumption'
#             #storage = 'priceDriven'
#             Initialize=False
#             DSO_override = True
#             P_battery_max = 15/1000
#             battery_capacity = 10 * 0.8 / 1000
#             minProfit = min_cost
#             Run(Initialize, storage, DSO_override, P_battery_max, netGridLoad_0, battery_capacity, minProfit)
# =============================================================================


# =============================================================================
#         for cycle_efficiency in [0.75, 0.8, 0.85, 0.9, 0.925, 0.95, 0.975, 1]:
#             #storage = 'selfConsumption'
#             #storage = 'priceDriven'
#             Initialize=False
#             DSO_override = True
#             P_battery_max = 15/1000
#             battery_capacity = 10 * 0.8 / 1000
#             #minProfit = min_cost
#             Run(Initialize, storage, DSO_override, P_battery_max, netGridLoad_0, battery_capacity, cycle_efficiency=cycle_efficiency)
# =============================================================================

# =============================================================================
#         for threshold in [0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1]:
#             #storage = 'selfConsumption'
#             #storage = 'priceDriven'
#             Initialize=False
#             DSO_override = True
#             P_battery_max = 15/1000
#             battery_capacity = 10 * 0.8 / 1000
#             #minProfit = min_cost
#             Run(Initialize, storage, DSO_override, P_battery_max, netGridLoad_0, battery_capacity, threshold=threshold)
# =============================================================================

# =============================================================================
#         for taxes in [0,0.05,0.1,0.15,0.2,0.25,0.3]:
#             #storage = 'selfConsumption'
#             #storage = 'priceDriven'
#             Initialize=False
#             DSO_override = True
#             P_battery_max = 15/1000
#             battery_capacity = 10 * 0.8 / 1000
#             #minProfit = min_cost
#             Run(Initialize, storage, DSO_override, P_battery_max, netGridLoad_0, battery_capacity, taxes=taxes)
# =============================================================================
            
            
# =============================================================================
#         for gridDensity in [0.5,0.75,1,1.25,1.5]:
#             #storage = 'selfConsumption'
#             #storage = 'priceDriven'
#             Initialize=False
#             DSO_override = True
#             P_battery_max = 15/1000
#             battery_capacity = 10 * 0.8 / 1000
#             #minProfit = min_cost
#             Run(Initialize, storage, DSO_override, P_battery_max, netGridLoad_0, battery_capacity, gridDensity=gridDensity)
# =============================================================================
        
# =============================================================================
#         for gridCapacity in [1,2,3]:
#                 #storage = 'selfConsumption'
#                 #storage = 'priceDriven'
#                 Initialize=False
#                 DSO_override = True
#                 P_battery_max = 15/1000
#                 battery_capacity = 10 * 0.8 / 1000
#                 #minProfit = min_cost
#                 Run(Initialize, storage, DSO_override, P_battery_max, netGridLoad_0, battery_capacity, gridCapacity=gridCapacity)
# =============================================================================

    return 0
    
    

def Run(Initialize=True, storage = 'none', DSO_override = False, P_battery_max = 15/1000, netGridLoad_0=0, battery_capacity = (10*0.8)/1000, 
        minProfit = 0.05, cycle_efficiency = 0.95, threshold = 0.7, taxes=0, gridDensity=1,gridCapacity=1, capPrice=0, capOn = False, injectionFee=0):

    input_file = os.path.join(os.getcwd(), 'Grid properties.xlsx')
    #input_file = os.path.join(os.getcwd(), 'Houtlaan Summary Data.xlsx')
    load_pattern = os.path.join(os.getcwd(), 'Load Pattern.csv')
    gen_pattern = os.path.join(os.getcwd(), 'Generation Pattern.csv')
    battery_dir = os.path.join(os.getcwd(), 'Battery Pattern.csv')
    output_dir = os.getcwd()
    start_time = time.time()
    
    battery_locs = [9,11,20,48,67,73,83,90,96]
    #P_battery_max = 15/1000 # MW
    #battery_capacity = (10*0.8)/1000 # MWh
    #cycle_efficiency = 0.95
    time_step = 0.25
    #threshold = 0.7
    allowed_error = 0.001        #Error allowed when minimizing battery capacity - FINAL RESULTS SHOULD USE 0.0001 but takes too long, esp. DES
    Capacity_limit = 10     #The network load limit, used to calculate the safety factor, in kW/house
    cable_length_multiplyer = 1
    total_capacity = 90*0.8 #kWh
    DSO_overrides = [0,0,0,0,0,0,0,0,0]
    DSO_capacity = [0,0,0,0,0,0,0,0,0]
    Safety_margin=0.9
    #minProfit = 0.05
       
    if storage=='none':
        Reinforce_Grid = False
        selfConsumption = False
        priceDriven = False
    elif storage == 'selfConsumption':
        Reinforce_Grid = False
        selfConsumption = True
        priceDriven = False
    elif storage=='priceDriven':
        Reinforce_Grid = False
        selfConsumption = False
        priceDriven = True

    if Initialize == True:
        # Create Grid
        scenario = 'no battery'
        print('scenario: ', scenario)
        net  = Generate_grid(input_file, gridDensity, gridCapacity) #, Capacity_limit, battery_locs, P_battery_max, battery_capacity)
        #net = Grid_test()
        #Plot_Grid(net)
        
        # Save and plot grid model
        pp.to_pickle(net, "WorkingDoc.p")
        
        #Reset
        results_file = os.path.join(output_dir, "results.csv")
        with open(results_file, 'w') as file:
            pass
        reset_value = 0.0
        battery_pattern, battery_SOC = battery_reset(len(pd.read_csv(load_pattern)), battery_locs, reset_value)
        write_battery_data(output_dir, battery_pattern, battery_SOC)
        
        # Initial State
        net = Run_Model(net, load_pattern, gen_pattern, output_dir, battery_pattern, run_storage=False)
        #pp.diagnostic(net)
        #Plot_Grid(net)
        scenario = 'reference'
        netGridLoad_0 = Analyze_KPIs(net, output_dir, battery_locs, cycle_efficiency, load_pattern, 
                     gen_pattern, battery_dir, scenario, time_step, DSO_overrides, threshold, DSO_capacity, 
                     battery_capacity, taxes, capPrice, capOn)

    else:
        # Load grid model
        net = pp.from_pickle("WorkingDoc.p", convert=True)
    
    if selfConsumption == True:
        #Battery Self-consumption
        scenario = 'self-consumption_' + str(P_battery_max) + '_False' + '_' + str(battery_capacity) + 'kWh' + '_e' + str(minProfit)
        print('scenario: ', scenario)
        net = pp.from_pickle("WorkingDoc.p", convert=True)
        net = place_batteries(net, battery_locs, P_battery_max, battery_capacity)
        
        reset_value = 0.0 #None
        battery_pattern, battery_SOC = battery_reset(len(pd.read_csv(load_pattern)), battery_locs, reset_value)
        
        battery_pattern, battery_SOC = Battery_selfConsumption(net, output_dir, cycle_efficiency, Safety_margin, time_step, allowed_error, 
                     load_pattern, gen_pattern, battery_locs, P_battery_max, battery_capacity, battery_pattern, battery_SOC)
        
        net = Run_Model(net, load_pattern, gen_pattern, output_dir, battery_pattern, run_storage=True)
        
        Net_grid_load = Analyze_KPIs(net, output_dir, battery_locs, cycle_efficiency, load_pattern, 
                      gen_pattern, battery_dir, scenario, time_step, DSO_overrides, threshold, 
                      DSO_capacity, battery_capacity, taxes, capPrice, capOn, injectionFee)
        
        #Net_grid_load = pd.read_csv(os.path.join(os.getcwd(), 'temp.csv'))
        #print(Net_grid_load)

        if DSO_override == True:
            scenario = 'self-consumption_' + str(P_battery_max) + '_True' + '_' + str(battery_capacity) + 'kWh' + '_e' + str(minProfit)
            
            battery_pattern, battery_SOC, DSO_overrides, DSO_capacity = battery_DSO_2(net, output_dir, cycle_efficiency, Safety_margin, time_step, allowed_error, 
                         load_pattern, gen_pattern, battery_locs, P_battery_max, battery_capacity, battery_pattern, battery_SOC, threshold, Net_grid_load, 
                         DSO_overrides, DSO_capacity, storage, netGridLoad_0)
            
            net = Run_Model(net, load_pattern, gen_pattern, output_dir, battery_pattern, run_storage=True)

            Net_grid_load = Analyze_KPIs(net, output_dir, battery_locs, cycle_efficiency, load_pattern, 
                     gen_pattern, battery_dir, scenario, time_step, DSO_overrides, threshold, DSO_capacity, 
                     battery_capacity, taxes, capPrice, capOn, injectionFee)
    
    elif priceDriven == True:
        #Battery price driven
        scenario = 'price-driven_' + str(P_battery_max) + '_' + 'False' + '_' + str(battery_capacity) + 'kWh' + '_e' + str(minProfit)
        print('scenario: ', scenario)
        net = pp.from_pickle("WorkingDoc.p", convert=True)
        net = place_batteries(net, battery_locs, P_battery_max, battery_capacity)
        
        reset_value = 0.0 #None
        battery_pattern, battery_SOC = battery_reset(len(pd.read_csv(load_pattern)), battery_locs, reset_value)
        
        battery_pattern, battery_SOC = Battery_priceDriven(net, output_dir, cycle_efficiency, Safety_margin, time_step, allowed_error, 
                     load_pattern, gen_pattern, battery_locs, P_battery_max, battery_capacity, battery_pattern, battery_SOC, minProfit, 
                     taxes, capPrice, injectionFee)
        
        net = Run_Model(net, load_pattern, gen_pattern, output_dir, battery_pattern, run_storage=True)
        
        Net_grid_load = Analyze_KPIs(net, output_dir, battery_locs, cycle_efficiency, load_pattern, 
                     gen_pattern, battery_dir, scenario, time_step, DSO_overrides, threshold, 
                     DSO_capacity, battery_capacity, taxes, capPrice, capOn, injectionFee)
        
        if DSO_override == True:
            scenario = 'price-driven_' + str(P_battery_max) + '_' + 'True' + '_' + str(battery_capacity) + 'kWh' + '_e' + str(minProfit)
            battery_pattern, battery_SOC, DSO_overrides, DSO_capacity = battery_DSO_2(net, output_dir, cycle_efficiency, Safety_margin, time_step, allowed_error, 
                         load_pattern, gen_pattern, battery_locs, P_battery_max, battery_capacity, battery_pattern, battery_SOC, threshold, Net_grid_load, 
                         DSO_overrides, DSO_capacity, storage, netGridLoad_0)
        
            net = Run_Model(net, load_pattern, gen_pattern, output_dir, battery_pattern, run_storage=True)

            Net_grid_load = Analyze_KPIs(net, output_dir, battery_locs, cycle_efficiency, load_pattern, 
                     gen_pattern, battery_dir, scenario, time_step, DSO_overrides, threshold, DSO_capacity, 
                     battery_capacity, taxes, capPrice, capOn, injectionFee)
    
    Run_Complete(start_time)
    return netGridLoad_0



def Generate_grid(input_file, gridDensity=1, gridCapacity=1):
    #Read in data
    df = pd.read_excel(input_file, sheet_name = 'Cables')
    cable_data = df.to_numpy()
    df = pd.read_excel(input_file, sheet_name = 'Trafos')
    trafo_data = df.to_numpy()
    df = pd.read_excel(input_file, sheet_name = 'Buscoords')
    Coords = df.to_numpy()
    
    #Create Net
    net = pp.create_empty_network(name="Case", f_hz=50.0)
    
    #Create Smaller Trafos
    #160 kW
    pp.create_std_type(net, {"sn_mva": 0.16,
        "vn_hv_kv": 10,
        "vn_lv_kv": 0.4,
        "vk_percent": 4,
        "vkr_percent": 0.78125,
        "pfe_kw": 0.35,
        "i0_percent": 0.16875,
        "shift_degree": 150,
        #"vector_group": vector_group,
        "tap_side": "hv",
        "tap_neutral": 0,
        "tap_min": -2,
        "tap_max": 2,
        "tap_step_degree": 0,
        "tap_step_percent": 2.5,
        "tap_phase_shifter": False,
        },name='0.16 MVA 10/0.4 kV', element="trafo")
   
    #100 kW
    pp.create_std_type(net, {"sn_mva": 0.1,
        "vn_hv_kv": 10,
        "vn_lv_kv": 0.4,
        "vk_percent": 4,
        "vkr_percent": 0.78125,
        "pfe_kw": 0.2,
        "i0_percent": 0.16875,
        "shift_degree": 150,
        #"vector_group": vector_group,
        "tap_side": "hv",
        "tap_neutral": 0,
        "tap_min": -2,
        "tap_max": 2,
        "tap_step_degree": 0,
        "tap_step_percent": 2.5,
        "tap_phase_shifter": False,
        },name='0.1 MVA 10/0.4 kV', element="trafo")
    
    #Perfect Transformer
    pp.create_std_type(net, {"sn_mva": .1,
        "vn_hv_kv": 10,
        "vn_lv_kv": 0.4,
        "vk_percent": 0.00001,
        "vkr_percent": 0.00001,
        "pfe_kw": 0.00001,
        "i0_percent": 0.00001,
        "shift_degree": 0,
        #"vector_group": vector_group,
        "tap_side": "lv",
        "tap_neutral": 0,
        "tap_min": -2,
        "tap_max": 2,
        "tap_step_degree": 0,
        "tap_step_percent": 2.5,
        "tap_phase_shifter": False,}, 
        name='perfect trafo', element="trafo")
    
    # 95 mm2 line
    line_data = {"c_nf_per_km": 260, "r_ohm_per_km": 0.478, "x_ohm_per_km": 0.08, 
                 "max_i_ka":0.23, "type": "cs", "q_mm2": 95, "alpha":0.004}
    pp.create_std_type(net, line_data, "NAYY 4x95 SE", element='line')
    
    # Low resistance line
    line_data = {"c_nf_per_km": 1, "r_ohm_per_km": 0.00001, "x_ohm_per_km": 0.000001, "max_i_ka":10}
    pp.create_std_type(net, line_data, 'Low Resistance', element='line')
    
    #Nameing Structure:
    #Trafo.Cable.Branch.House    
    
    # Create Transformers
    n_trafos = len(trafo_data)
    trafo_capacities = np.array([])
    
    for trafo in range(0,n_trafos):
        x_coord = float(Coords[(trafo*2)+1,1])
        y_coord = float(Coords[(trafo*2)+1,2])
        bus_coords = (x_coord, y_coord)
        mv_bus = pp.create_bus(net, name = "Bus_MV%i" % trafo, vn_kv=10)#, type='n') #,geodata=bus_coords)
        lv_bus = pp.create_bus(net, name = "Bus_LV%i" % trafo, vn_kv=0.4)#, type='n') #,geodata=bus_coords)
        pp.create_ext_grid(net, pp.get_element_index(net, "bus", "Bus_MV%i" % trafo),
                       vm_pu=1.0, va_degrees=0, name="External_grid%i" % trafo,
                       s_sc_max_mva=10, rx_max=0.1, rx_min=0.1)
        #Define transformer
        trafo_capacity = trafo_data[trafo,2]
        if trafo_capacity == 100:
            trafo_type = '0.1 MVA 10/0.4 kV' #need new type
        elif trafo_capacity == 160:
            trafo_type = '0.16 MVA 10/0.4 kV' #need new type
        elif trafo_capacity == 250:
            trafo_type = '0.25 MVA 10/0.4 kV'
        elif trafo_capacity == 400:
            trafo_type = '0.4 MVA 10/0.4 kV'
        elif trafo_capacity == 630:
            trafo_type = '0.63 MVA 10/0.4 kV'
        # For testing
        if gridCapacity==2:
            trafo_type = '0.25 MVA 10/0.4 kV'
        elif gridCapacity==3:
            trafo_type = '0.4 MVA 10/0.4 kV'
        
        #trafo_type='perfect trafo'
        trafo_capacities=np.append(trafo_capacities, trafo_type)
        trafo_index = pp.create_transformer(net, mv_bus, lv_bus, std_type = trafo_type, name = "MV-LV-Trafo%i" % trafo)
        pp.create_switch(net, mv_bus, trafo_index, et='t', closed=True, type='LBS', name='Switch MV%i' % trafo)
        # LV switch created below  
    
    #Generate Cables
    n_lines = len(cable_data)

    for n in range(0,n_lines):
        text = str(cable_data[n,1])
        trafo = int(text[0])
        cable = int(text[2])
        branch = int(text[4])
        n_bus = int(cable_data[n,5] + cable_data[n,6])
        bus_count = n+5
        if (text[-1:]) == '0': # main
            from_bus = pp.get_element_index(net, "bus", 'Bus_LV%i' % trafo)
        elif (text[-1:]) != '0': # branch
            from_bus = pp.get_element_index(net, "bus",'Bus_LV%s' % cable_data[n,7])
        for bus in range(0,n_bus):
            x_coord = float(Coords[bus_count,1])
            y_coord = float(Coords[bus_count,2])
            bus_coords = (x_coord, y_coord)
            to_bus = pp.create_bus(net, name='Bus_LV%s.%s.%s.%s' % (trafo, cable, branch, bus), 
                      vn_kv=0.4)#, type='n') #, geodata=bus_coords)
            pp.create_load(net=net, bus=to_bus, p_mw=0.000001, q_mvar=0.0000001, 
                           name = 'Load_LV%s.%s.%s.%s' % (trafo, cable, branch, bus))
            pp.create_sgen(net=net, bus=to_bus, p_mw=0.000001, q_mvar=0.0000001, 
                           name = 'Gen_LV%s.%s.%s.%s' % (trafo, cable, branch, bus))
            if cable_data[n,4] == 150:
                line_type = 'NAYY 4x150 SE'
            elif cable_data[n,4] == 130:
                line_type = 'NAYY 4x120 SE'
            elif cable_data[n,4] == 95:
                line_type = 'NAYY 4x95 SE'
            else:
                line_type = 'NAYY 4x50 SE'
           
            # For testing
            if gridCapacity==2:
                if cable_data[n,4] < 130:
                    line_type='NAYY 4x120 SE'
            elif gridCapacity==3:
                line_type = 'NAYY 4x150 SE'
            
           
            line_name = 'Line_LV%s.%s.%s.%s' % (trafo, cable, branch, bus)
           # For testing:
            #line_type='Low Resistance'
            #line_type='NAYY 4x150 SE'

            pp.create_line(net, from_bus, to_bus, length_km=int(cable_data[n,3])/1000/n_bus*gridDensity,
                       std_type=line_type, name=line_name)
            from_bus = to_bus
    
    #Generate MV connection
    line_name = 'Line_MV'
    line_type = 'NA2XS2Y 1x95 RM/25 6/10 kV'
    from_bus = 0
    to_bus = 2
    line_length_km = 449/1000
    pp.create_line(net, from_bus, to_bus, length_km=line_length_km, 
                   std_type=line_type, name=line_name)
    
    #Generate Switches  
    lv_buses = net.bus[net.bus.vn_kv == 0.4]
    #print(lv_buses)
    lv_ls = net.line[(net.line.from_bus.isin(lv_buses.index)) & (net.line.to_bus.isin(lv_buses.index))]
    for _, line in lv_ls.iterrows():
            pp.create_switch(net, line.from_bus, line.name, et='l', closed=True, type='LBS', 
                             name='Switch_%s.%s' % (net.bus.name.at[line.from_bus], line['name']))
            pp.create_switch(net, line.to_bus, line.name, et='l', closed=True, type='LBS', 
                             name='Switch_%s.%s' % (net.bus.name.at[line.to_bus], line['name']))
    #Generate random coordinates
    #pp.plotting.create_generic_coordinates(net, library = 'igraph', respect_switches = True)
    print('grid model complete')
    return net
        

    
def Run_Model(net, load_pattern, gen_pattern, output_dir, battery_pattern=0, run_storage=False):  
    #time.sleep(1)
    print('start run')
    #Load time series from csv
    df_load = pd.read_csv(load_pattern)
    df_load = pd.DataFrame(df_load)
    #df_load = df_load.drop(df_load.columns[0], axis=1)
    ds_load = ts.DFData(df_load, multi=True)

    df_gen = pd.read_csv(gen_pattern)
    df_gen = pd.DataFrame(df_gen)
    #df_gen = df_gen.drop(df_gen.columns[0], axis=1)
    ds_gen = ts.DFData(df_gen, multi=True)
    
    if run_storage == True:
        #df_battery = pd.read_csv(battery_pattern)
        #df_battery = pd.DataFrame(df_battery)
        #df_battery = df_battery.drop(df_battery.columns[0], axis=1)
        df_battery = pd.DataFrame(battery_pattern)
        ds_battery = ts.DFData(df_battery, multi=True)

    #Number of time steps
    n_ts = range(0,len(df_load))
    #n_ts = range(0,300) 
    
    #Build an Outwriter to view results
    ow = OutputWriter(net, n_ts, output_path=output_dir, output_file_type=".csv", log_variables=list(), csv_separator=",")
    # adding vm_pu of all buses and line_loading in percent of all lines as outputs to be stored
    #Can also log for example: net.res_line.loc[net.res_line.loading_percent > 50]
    ow.log_variable('res_bus', 'vm_pu')
    ow.log_variable('res_line', 'loading_percent')
    ow.log_variable('res_line', 'pl_mw')    
    ow.log_variable('res_line', 'ql_mvar')
    ow.log_variable('res_line', 'i_ka')
    ow.log_variable('res_line', 'p_to_mw')
    ow.log_variable('res_load', 'p_mw')
    ow.log_variable('res_bus', 'p_mw')#, index=lv_buses_index, eval_function=np.sum, eval_name="lv_bus_sum_p")
    ow.log_variable('res_bus', 'vm_pu')#, index=lv_buses_index, eval_function=np.max, eval_name="lv_bus_max")
    ow.log_variable('res_trafo', 'loading_percent')
    ow.log_variable('res_trafo', 'p_lv_mw')
    ow.log_variable("res_sgen", "p_mw")
    ow.log_variable('res_trafo','p_hv_mw')
    ow.log_variable('res_trafo','pl_mw')
    ow.log_variable('res_trafo','ql_mvar')
    ow.log_variable('res_trafo','q_hv_mvar')
    ow.log_variable('res_trafo','q_lv_mvar')

    #Run battery
    if run_storage == True:
        #Create load pattern - feed in battery control dataframe
        const_storage = control.ConstControl(net, element='storage', element_index=net.storage.index, 
                                                 variable='p_mw', data_source=ds_battery, profile_name=net.storage.index)
        ow.log_variable("storage", "p_mw")
        ow.log_variable("storage", "soc_percent")

    const_load = control.ConstControl(net, element='load', element_index=net.load.index, 
                                          variable='p_mw', data_source=ds_load, profile_name=net.load.index)
    const_gen = control.ConstControl(net, element='sgen', element_index=net.sgen.index, 
                                          variable='p_mw', data_source=ds_gen, profile_name=net.sgen.index)
    
    #pp.run.runpp(net)
    run_timeseries(net, time_steps=n_ts)#, continue_on_divergence=True)
    return net



def Analyze_KPIs(net, output_dir, battery_locs=[0,1], cycle_efficiency=0.9, load_pattern=0, gen_pattern=0, 
                 battery_pattern=0, scenario='1', time_step=0.25, DSO_overrides=0, threshold=1, DSO_capacity=0, 
                 battery_capacity=10, taxes=0, capPrice=0, capOn=False, injectionFee=0):   
    start_time = time.time()
    results_file = os.path.join(output_dir, "results.csv")
    temp_file = os.path.join(output_dir, "temp.csv")
    #Clear previous results
    #with open(results_file, 'w') as file:
    #    pass
    
    data_to_append = pd.DataFrame(['scenario:', scenario])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.2f', header=False, index=False)
    
    #Initial state
    df_load = pd.read_csv(load_pattern)
    df_gen = pd.read_csv(gen_pattern)
    df_MVgrid = pd.read_csv(os.path.join(output_dir, "MV grid profile.csv"))
    df_prices = pd.read_csv(os.path.join(output_dir, "EPEX prices.csv"))
    #Model results
    df_battery = pd.read_csv(battery_pattern)
    df_battery = df_battery.drop(df_battery.columns[0], axis=1)
    df_load2 = pd.read_csv(os.path.join(output_dir, "res_load", "p_mw.csv"))
    df_load2 = df_load2.drop(df_load2.columns[0], axis=1)
    df_gen2 = pd.read_csv(os.path.join(output_dir, "res_sgen", "p_mw.csv"))
    df_gen2 = df_gen2.drop(df_gen2.columns[0], axis=1)
    df_trafo_hv = pd.read_csv(os.path.join(output_dir, "res_trafo", "p_hv_mw.csv"))
    df_trafo_hv = df_trafo_hv.drop(df_trafo_hv.columns[0], axis=1)
    df_losses_line_p = pd.read_csv(os.path.join(output_dir, "res_line", "pl_mw.csv"))
    df_losses_line_p = df_losses_line_p.drop(df_losses_line_p.columns[0], axis=1)
    df_losses_line_q = pd.read_csv(os.path.join(output_dir, "res_line", "ql_mvar.csv"))
    df_losses_line_q = df_losses_line_q.drop(df_losses_line_q.columns[0], axis=1)
    df_losses_trafo_p = pd.read_csv(os.path.join(output_dir, "res_trafo", "pl_mw.csv"))
    df_losses_trafo_p = df_losses_trafo_p.drop(df_losses_trafo_p.columns[0], axis=1)
    df_losses_trafo_q = pd.read_csv(os.path.join(output_dir, "res_trafo", "pl_mw.csv"))
    df_losses_trafo_q = df_losses_trafo_q.drop(df_losses_trafo_q.columns[0], axis=1)
    
    print('so far so good')
    
    #Calc per battery KPIs: Self-consumption, Electricity costs, battery losses, DSO overrides
    battery_nr=0
    #print('battery: ', battery_nr)
# =============================================================================
#     for battery in battery_locs:
#         print('battery: ', battery_nr)
#         data_to_append = pd.DataFrame(['battery:', battery_nr])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         
#         #Self-consumption MWh: Total_generation - Total_exports
#         data_to_append = pd.DataFrame(['self-consumption MWh'])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         net_load = (df_load.iloc[:,battery] - df_gen.iloc[:,battery] +  df_battery.iloc[:,battery_nr])
#         self_consumption = [(df_gen.iloc[:,battery].sum() - abs(net_load[net_load<0].sum())) * time_step]
#         data_to_append = pd.DataFrame(self_consumption)
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
# 
#         #Self-consumpion ratio: self_consumption / Total_generation
#         data_to_append = pd.DataFrame(['self-consumption ratio'])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         self_consumption_ratio = [(self_consumption / (df_gen.iloc[:,battery].sum()*time_step)) * 100]
#         data_to_append = pd.DataFrame(self_consumption_ratio)
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         
#         #Electricity costs, net consumption * price - net production * price
#         net_load = pd.DataFrame(net_load)
#         electricity_costs = pd.DataFrame([(net_load.iloc[:,0] * df_prices.iloc[:,0] * time_step)]).transpose()
#         data_to_append = pd.DataFrame(['electricity costs'])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         data_to_append = pd.DataFrame([electricity_costs[electricity_costs>0].sum().sum()])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         data_to_append = pd.DataFrame(['electricity profits'])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         data_to_append = pd.DataFrame([electricity_costs[electricity_costs<0].sum().sum()])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         
#         #Battery Losses / Cycles
#         #data_to_append = pd.DataFrame(['battery losses MWh'])
#         data_to_append = pd.DataFrame(['battery cycles'])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         #battery_losses = df_battery[df_battery.iloc[:, battery_nr] > 0].iloc[:, battery_nr].sum() * time_step * (1-cycle_efficiency)
#         #data_to_append = pd.DataFrame([battery_losses])
#         battery_cycles = df_battery[df_battery.iloc[:, battery_nr] > 0].iloc[:, battery_nr].sum() * time_step / battery_capacity
#         data_to_append = pd.DataFrame([battery_cycles])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         
#         #DSO overrides
#         data_to_append = pd.DataFrame(['DSO overrides (hours per year)'])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         Overrides = DSO_overrides[battery_nr]
#         data_to_append = pd.DataFrame([Overrides])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         
#         data_to_append = pd.DataFrame(['DSO overrides (MWh per year)'])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         Overrides_capacity = DSO_capacity[battery_nr] * time_step
#         data_to_append = pd.DataFrame([Overrides_capacity])
#         data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
#         
#         battery_nr += 1
# =============================================================================
    
    battery = battery_locs[0]
    print('battery: ', battery_nr)
    data_to_append = pd.DataFrame(['battery:', battery_nr])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    #Self-consumption MWh: Total_generation - Total_exports
    data_to_append = pd.DataFrame(['self-consumption MWh'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    net_load = (df_load.iloc[:,battery] - df_gen.iloc[:,battery] +  df_battery.iloc[:,battery_nr])
    self_consumption = [(df_gen.iloc[:,battery].sum() - abs(net_load[net_load<0].sum())) * time_step]
    data_to_append = pd.DataFrame(self_consumption)
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)

    #Self-consumpion ratio: self_consumption / Total_generation
    data_to_append = pd.DataFrame(['self-consumption ratio'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    self_consumption_ratio = [(self_consumption / (df_gen.iloc[:,battery].sum()*time_step)) * 100]
    data_to_append = pd.DataFrame(self_consumption_ratio)
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    if capOn == False:
        #Electricity costs, net consumption * price - net production * price
        net_load = pd.DataFrame(net_load)
        #electricity_costs = pd.DataFrame([(net_load.iloc[:,0] * df_prices.iloc[:,0] * time_step)]).transpose()
        electricity_costs = pd.DataFrame([(net_load[net_load>0].iloc[:,0] * df_prices.iloc[:,0] * time_step)]).transpose()
        electricity_profits = pd.DataFrame([(net_load[net_load<0].iloc[:,0] * df_prices.iloc[:,0] * time_step - injectionFee)]).transpose()
        
        data_to_append = pd.DataFrame(['electricity costs'])
        data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
        #data_to_append = pd.DataFrame([electricity_costs[electricity_costs>0].sum().sum()])
        data_to_append = pd.DataFrame([electricity_costs.sum().sum()])
        data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
        data_to_append = pd.DataFrame(['electricity profits'])
        data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
        #data_to_append = pd.DataFrame([electricity_costs[electricity_costs<0].sum().sum()]) * (1-taxes)
        data_to_append = pd.DataFrame([electricity_profits.sum().sum()])
        data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    else:
        #Electricity costs, net consumption * price - net production * price
        net_load = pd.DataFrame(net_load)
        fine = []
        for load in net_load:
            fine.append(CapPrice(load,capPrice)*abs(load))
        df_fine = pd.DataFrame(fine)
        electricity_costs = pd.DataFrame([(net_load.iloc[:,0] * df_prices.iloc[:,0] * time_step) + df_fine.iloc[:,0]]).transpose()
        data_to_append = pd.DataFrame(['electricity costs'])
        data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
        data_to_append = pd.DataFrame([electricity_costs[electricity_costs>0].sum().sum()])
        data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
        data_to_append = pd.DataFrame(['electricity profits'])
        data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
        data_to_append = pd.DataFrame([electricity_costs[electricity_costs<0].sum().sum()]) * (1-taxes)
        data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    #Battery Losses / Cycles
    #data_to_append = pd.DataFrame(['battery losses MWh'])
    data_to_append = pd.DataFrame(['battery cycles'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    #battery_losses = df_battery[df_battery.iloc[:, battery_nr] > 0].iloc[:, battery_nr].sum() * time_step * (1-cycle_efficiency)
    #data_to_append = pd.DataFrame([battery_losses])
    battery_cycles = df_battery[df_battery.iloc[:, battery_nr] > 0].iloc[:, battery_nr].sum() * time_step / battery_capacity
    data_to_append = pd.DataFrame([battery_cycles])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    #DSO overrides
    data_to_append = pd.DataFrame(['DSO overrides (hours per year)'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    Overrides = DSO_overrides[battery_nr]
    data_to_append = pd.DataFrame([Overrides])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    data_to_append = pd.DataFrame(['DSO overrides (MWh per year)'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    Overrides_capacity = DSO_capacity[battery_nr] * time_step
    data_to_append = pd.DataFrame([Overrides_capacity])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)

    #Calc grid KPIs: Peak load (import & export), hours of congestion, grid losses, DSO overrides
    print('batteries done')
    
    #Peak grid load
    Net_grid_load = df_trafo_hv.iloc[:,0] + df_trafo_hv.iloc[:,1] + df_MVgrid.iloc[:,0]
    Net_grid_load = pd.DataFrame(Net_grid_load)
    
    #For testing purposes
    #Net_grid_load.to_csv(temp_file, mode='a', header=False, index=False)
    data_to_append = pd.DataFrame(['peak load MW'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    data_to_append = pd.DataFrame([Net_grid_load.max().max()])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    data_to_append = pd.DataFrame(['peak generation MW'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    data_to_append = pd.DataFrame([Net_grid_load.min().min()])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    #Hours of congestion
    data_to_append = pd.DataFrame(['congestion threshold MW:'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    data_to_append = pd.DataFrame([threshold])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    data_to_append = pd.DataFrame(['hours of load congestion'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    data_to_append = pd.DataFrame([(Net_grid_load > threshold).sum().sum() * time_step])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    data_to_append = pd.DataFrame(['hours of generation congestion'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    data_to_append = pd.DataFrame([(Net_grid_load < (threshold*-1*1.05)).sum().sum() * time_step])                   #Added 1.05 for a check
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)

    #Trafo losses
    data_to_append = pd.DataFrame(['Trafo losses MVAh'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    trafo_losses = math.sqrt((df_losses_trafo_p.sum().sum() * time_step)**2 + (df_losses_trafo_q.sum().sum() * time_step)**2)
    data_to_append = pd.DataFrame([trafo_losses])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    #Line losses
    data_to_append = pd.DataFrame(['Line losses MVAh'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    line_losses = math.sqrt((df_losses_line_p.sum().sum() * time_step)**2 + (df_losses_line_q.sum().sum() * time_step)**2)
    data_to_append = pd.DataFrame([line_losses])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    #Costs of losses
    data_to_append = pd.DataFrame(['Losses costs'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    #net_load = pd.DataFrame(net_load)
    linelosses = pd.DataFrame({'totalLosses' : df_losses_line_p.sum(axis=1)})
    #print('losses')
    #print(linelosses)
    
    losses_costs = pd.DataFrame([(linelosses.iloc[:,0] * df_prices.iloc[:,0] * time_step)]).transpose()
    #losses_costs = pd.DataFrame([(linelosses * df_prices.iloc[:,0] * time_step)]).transpose()
    #print('losses costs')
    #print(losses_costs)
    data_to_append = pd.DataFrame([losses_costs[losses_costs>0].sum().sum()])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    data_to_append = pd.DataFrame([losses_costs[losses_costs<0].sum().sum()])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    #print(data_to_append)
# =============================================================================
#     losses_total = df_losses_trafo_p + df_losses_line_p #math.sqrt(df_losses_trafo_p**2 + df_losses_trafo_q**2) + math.sqrt(df_losses_line_p**2 + df_losses_line_q**2)
#     print('Losses')
#     print(losses_total)
#     
#     losses_costs = pd.DataFrame([(df_losses_line_p.iloc[:,0].sum().sum() * df_prices.iloc[:,0] * time_step) + \
#         (df_losses_trafo_p.iloc[:,0].sum().sum() * df_prices.iloc[:,0] * time_step)]).transpose()
#     print('Costs')
#     print(losses_costs)
#     data_to_append = pd.DataFrame(losses_costs.sum().sum())
#     data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
# =============================================================================
    
    
    #DSO Overrides
    data_to_append = pd.DataFrame(['DSO overrides (quarter hours per year)'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    Overrides = np.sum(DSO_overrides)
    data_to_append = pd.DataFrame([Overrides])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)

    data_to_append = pd.DataFrame(['DSO overrides (MWh hours per year)'])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    Overrides = np.sum(DSO_capacity) * time_step
    data_to_append = pd.DataFrame([Overrides])
    data_to_append.to_csv(results_file, mode='a', sep=',', float_format='%.6f', header=False, index=False)
    
    Run_Complete(start_time)
    
    return Net_grid_load

def Battery_DSO(net, output_dir, Roundtrip_Efficiency, Safety_margin, Time_step, allowed_error, 
                 load_pattern, gen_pattern, battery_locs, P_battery_max, battery_capacity, 
                 battery_pattern, battery_SOC, threshold, Net_grid_load, DSO_overrides, DSO_capacity):
    
    #df_prices = pd.read_csv(os.path.join(output_dir, "EPEX prices.csv"))
    df_load2 = pd.read_csv(os.path.join(output_dir, "res_load", "p_mw.csv"))
    df_load2 = df_load2.drop(df_load2.columns[0], axis=1)
    df_gen2 = pd.read_csv(os.path.join(output_dir, "res_sgen", "p_mw.csv"))
    df_gen2 = df_gen2.drop(df_gen2.columns[0], axis=1)
    
    runtime = len(df_load2)
    efficiency = math.sqrt(Roundtrip_Efficiency)
    n_batteries = len(battery_locs)
    totalCapacity = n_batteries * battery_capacity
    Override = np.zeros((len(df_load2), n_batteries))
    #requiredCapacity = np.zeros(len(df_load2), n_batteries)
    
    #print('test: ', Net_grid_load.iloc[1,0])
    
    #Note: Does not account for max battery capacity yet!
    for battery_nr in range(0,n_batteries):
        for i in range(0,len(df_load2)):
            if Net_grid_load.iloc[i,0] > threshold:
                print('overload: ', Net_grid_load.iloc[i,0], ' @ ', i)
                #discharge batteries
                P_discharge = (Net_grid_load.iloc[i,0] - threshold) / n_batteries * -1 * efficiency * 1.2
                Override[i,battery_nr] = 1
                if (P_discharge*-1) > P_battery_max:
                    P_discharge = P_battery_max * -1
                    Override[i,battery_nr] = 2
                print('discharge power: ', P_discharge, ' @ ', i)
                battery_pattern[i,battery_nr] = P_discharge
                print('check: ', battery_pattern[i,battery_nr])
                Override[i,battery_nr] = 1
                DSO_overrides[battery_nr]+=1
                DSO_capacity[battery_nr]+=(P_discharge/efficiency)
                        
            
            elif Net_grid_load.iloc[i,0] < (threshold*-1):
                #charge batteries
                print('underload: ', Net_grid_load.iloc[i,0], ' @ ', i)
                P_charge = (Net_grid_load.iloc[i,0] + threshold) / n_batteries * -1 * efficiency * 1.22
                Override[i,battery_nr]=1
                if P_charge > P_battery_max:
                    P_charge = P_battery_max
                    Override[i,battery_nr]=2
                battery_pattern[i,battery_nr] = P_charge
                print('charge power: ', P_charge, ' @ ', i)
                DSO_overrides[battery_nr]+=1
                DSO_capacity[battery_nr]+=(P_charge/efficiency)

    write_battery_data2(output_dir, battery_pattern, battery_SOC, Override)
    
    return battery_pattern, battery_SOC, DSO_overrides, DSO_capacity


def battery_DSO_2(net, output_dir, Roundtrip_Efficiency, Safety_margin, Time_step, allowed_error, 
                 load_pattern, gen_pattern, battery_locs, P_battery_max, battery_capacity, 
                 battery_pattern, battery_SOC, threshold, Net_grid_load, DSO_overrides, DSO_capacity, storage, netGridLoad_0):
    
    df_load2 = pd.read_csv(os.path.join(output_dir, "res_load", "p_mw.csv"))
    df_load2 = df_load2.drop(df_load2.columns[0], axis=1)
    df_gen2 = pd.read_csv(os.path.join(output_dir, "res_sgen", "p_mw.csv"))
    df_gen2 = df_gen2.drop(df_gen2.columns[0], axis=1)
    
    runtime = len(df_load2)
    efficiency = math.sqrt(Roundtrip_Efficiency)
    n_batteries = len(battery_locs)
    totalCapacity = n_batteries * battery_capacity * math.sqrt(Roundtrip_Efficiency)
    Override = np.zeros((len(df_load2), n_batteries))
    n_days = math.ceil(len(df_load2)/(24/Time_step))
          
    for day in range(0, n_days):
        #print('day: ', day)
        startTime = int(day * 24 / Time_step)
        endTime = int(startTime + 24 / Time_step)
        battery_schedule = np.zeros(int(24/Time_step))      
        #dayAhead = Net_grid_load.iloc[startTime:endTime]
        #dayAhead = dayAhead.to_numpy()
        dayAhead_0 = netGridLoad_0.iloc[startTime:endTime]
        dayAhead_0 = dayAhead_0.to_numpy()
        loadCongestion = np.zeros(int(24/Time_step))
        genCongestion = np.zeros(int(24/Time_step))
        loadThreshold = threshold
        genThreshold = threshold * -1
        
        #1) Calculate degrees of grid overloading per 15 minutes and determine if sufficient battery capacity exists
        for iteration in range(0,int(24/Time_step)):
            if dayAhead_0[iteration] > loadThreshold:
                loadCongestion[iteration] = dayAhead_0[iteration] - loadThreshold
                genCongestion[iteration] = 0
            elif dayAhead_0[iteration] < genThreshold:
                genCongestion[iteration] = dayAhead_0[iteration] - genThreshold
                loadCongestion[iteration] = 0
            else:
                loadCongestion[iteration] = 0
                genCongestion[iteration] = 0
        
        #print(1)
        #Determine MWh of overload and set thresholds
        positive_sum = loadCongestion.sum() * Time_step
        #print('pos_sum: ', positive_sum)
        if positive_sum > totalCapacity:
            loadThreshold += 0.001
            while positive_sum > totalCapacity:
                for iteration in range(0,int(24/Time_step)):
                    if dayAhead_0[iteration] > loadThreshold:
                        loadCongestion[iteration] = dayAhead_0[iteration] - loadThreshold
                    else:
                        loadCongestion[iteration] = 0
                positive_sum = loadCongestion.sum() * Time_step
                if positive_sum <= totalCapacity:
                    #break
                    loadThreshold=loadThreshold
                else:                
                    loadThreshold += 0.001
                

        negative_sum = abs(genCongestion.sum() * Time_step)
        #print('neg_sum: ', negative_sum)
        if negative_sum > totalCapacity:
            genThreshold -= 0.001
            while negative_sum > totalCapacity:
                for iteration in range(0,int(24/Time_step)):
                    if dayAhead_0[iteration] < genThreshold:
                        genCongestion[iteration] = dayAhead_0[iteration] - genThreshold
                    else:
                        genCongestion[iteration] = 0
                negative_sum = abs(genCongestion.sum() * Time_step)
                if negative_sum <= totalCapacity:
                    genThreshold=genThreshold
                else:
                    genThreshold -= 0.001

# =============================================================================
#         if loadThreshold != threshold:
#             print('newLoadThreshold: ', loadThreshold, ' @ ', startTime)
#         if abs(genThreshold) != threshold:
#             print('newGenThreshold: ', genThreshold, ' @ ', startTime)
# =============================================================================
        
        #Use battery normally?
        if negative_sum == 0 and positive_sum == 0:
            #break
             x=1   
        else:
            #Use batteries
            for battery_nr in range(0,n_batteries):
                totalCharge=0
                totalDischarge=0
                k=0
                for i in range(startTime, endTime):
                   if i >= 35132:
                       break
                   if dayAhead_0[k] > loadThreshold:
                       #print(2.1)
                       battery_pattern[i,battery_nr] = (dayAhead_0[k]-loadThreshold) / n_batteries * -1 #*1.1
                       if abs(battery_pattern[i,battery_nr]) > P_battery_max:
                           battery_pattern[i,battery_nr] = P_battery_max*-1
                       DSO_overrides[battery_nr] += Time_step
                       DSO_capacity[battery_nr] += abs(battery_pattern[i,battery_nr]*Time_step)
                       totalDischarge += abs(battery_pattern[i,battery_nr]*Time_step) / math.sqrt(Roundtrip_Efficiency)
                    
                   elif dayAhead_0[k] < genThreshold:
                       #print(2.2)
                       battery_pattern[i,battery_nr] = (dayAhead_0[k]-genThreshold) / n_batteries * -1 #* 1.05
                       if abs(battery_pattern[i,battery_nr]) > P_battery_max:
                           battery_pattern[i,battery_nr] = P_battery_max
                       DSO_overrides[battery_nr] += 1
                       DSO_capacity[battery_nr] += abs(battery_pattern[i,battery_nr]*Time_step)
                       totalCharge += abs(battery_pattern[i,battery_nr]*Time_step) * math.sqrt(Roundtrip_Efficiency)
                   else:
                       battery_pattern[i,battery_nr] = 0
                   k+=1
                
                #Pre-charge/discharge battery
                for i in range(startTime, endTime):
                    if i >= 35132 or (totalDischarge <= 0 and totalCharge <= 0):
                        break
                    #Pre-charge
                    if battery_pattern[i,battery_nr] < 0:
                        j=i-1
                        Pre_charge = False
                        while Pre_charge == False:
                            if j < startTime or totalDischarge <= 0:
                                Pre_charge = True
                            elif battery_pattern[j, battery_nr] == 0:
                                if netGridLoad_0.iloc[j,0] + abs(battery_pattern[i,battery_nr])*-1*n_batteries < threshold:
                                    battery_pattern[j,battery_nr] = battery_pattern[i,battery_nr]*-1
                                    DSO_overrides[battery_nr] += Time_step
                                    Pre_charge=True
                                    totalDischarge -= abs(battery_pattern[j,battery_nr]*Time_step)
                            j-=1
                
                    #Pre-discharge
                    if battery_pattern[i,battery_nr] > 0:
                        j=i-1
                        Pre_discharge=False
                        while Pre_discharge==False:
                            if j < startTime or totalCharge <= 0:
                                Pre_discharge=True
                            elif battery_pattern[j,battery_nr]==0:
                                if netGridLoad_0.iloc[j,0] + abs(battery_pattern[i,battery_nr])*-1*n_batteries > (threshold*-1):
                                    battery_pattern[j,battery_nr] = battery_pattern[i,battery_nr]*-1
                                    DSO_overrides[battery_nr] += Time_step
                                    Pre_discharge=True
                                    totalCharge -= abs(battery_pattern[j,battery_nr]*Time_step)
                            j-=1

    write_battery_data2(output_dir, battery_pattern, battery_SOC, Override)
    
    return battery_pattern, battery_SOC, DSO_overrides, DSO_capacity

def Battery_priceDriven(net, output_dir, Roundtrip_Efficiency, Safety_margin, Time_step, allowed_error, 
                 load_pattern, gen_pattern, battery_locs, P_battery_max, battery_capacity, battery_pattern, 
                 battery_SOC, minProfit, taxes=1, capPrice=0, capOn=False, injectionFee=0):
    
    df_prices = pd.read_csv(os.path.join(output_dir, "EPEX prices.csv"))
    df_load2 = pd.read_csv(os.path.join(output_dir, "res_load", "p_mw.csv"))
    df_load2 = df_load2.drop(df_load2.columns[0], axis=1)
    df_gen2 = pd.read_csv(os.path.join(output_dir, "res_sgen", "p_mw.csv"))
    df_gen2 = df_gen2.drop(df_gen2.columns[0], axis=1)
    
    runtime = len(df_load2)
    #battery_pattern = np.empty(shape=(runtime, len(battery_locs)), dtype='object')
    efficiency = math.sqrt(Roundtrip_Efficiency)
    
    battery_nr=0
    for battery in battery_locs:
        for day in range(0, int(runtime*Time_step/24)+1):
            startTime = int(day * 24 / Time_step)
            endTime = int(startTime + 24 / Time_step)
            battery_schedule = np.zeros(int(24/Time_step))      
            dayAhead = df_prices.iloc[startTime:endTime]
            dayAhead = dayAhead.to_numpy()
            #maxSignals = int(math.ceil(battery_capacity / (P_battery_max)) / Time_step)
            #print('maxSignals: ', maxSignals)
            #signals = 0
            
            #1) Plan battery schedule
            iteration=0
            cycles=0
            #for iteration in range(0,maxSignals):
            while cycles<1:
                lowestPrice = 1000
                lowestPriceTime = -1
                highestPrice = 0
                highestPriceTime = -1
                
                for i in range(0,96):
                    if dayAhead[i] < lowestPrice and battery_schedule[i] == 0:
                        lowestPrice = dayAhead[i]
                        lowestPriceTime = i
                    if dayAhead[i] > highestPrice and battery_schedule[i] == 0:
                        highestPrice = dayAhead[i]
                        highestPriceTime = i
                
                #Check for capPrice
                if capOn == True:

                    Profitable=False
                    netLoad = df_load2[lowestPriceTime+startTime,10] - df_gen2[lowestPriceTime+startTime,10]
                    netLoad2 = df_load2[highestPriceTime+startTime,10] - df_gen2[highestPriceTime+startTime,10]
                    
                    profits=0
                    for P_battery in [0.5,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]:
                        if P_battery > P_battery_max:
                            P_battery = P_battery_max
                        Fine = CapPrice(netLoad+P_battery,capPrice)*(netLoad+P_battery)*Time_step + \
                            CapPrice(netLoad2+P_battery,capPrice)*(netLoad2+P_battery)*Time_step
                        
                        if ((highestPrice * (netLoad2+P_battery) * (1-taxes) - lowestPrice * (netLoad+P_battery)) * Roundtrip_Efficiency * Time_step) - Fine > profits:
                            profits = ((highestPrice * (netLoad2+P_battery) * (1-taxes) - lowestPrice * (netLoad+P_battery)) * Roundtrip_Efficiency * Time_step) - Fine
                            P_battery_constrained = P_battery
                    
                    if P_battery_constrained < P_battery_max:
                        print('Constraint: ', P_battery_constrained)
                    
                    if profits > 0:
                    #if ((highestPrice * (1-taxes) - lowestPrice) * Roundtrip_Efficiency) - Fine > minProfit:
                        battery_schedule[lowestPriceTime] = 1
                        battery_schedule[highestPriceTime] = -1
                        #signals+=1
                        cycles += P_battery_constrained*Time_step/battery_capacity
                        if cycles>1:
                            cycles-=P_battery_constrained*Time_step/battery_capacity
                            fraction = (1-cycles)*battery_capacity/Time_step/P_battery_constrained
                            cycles=1
                            battery_schedule[lowestPriceTime] = fraction
                            battery_schedule[highestPriceTime] = fraction*-1
                    
                    else:
                        break
                    
                
                elif ((highestPrice * (1-taxes) - lowestPrice) * Roundtrip_Efficiency) > minProfit and cycles<1:
                    battery_schedule[lowestPriceTime] = 1
                    battery_schedule[highestPriceTime] = -1
                    #signals+=1
                    cycles += P_battery_max*Time_step/battery_capacity
                    if cycles>1:
                        cycles-=P_battery_max*Time_step/battery_capacity
                        fraction = (1-cycles)*battery_capacity/Time_step/P_battery_max
                        cycles=1
                        battery_schedule[lowestPriceTime] = fraction
                        battery_schedule[highestPriceTime] = fraction*-1
                else:
                    break
            
            #2) Implement battery schedule
            #print(dayAhead)
            #print(battery_schedule)
            
            j = 0
            for i in range(startTime,endTime):
                if i > 35131:
                    break
                if battery_schedule[j] > 0:# and battery_SOC[i-1,battery_nr] < 1:
                    #Charge battery
                    battery_pattern[i,battery_nr] = P_battery_max * battery_schedule[j]
# =============================================================================
#                     if battery_SOC[i-1,battery_nr] + P_battery_max * efficiency * Time_step / battery_capacity < 1:
#                         battery_SOC[i,battery_nr] = battery_SOC[i-1,battery_nr] + P_battery_max * battery_schedule[j] * efficiency * Time_step / battery_capacity
#                         battery_pattern[i,battery_nr] = P_battery_max * battery_schedule[j]
#                     else:    
#                         battery_SOC[i,battery_nr] = 1
#                         battery_pattern[i,battery_nr] = (1-battery_SOC[i-1,battery_nr]) * battery_capacity / Time_step / efficiency
# =============================================================================
                    
                elif battery_schedule[j] < 0:# and battery_SOC[i-1,battery_nr] > 0:
                    #Discharge battery
                    battery_pattern[i,battery_nr] = P_battery_max * battery_schedule[j] * Roundtrip_Efficiency
# =============================================================================
#                     if battery_SOC[i-1,battery_nr] - P_battery_max * Time_step / battery_capacity > 0:
#                         battery_SOC[i,battery_nr] = battery_SOC[i-1,battery_nr] - P_battery_max * battery_schedule[j] * efficiency * Time_step / battery_capacity
#                         battery_pattern[i,battery_nr] = P_battery_max * -1 * efficiency
#                     else:
#                         battery_SOC[i,battery_nr] = 0
#                         battery_pattern[i,battery_nr] = battery_SOC[i-1,battery_nr] * battery_capacity * efficiency / Time_step * -1
#                 else:
#                     battery_SOC[i,battery_nr] = battery_SOC[i-1,battery_nr]
#                     battery_pattern[i,battery_nr] = 0
# =============================================================================
                else:
                    battery_pattern[i,battery_nr] = 0
                j+=1
        battery_nr+=1
    
    #print(battery_pattern)

    write_battery_data(output_dir, battery_pattern, battery_SOC)
    
    return battery_pattern, battery_SOC

def Test():
    capPrice = [0.0,0.025,0.05,0.075,0.1,0.125,0.15]
    print(CapPrice(4.5,capPrice))
    print(CapPrice(21,capPrice))
    print(CapPrice(15.1, capPrice))
    

def CapPrice(power, capPrice):    
    netLoad = abs(power)
    index=0
    if netLoad < 5:
        index = 0
    elif netLoad < 7.5:
        index = 1
    elif netLoad < 10:
        index = 2
    elif netLoad < 12.5:
        index = 3
    elif netLoad < 15:
        index = 4
    elif netLoad < 17.5:
        index = 5
    else:
        index = 6
    
    return capPrice[index]


def Battery_selfConsumption(net, output_dir, Roundtrip_Efficiency, Safety_margin, Time_step, allowed_error, 
                 load_pattern, gen_pattern, battery_locs, P_battery_max, battery_capacity, battery_pattern, battery_SOC):
    
    df_prices = pd.read_csv(os.path.join(output_dir, "EPEX prices.csv"))
    #df_battery_SOC = pd.read_csv(os.path.join(output_dir, "Battery SOC.csv"))
    #battery_SOC = df_battery_SOC.to_numpy()
    df_load2 = pd.read_csv(os.path.join(output_dir, "res_load", "p_mw.csv"))
    df_load2 = df_load2.drop(df_load2.columns[0], axis=1)
    df_gen2 = pd.read_csv(os.path.join(output_dir, "res_sgen", "p_mw.csv"))
    df_gen2 = df_gen2.drop(df_gen2.columns[0], axis=1)
    
    
    #runtime = int(366*24/Time_step)
    runtime = len(df_load2)
    #battery_pattern = np.empty(shape=(runtime, len(battery_locs)), dtype='object')
    efficiency = math.sqrt(Roundtrip_Efficiency)
    
    print('battery LOCs:')
    print(battery_locs)
    
    battery_nr=0
    for battery in range(0,len(battery_locs)):
        battery_SOC[0,battery_nr]=int(0)
        battery_nr += 1
    
    battery_nr=0
    for battery in battery_locs:
        print('battery loc: ', battery)
        print('battery #', battery_nr)
        
        for i in range(1,runtime):
            
            #print(df_gen2.iloc[i,battery])
            #print(df_load2.iloc[i,battery])
            #print(battery_SOC[i-1,battery_nr])
            
            if df_gen2.iloc[i,battery] > df_load2.iloc[i,battery] and battery_SOC[i-1,battery_nr] < 1: # and battery_SOC[i,battery_nr] != 0:
                #charge battery
                if (df_gen2.iloc[i,battery] - df_load2.iloc[i,battery]) > P_battery_max:
                    if (battery_SOC[i-1,battery_nr] + P_battery_max * Time_step / battery_capacity * efficiency) > 1:
                        battery_pattern[i,battery_nr] = (1 - battery_SOC[i-1,battery_nr]) * battery_capacity / Time_step
                        battery_SOC[i,battery_nr] = 1
                    else:
                        battery_pattern[i,battery_nr] = P_battery_max
                        battery_SOC[i,battery_nr] = battery_SOC[i-1,battery_nr] + P_battery_max * Time_step * efficiency / battery_capacity
                else:
                    P_battery = df_gen2.iloc[i,battery] - df_load2.iloc[i,battery] 
                    if (battery_SOC[i-1,battery_nr] + P_battery * Time_step / battery_capacity * efficiency) > 1:
                        battery_pattern[i,battery_nr] = (1 - battery_SOC[i-1,battery_nr]) * battery_capacity / Time_step
                        battery_SOC[i,battery_nr] = 1
                    else:
                        battery_pattern[i,battery_nr] = P_battery
                        battery_SOC[i,battery_nr] = battery_SOC[i-1,battery_nr] + P_battery * Time_step * efficiency / battery_capacity
            elif df_load2.iloc[i,battery] > df_gen2.iloc[i,battery] and battery_SOC[i-1,battery_nr] > 0: # and battery_SOC[i,battery_nr] != 0:
                #discharge battery
                if (df_load2.iloc[i,battery] - df_gen2.iloc[i,battery]) > P_battery_max:
                    if (battery_SOC[i-1,battery_nr] - P_battery_max * Time_step / battery_capacity * efficiency) < 0:
                        battery_pattern[i,battery_nr] = battery_SOC[i-1,battery_nr] * battery_capacity * efficiency / Time_step * -1
                        battery_SOC[i,battery_nr] = 0
                    else:
                        battery_pattern[i,battery_nr] = -1 * P_battery_max
                        battery_SOC[i,battery_nr] = battery_SOC[i-1,battery_nr] - P_battery_max * Time_step / battery_capacity
                else:
                    P_battery = df_load2.iloc[i,battery] - df_gen2.iloc[i,battery]
                    if (battery_SOC[i-1,battery_nr] - P_battery * Time_step / battery_capacity * efficiency) < 0:
                        battery_pattern[i,battery_nr] = battery_SOC[i-1,battery_nr] * battery_capacity * efficiency / Time_step * -1
                        battery_SOC[i,battery_nr] = 0
                    else:
                        battery_pattern[i,battery_nr] = -1 * P_battery
                        battery_SOC[i,battery_nr] = battery_SOC[i-1,battery_nr] - P_battery * Time_step / battery_capacity
# =============================================================================
#             elif battery_SOC[i,battery_nr] != 0:
#                 battery_pattern[i,battery_nr] = 0
#                 battery_SOC[i,battery_nr] = battery_SOC[i-1,battery_nr]
# =============================================================================
            else:
                battery_SOC[i,battery_nr] = battery_SOC[i-1,battery_nr]
                battery_pattern[i,battery_nr] = 0

        battery_nr+=1

    
    #battery_pattern = battery_pattern/1000
    write_battery_data(output_dir, battery_pattern, battery_SOC)
    
    return battery_pattern, battery_SOC

def battery_reset(runtime, battery_locs, reset_value):
    print('runtime: ', runtime)
    print('n_batteries: ', len(battery_locs))
    battery_pattern = np.empty(shape=(runtime, len(battery_locs)), dtype='float')
    battery_pattern.fill(reset_value)
    battery_SOC = np.empty(shape=(runtime, len(battery_locs)), dtype='float')
    battery_SOC.fill(reset_value)

    return battery_pattern, battery_SOC

def write_battery_data(output_dir, battery_pattern, battery_SOC):
    WriteFile = os.path.join(output_dir, "Battery Pattern.csv")
    df_battery = pd.DataFrame(battery_pattern)
    df_battery.to_csv(WriteFile)
    
    WriteFile = os.path.join(output_dir, "Battery SOC.csv")
    df_battery_SOC = pd.DataFrame(battery_SOC)
    df_battery_SOC.to_csv(WriteFile)


def write_battery_data2(output_dir, battery_pattern, battery_SOC, Override=0):
    WriteFile = os.path.join(output_dir, "Battery Pattern.csv")
    df_battery = pd.DataFrame(battery_pattern)
    df_battery.to_csv(WriteFile)
    
    WriteFile = os.path.join(output_dir, "Battery SOC.csv")
    df_battery_SOC = pd.DataFrame(battery_SOC)
    df_battery_SOC.to_csv(WriteFile)
    
    WriteFile = os.path.join(output_dir, "Override.csv")
    df_override = pd.DataFrame(Override)
    df_override.to_csv(WriteFile)

def Run_Complete(start_time):
    print("Done!")
    frequency = 1500  # Set Frequency To 2500 Hertz
    duration = 500  # Set Duration To 1000 ms == 1 second
    #winsound.Beep(frequency, duration)
    print('elapsed time: %s minutes' % ((time.time() - start_time)/60))

def Draw_Plots(net, output_dir, DrawPlots=True, DrawStorage=False):    
    #DrawPlots = True
    
    if DrawPlots == True:
        # Plot results
        #%matplotlib inline
        from pandapower.plotting import simple_plot, simple_plotly, pf_res_plotly, pf_res_plotly
        #pf_res_plotly(net, figsize = 5)
        #pp.plotting.plotly.simple_plotly(net, figsize=5, respect_switches=True)
# =============================================================================
#         # voltage results
#         vm_pu_file = os.path.join(output_dir, "res_bus", "vm_pu.xlsx")
#         vm_pu = pd.read_excel(vm_pu_file, index_col=0)
#         vm_pu.plot(label="vm_pu", legend=None)
#         plt.xlabel("time step")
#         plt.ylabel("voltage mag. [p.u.]")
#         plt.title("Voltage Magnitude")
#         plt.grid()
#         plt.show()
#         
#         # line loading results
#         ll_file = os.path.join(output_dir, "res_line", "loading_percent.xlsx")
#         line_loading = pd.read_excel(ll_file, index_col=0)
#         line_loading.plot(label="line_loading", legend=None)
#         plt.xlabel("time step")
#         plt.ylabel("line loading [%]")
#         plt.title("Line Loading")
#         plt.grid()
#         #plt.legend(bbox_to_anchor=(1.05, 1.0), loc='upper left')
#         plt.show()
#         
#         # load results
#         load_file = os.path.join(output_dir, "res_load", "p_mw.xlsx")
#         load = pd.read_excel(load_file, index_col=0)
#         load.plot(label="load", legend=None)
#         plt.xlabel("time step")
#         plt.ylabel("P [MW]")
#         plt.title("Load Profiles")
#         plt.grid()
#         #plt.legend(bbox_to_anchor=(1.05, 1.0), loc='upper left')
#         plt.show()
# =============================================================================
        
        #Trafo
        trafo_file = os.path.join(output_dir, "res_trafo", "loading_percent.csv")
        load_per = pd.read_csv(trafo_file, index_col=0)
        load_per.plot(label="load", legend=None)
        plt.xlabel("time step")
        plt.ylabel("Trafo loading [%]")
        plt.title("Trafo Loading")
        plt.grid()
        #plt.legend(bbox_to_anchor=(1.05, 1.0), loc='upper left')
        plt.show()
        
# =============================================================================
#         trafo_file_2 = os.path.join(output_dir, "res_trafo", "p_lv_mw.xlsx")
#         load = pd.read_excel(trafo_file_2, index_col=0)
#         load.plot(label="load", legend=None)
#         plt.xlabel("time step")
#         plt.ylabel("Trafo loading [MW]")
#         plt.title("Trafo Loading")
#         plt.grid()
#         #plt.legend(bbox_to_anchor=(1.05, 1.0), loc='upper left')
#         plt.show()
# =============================================================================
    
def Plot_Grid(net):
    #Plot grid
# =============================================================================
#     from pandapower.plotting import simple_plot, simple_plotly, pf_res_plotly
#     pp.plotting.plotly.simple_plotly(net, figsize=5, respect_switches=True)
# =============================================================================
    print('Plotting...')
    from pandapower.plotting import simple_plot, simple_plotly, pf_res_plotly, pf_res_plotly
    pf_res_plotly(net, figsize = 5)
    
def Plot_Grid_Results(net):
    from pandapower.plotting import simple_plot, simple_plotly, pf_res_plotly, pf_res_plotly
    pf_res_plotly(net, figsize = 5)
    
def Grid_test():
    net = pp.create_empty_network(name="Case", f_hz=50.0)
    for trafo in range(0,2):
        mv_bus = pp.create_bus(net, name = "Bus_MV%i" % trafo, vn_kv=10, type='n')
        lv_bus = pp.create_bus(net, name = "Bus_LV%i" % trafo, vn_kv=0.4, type='n') 
        pp.create_ext_grid(net, pp.get_element_index(net, "bus", "Bus_MV%i" % trafo),
                       vm_pu=1.0, va_degrees=0, name="External_grid%i" % trafo,
                       s_sc_max_mva=10, rx_max=0.1, rx_min=0.1)

        trafo_type = '0.4 MVA 10/0.4 kV'
        trafo_index = pp.create_transformer(net, mv_bus, lv_bus, std_type = trafo_type, name = "MV-LV-Trafo%i" % trafo)
        pp.create_switch(net, mv_bus, trafo_index, et='t', closed=True, type='LBS', name='Switch MV%i' % trafo)
        pp.create_switch(net, lv_bus, trafo_index, et='t', closed=True, type='LBS', name='Switch LV%i' % trafo)
        
    for line in range(0,9):
        for house in range(0,12):
            if house==0:
                if line<5:
                    from_bus = pp.get_element_index(net, "bus", 'Bus_LV0')
                else:
                    from_bus = pp.get_element_index(net, "bus", 'Bus_LV1')
            to_bus = pp.create_bus(net, name='Bus_LV%s.%s' % (line, house), 
                              vn_kv=0.4, type='n') #, geodata=bus_coords)
            pp.create_load(net=net, bus=to_bus, p_mw=0.000001, q_mvar=0.000001, 
                                   name = 'Load_LV%s.%s' % (line, house))
            pp.create_sgen(net=net, bus=to_bus,  p_mw=0.000001, q_mvar=0.000001,
                                   name = 'Gen_LV%s.%s' % (line, house))
            line_type = 'NAYY 4x120 SE'
            pp.create_line(net, from_bus, to_bus, length_km=10/1000,
                           std_type=line_type, name='line_LV%s.%s' % (line,house))
            from_bus = to_bus
    
    #Generate Switches  
    lv_buses = net.bus[net.bus.vn_kv == 0.4]
    #print(lv_buses)
    lv_ls = net.line[(net.line.from_bus.isin(lv_buses.index)) & (net.line.to_bus.isin(lv_buses.index))]
    for _, line in lv_ls.iterrows():
            pp.create_switch(net, line.from_bus, line.name, et='l', closed=True, type='LBS', 
                             name='Switch_%s.%s' % (net.bus.name.at[line.from_bus], line['name']))
            pp.create_switch(net, line.to_bus, line.name, et='l', closed=True, type='LBS', 
                             name='Switch_%s.%s' % (net.bus.name.at[line.to_bus], line['name']))
    return net

def place_batteries(net, battery_locs, P_battery_max, battery_capacity):
    battery_nr=0
    for battery_bus in battery_locs:
        pp.create_storage(net, bus=battery_bus, p_mw=P_battery_max/1000, max_e_mwh=battery_capacity/1000)
        print('battery #%s: %s' % (battery_nr, battery_bus))
        battery_nr += 1
    return net

def AnalysisTest():
    net = pp.from_pickle("WorkingDoc.p", convert=True)
    input_file = r"C:\Users\soch\OneDrive - Hanzehogeschool Groningen\PhD\Papers\Journal Article 2\Model\Ansen Summary Data - Working.xlsx"
    load_pattern = r"C:\Users\soch\OneDrive - Hanzehogeschool Groningen\PhD\Papers\Journal Article 2\Model\Load Pattern.csv"
    gen_pattern = r"C:\Users\soch\OneDrive - Hanzehogeschool Groningen\PhD\Papers\Journal Article 2\Model\Generation Pattern.csv"
    battery_dir = r"C:\Users\soch\OneDrive - Hanzehogeschool Groningen\PhD\Papers\Journal Article 2\Model\Battery Pattern.csv"
    battery_pattern = pd.read_csv(battery_dir)
    output_dir = r"C:\Users\soch\OneDrive - Hanzehogeschool Groningen\PhD\Papers\Journal Article 2\Model"    
    battery_locs = [9,11,20,48,67,73,83,90,96]
    cycle_efficiency=0.9
    time_step = 0.25
    threshold = 0.8
    DSO_overrides = [9,11,20,48,67,73,83,90,96]
    DSO_capacity = [9,11,20,48,67,73,83,90,96]
    
    for scenario in range(0,1):
        print('so far so good')
        Analyze_KPIs(net, output_dir, battery_locs, cycle_efficiency, load_pattern, 
                     gen_pattern, battery_pattern, scenario, time_step, DSO_overrides, threshold, DSO_capacity)



    
    
    
    
    
    