%{
Created in 2023
@author: Jana Marie Spaeth, Konstantina Kolovou Kouri
%}

clear
M1 = readmatrix("scope_43.csv");
t1 = (M1(4:end, 1) - M1(4,1))*1000;
V1_Ch1 = M1(4:end, 2);
V1_Ch2 = M1(4:end, 3);
V1_Ch3 = M1(4:end, 4);
V1_Ch4 = M1(4:end, 5);
M3 = readmatrix("scope_47.csv");
t3 = (M3(4:end, 1) - M3(4,1))*1000;
V3_Ch1 = M3(4:end, 2);
V3_Ch2 = M3(4:end, 3);
V3_Ch3 = M3(4:end, 4);
V3_Ch4 = M3(4:end, 5);
M10 = readmatrix("scope_51.csv");
t10 = (M10(4:end, 1) - M10(4,1))*1000;
V10_Ch1 = M10(4:end, 2);
V10_Ch2 = M10(4:end, 3);
V10_Ch3 = M10(4:end, 4);
V10_Ch4 = M10(4:end, 5);

M1s = readmatrix("scope_40.csv");
t1s = (M1s(14:end, 1) - M1s(14,1))*1000;
V1_Ch3s = M1s(14:end, 4);

M3s = readmatrix("scope_44.csv");
t3s = (M3s(4:end, 1) - M3s(4,1))*1000;
V3_Ch3s = M3s(4:end, 4);

M10s = readmatrix("scope_48.csv");
t10s = (M10s(4:end, 1) - M10s(4,1))*1000;
V10_Ch3s = M10s(4:end, 4);


figure()
tiledlayout(3,1)
set(gcf,'color','w');
set(gcf,'position',[10,10,800,500])

ax1 = nexttile();
plot(t1,V1_Ch2,t3,V3_Ch2,t10,V10_Ch2,'g', 'LineWidth', 1)
ylabel('Voltage [V]')
%ax1.TitleHorizontalAlignment = 'left'; 
legend('\tau_i_n_t = 1 ms', '\tau_i_n_t = 3 ms', '\tau_i_n_t = 10 ms')
grid('on')
ax = gca; 
ax.FontSize = 14; 

ax2 = nexttile();
plot(t1,V1_Ch3/10,t3,V3_Ch3/10,t10,V10_Ch3/10,'g', 'LineWidth', 1)
ylabel('Current [mA]')
xlabel('Time [ms]')
%legend('\tau_i_n_t = 1 ms', '\tau_i_n_t = 3 ms', '\tau_i_n_t = 10 ms')
%title('(b)')
%ax2.TitleHorizontalAlignment = 'left'; 
grid('on')
ax = gca; 
ax.FontSize = 14;

ax3 = nexttile();
plot(t1s,V1_Ch3s/10,t3s,V3_Ch3s/10,t10s,V10_Ch3s/10,'g', 'LineWidth', 1)
ylabel('Current [mA]')
xlabel('Time [ms]')
%legend('\tau_i_n_t = 1 ms', '\tau_i_n_t = 3 ms', '\tau_i_n_t = 10 ms')
%title('(c)')
%ax3.TitleHorizontalAlignment = 'left'; 
grid('on')
ax = gca; 
ax.FontSize = 14;



