%{
Created in 2023
@author: Jana Marie Spaeth, Konstantina Kolovou Kouri
%}

load('ScopeData.mat')
t=(ScopeData{1}.Values.Time(500001:505000)-ScopeData{1}.Values.Time(500001))*1000;
v_elec=ScopeData{1}.Values.Data(500001:505000);
i_in=ScopeData{2}.Values.Data(500001:505000)*1000;
i_corr=ScopeData{3}.Values.Data(500001:505000)*1000;
v_elec_no_CB=ScopeData{4}.Values.Data(1:5000);
i_elec=ScopeData{5}.Values.Data(500001:505000)*1000;

figure()
tiledlayout(2,1)
set(gcf,'color','w');
set(gcf,'position',[10,10,800,500])

nexttile
plot(t,i_elec,t,i_in,'-.',t,i_corr,'--g', 'LineWidth', 1);
grid('on')
ylabel('Current [mA]')
%title('Electrode Current with 20 % Mismatch')
legend('With Charge Balancing', 'No Charge Balancing', 'Corrective Current')
ylim([-1.3 1.3])
ax = gca; 
ax.FontSize = 14;

nexttile
plot(t,v_elec,t,v_elec_no_CB,'-.', 'LineWidth', 1);
grid('on')
%title('Electrode Voltage with 20 % Mismatch')
legend('With Charge Balancing', 'No Charge Balancing')
xlabel('Time [ms]')
ylabel('Voltage [V]')
ax = gca; 
ax.FontSize = 14;
