# Property-Based Testing in Java with jqwik

This dataset was collected as part of a research study analyzing open-source Java repositories that utilize the jqwik framework for property-based testing. The results can be found in [1]. Below, we describe a detailed explanation of what can be found in each sheet of the document, along with an explanation of how the data was collected.

## Document Sheets

This section describes the data that can be found in each sheet.

### Overview Sheet

This sheet contains an overview of all the repositories and the most significant findings in each of them. The data in this sheet is gathered automatically from the other sheets using an automated script that triggers whenever a change or an edit is made in the document.

An explanation of each metric can be found in the table below.

| Table | Metric | Explanation |
| ----- | ------ | ----------- |
| Repository Overview | `Repository` | The name of the analyzed repository |
| Repository Overview | `Amount of PBTs` | The number of property-based tests analyzed in the respective repository |
| Repository Overview | `Stars` | The number of Github stars the repository had at the time of examination |
| Totals | `Repositories` | The total number of analyzed repositories |
| Totals | `PBTs` | The total number of analyzed PBTs | 
| Totals | `Use Custom Generators` | The total number of PBTs that used custom generators |
| Totals | `Assert Exceptions` | The total number of PBTs that assert exceptions |
| Totals | `Can Be Decomposed` | The total number of PBTs that can be decomposed |
| Totals | `Filtered Input` | The total number of PBTs that filtered their generated input |
| Category Counts | `Category` | The categories that we assigned to the PBTs |
| Category Counts | `Count` | The number of PBTs that had the respective category assigned to them |
| Nrs of Tries for PBTs | `Nr of Tries` | The values used as "number of tries" for the analyzed PBTs |
| Nrs of Tries for PBTs | `Occurences` | How many times each value has been encountered |

### Repository Sheets

All the other sheets in the document are for individual repositories. They contain more detailsa about the repositories and the data gathered from each PBT. Each sheet also contains a table with explanations about the categories we assigned to the PBTs.

An explanation of each column can be found in the table below

| Table | Metric | Explanation |
| ----- | ------ | ----------- |
| Repository Checklist | `Name` | Contains a hyperlink with the name of the repository that links to an archived page of the repository |
| Repository Checklist | `⭐Stars/Popularity` | The number of Github stars the repository had at the time of examination |
| Repository Checklist | `Lines of Code` | The number of lines of code each repository had in total, along with the number and percentage of Java lines |
| Repository Checklist | `PBT Density` | The number of property-based tests compared to the total number of tests in the repository |
| Repository Checklist | `Version` | The version of the repository that we analyzed |
| Repository Checklist | `Summary` | A short summary of the repository |
| Test Checklist | `PBT Test Count` | The number of tests that the row in this table is referring to. We grouped some of the PBTs together because of how simillar they were. |
| Test Checklist | `Tested Method` | The method(s) or functionality that was tested in the PBT |
| Test Checklist | `File` | The file in which the PBT(s) are located |
| Test Checklist | `Assertion Count` | The number of assertions the PBT(s) had. |
| Test Checklist | `Can it be decomposed?` | Whether or not the PBT can be decomposed into multiple properties |
| Test Checklist | `what does it test?` | If it tests functionality, the environment or integration. These are the only possible answers |
| Test Checklist | `Functional or non-functional property` | If it tests a functional or a non-functional property. These are the only possible answers. |
| Test Checklist | `Property Category` | The categories (labels) assigned to each repository. It can have mutliple categories. |
| Test Checklist | `Assumptions?` | If the PBT makes any assumptions |
| Test Checklist | `Type of Input` | Explanations for the input(s) generated for the PBT |
| Test Checklist | `General Input Type` | The general input types for each PBT. Contains one or more options from the following list: `Numerical`, `Character`, `String`, `Boolean`, `List`, `Tuple`, `Dictionary`, `Arbitrary`, `SUT Instance`, and `Enum`. |
| Test Checklist | `Filtered Input` | If the PBT(s) filtered their generated input |
| Test Checklist | `Custom Generator?` | If the PBT(s) used a custom generators |
| Test Checklist | `Input used directly?` | If the PBT(s) used their generated input directly |
| Test Checklist | `Custom Shrinker?` | If the PBT(s) used a custom shrinker |
| Test Checklist | `Does it assert exceptions or errors?` | If the PBT(s) had assertions for exceptions |
| Test Checklist | `Nr of tries` | The number of times jqwik was configured to run the PBT(s) |
| Test Checklist | `Notes` | Other remarks worth investigating |

## PBT Labels

Each of the analyzed property-based tests had at least one category assigned to them. Below is a list of all the categories and their explanations. 

| Category | Explanation |
| -------- | ----------- |
| `Different Paths` | Combining operations in different orders to get to the same result |
| `Round Trip` | Combine an operation with its inverse (exp: encode and decode to get to the same input) |
| `Invariant` | A property that doesn't change during execution |
| `Test Oracle` | Test results against an alternate version of the code/algorithm |
| `Hard to Prove, Easy to Verify` | It's difficult to formally prove the code's correctness but easy to verify that the result it gives is correct |
| `Idempotence` | Doing the same operation more than once is the same as doing it once |
| `Structural Induction` | Prove that a property holds for a smaller set of the input to prove it holds for the entire input |
| `Mutation` | Makes a valid or intended change in the state of the system under test |

## Methodology for collecting data

We used several tools to find open-source Java repositories, including [GitHub's](https://github.com/) advanced search engine, [SourceGraph](https://sourcegraph.com/search), and [Maven Repository](https://mvnrepository.com/). We searched for repositories that listed jqwik as a dependency and that imported jqwik's `@Property` annotation for marking a test as a PBT. We also prioritized the most popular repositories we could find, measured in GitHub stars. 

To analyze the data, we conducted a qualitative analysis of the repositories we found, using inductive coding to categorize the properties identified in each PBT. This method involves creating labels directly from the data instead of making a list beforehand. As we examined each repository, we iteratively refined the existing codes and added new ones to highlight existing patterns. The process required multiple passes through the data to ensure that the resulting categories were accurate and meaningful in representing the diverse uses of property-based testing.

## References

[1]&nbsp;&nbsp; H. Toth, *Property-Based Testing in the Wild!: Exploring Property-Based Testing in Java: An Analysis of jqwik Usage in Open-Source Repositories*. Bachelor Thesis, Delft University of Technology, 2025.