# Property-Based Testing in Rust with Quickcheck

## Contents of this Repository

 - [data.xlsx](./data/data.xlsx): The full raw dataset (with notes) in Microsoft Excel format
 - [repos.tsv](./data/repos.tsv): The exported `Repositories` sheet from `data.xlsx` in tab-separated value format
 - [tests.tsv](./data/tests.tsv): The exported `Properties` sheet from `data.xlsx` in tab-separated value format, post-processed for better integration with the other datasets

## Repository Data

| Field | Type | Description |
| ----- | ---- | ----------- |
| `name` | `string` | The name of the repository |
| `link` | `string` | A GitHub link to the repository |
| `version` | `string` | The version of the repository which was analyzed |
| `github_stars` | `numeric` | The number of GitHub stars at the time of analysis |
| `downloads_all_time` | `numeric` | The total number of downloads the repository has on `crates.io` |
| `amt_versions` | `numeric` | The total number of versions published on `crates.io` |
| `first_release` | `date` | The first release of the repository on GitHub |
| `amt_dependents` | `numeric` | The number of reverse dependencies on `crates.io` |
| `regular_tests` | `numeric` | The number of non-PBT tests in the repository (naively counted) |
| `pbts` | `numeric` | The number of written PBTs in the repository (not accounting for macro expansion) |
| `pbts_expanded` | `numeric` | The number of PBTs in the repository after macro expansion |

## Test Data

| Field | Type | Description |
| ----- | ---- | ----------- |
| `name` | `string` | The name of the test as it appears in the code |
| `repo` | `string` | The name of the repository from which the test originates |
| `link` | `string` | A GitHub permalink to the first line of the PBT in the code |
| `summary` | `string` | A brief summary of what the test does |
| `redundant` | `bool` | Whether or not the test is analytically identical to a previously analyzed test |
| `amt_assertions` | `numeric` | The total number of assertions which appear in the test |
| `are_assertions_independent` | `bool?` | Whether or not any of the assertions depend on each other; `-` when there is only one assertion |
| `can_decompose_property` | `bool` | Whether or not the property could be decomposed by naive vertical decomposition |
| `amt_sut_calls` | `numeric` | The number of invocations to the system-under-test which appear in the test |
| `test_type` | `string` | `Integration` when in a `tests/` directory, `Functionality` when in a source module |
| `f_or_nf` | `string` | Whether the tests `Functional` or `Non-Functional` behavior |
| `intention` | `string` | The intention of the test (see intention table below) |
| `has_assumptions` | `bool` | Whether or not the test makes any assumptions |
| `input_type` | `string` | The abstract types of the inputs in the test (see type table below) |
| `is_input_filtered` | `bool` | Whether or not the inputs are pre-filtered (nonsense for Quickcheck, but to conform with the other datasets) |
| `is_input_processed` | `bool` | Whether or not any input is further processed before being given to the system-under-test |
| `uses_custom_generator` | `bool` | Whether or not any of the inputs are generated using a custom generator |
| `is_input_sut` | `bool` | Whether or not one of the inputs to the test is the system-under-test |
| `uses_custom_shrinker` | `bool` | Whether or not any of the input types define a custom shrinker |
| `asserts_errors` | `bool` | Whether or not the expected behavior of the system-under-test is an error |
| `concrete_input_type` | `string` | The actual Rust types of the inputs to the test |
| `return_type` | `string` | The Rust return type of the test (`bool`, `TestResult`, or `()`) |

## Test Intentions Table

| Code | Description |
| ---- | ----------- |
| DifferentPaths | Verifies the equivalence of two transformations that should give identical results when performed on the same input |
| RoundTrip | Verifies that an operation composed with its inverse when applied to an input gives the same input |
| Invariant | Verifies the invariance of a component of a state which should not change when the state is transformed in some way |
| Idempotence | Verifies that applying an idempotent operation n>1 times is equivalent to applying it once |
| StructuralInduction | For recursive problems, verifies that the result returned from an operation upholds some recursive contract |
| HardToProveEasyToVerify | Verifies the correctness of the result returned by the SUT with some "easy" verification algorithm |
| TestOracle | Compares the result returned by the SUT to the one returned by an "oracle," which is assumed to always be correct |
| StateContract | Verifies that, after some operations, the state of the SUT upholds a contract defined by or derived from its specification |
| TrivialOutput | Given some set of inputs, the output can be trivially derived from the input, requiring no more than a few cases |
| NoErrors | Ensures that the given operation does not throw some kind of error on any input |

# Abstract Type Table

| Type | Parameters | Description |
| ---- | ---------- | ----------- |
| Numerical | | Represents the set of all real numbers or a subset thereof |
| Character | | Type which represents characters of at least ASCII |
| String | | Type which represents text, i.e. a list of a character type |
| Boolean | | Type with two distinct values, i.e. true/false, yes/no, 1/0, etc. |
| List | T | Type which represents zero or more instances of T |
| Tuple | T... | Type which represents a distinct group of zero or more heterogenous types T... |
| Map | K, V | Type which uniquely maps zero or more keys of type K to values of type V |
| Arbitrary | Any other type which can be generated (by definition or by a distinct derivation) as inputs to a PBT |
| Dummy | Represents a dummy type which represents nothing meaningful |
