# Property-Based Testing in Open-Source Rust Projects

Plots for the data in this repository can be found on GitHub: [AntoniosBarotsis/proptest-dataset](https://github.com/AntoniosBarotsis/proptest-dataset)

## Files

- [data.xlsx](./data/data.xlsx): The full dataset in Excel Sheet format.
- [repos.tsv](./data/repos.tsv): The `repos` sheet from `data.xlsx` in `tsv` format.
- [tests.tsv](./data/tests.tsv): The `tests` sheet from `data.xlsx` in `tsv` format.

## Columns

Note that `NULL`s are represented with the `-` character.

### Repos

|         field         |   type    |                                                  description                                                   |
| :-------------------: | :-------: | :------------------------------------------------------------------------------------------------------------: |
|        `name`         | `String`  |                                           The name of the repository                                           |
|        `link`         | `String`  |                                             Link to the repository                                             |
|       `version`       | `String`  |                              Latest version published at the time of the snapshot                              |
|       `summary`       | `String`  |                             Handwritten, short description of what the project is                              |
|         `loc`         | `numeric` |                                               Lines of Rust code                                               |
| `downloads_all_time`  | `numeric` |                        Total downloads across all published versions (from `crates.io`)                        |
| `downloads_per_month` | `numeric` |                   Downloads in the last month across all published versions (from `lib.rs`)                    |
|    `github_stars`     | `numeric` |                                             Amount of GitHub stars                                             |
|     `total_tests`     | `numeric` |                       Amount of total tests (counted as the number of `#[test]` usages)                        |
|        `pbts`         | `numeric` |                                                 Amount of PBTs                                                 |
|       `parent`        | `String`  | If the crate is part of a repository of more crates (Rust workspace), this contains the name of the repository |
|     `parent_url`      | `String`  |                                           Link to parent repository                                            |
|       `skipped`       | `String`  |                 If a crate was skipped from our data collection, this column mentions its name                 |
|   `skipped_reason`    | `String`  |                                      Explains the reason for skipping it                                       |

### Tests

|            field             |   type    |                                                                                                         description                                                                                                          |
| :--------------------------: | :-------: | :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|            `link`            | `String`  |                                                                                                   Permalink to test source                                                                                                   |
|            `repo`            | `String`  |                                                                                                       Repository name                                                                                                        |
|          `summary`           | `String`  |                                                                                     Handwritten short explanation of what the test does                                                                                      |
|       `amt_assertions`       | `numeric` |                                                                                               Amount of assertions in the test                                                                                               |
| `are_assertions_independent` |  `bool`   |                                                                    Whether or not the assertions depend on one another. Is `-` if there is < 2 assertions                                                                    |
|   `can_decompose_property`   |  `bool`   |                                                                                       Whether or not the assertions can be decomposed                                                                                        |
|       `amt_sut_calls`        | `numeric` |                                                                                           Amount of calls to the System Under Test                                                                                           |
|          `is_local`          |  `bool`   |                                                                                      Whether the test tests local functionality or not                                                                                       |
|     `what_does_it_test`      |  `enum`   |                                                     High level description of what the test assesses. Possible values are: `Environment`, `Functionality`, `Integration`                                                     |
|         `is_nested`          |  `bool`   |                                                                       Whether the test logic is part of another function rather than the test itself.                                                                        |
|          `f_or_nf`           |  `enum`   |                                                              Whether the property being tested is functional or non-functional. Possible values are: `f`, `nf`                                                               |
|      `primary_category`      |  `enum`   |                                                           Main test categorisation. Possible values are: `Invariant`, `TestOracle`, `RoundTrip`, `DifferentPaths`                                                            |
|        `is_explicit`         |  `bool`   |                                                                                     Whether or not the property being tested is explicit                                                                                     |
|      `has_assumptions`       |  `bool`   |                                                                                        Whether the test makes use of PBT assumptions                                                                                         |
|         `input_type`         |  `enum`   | Language agnostic test input type (can contain more than one value, delimited by commans). Possible values are: `numeric`, `string`, `sut instance`, `list object`, `byte list`, `datetime`, `duration`, `vec of sut inputs` |
|         `amt_input`          | `numeric` |                                                                                                       Amount of inputs                                                                                                       |
|    `concrete_input_type`     | `string`  |                                                                     Concrete full test input type (can contain more than one value, delimited by commas)                                                                     |
|     `is_input_filtered`      |  `bool`   |                                                                                         Whether the test makes use of PBT filtering                                                                                          |
|   `uses_custom_generator`    |  `bool`   |                                                                                       Whether the test makes use of a custom generator                                                                                       |
|    `input_used_directly`     |  `bool`   |                                                                      Whether the test input is used directly (or used to construct the real input, etc)                                                                      |
|    `uses_custom_shrinker`    |  `bool`   |                                                                                       Whether the test makes use of a custom shrinker                                                                                        |
|       `asserts_errors`       |  `bool`   |                                                                                   Whether the test asserts any errors (panics/Result::Err)                                                                                   |
