clear all
clc
set(0,'defaultfigurecolor',[1 1 1])

%% INFO

% Reproduce curves based on rheometer data PEEK 150P from Marten van der Werff (TPRC)

% Version: 2-12-2020
% Matlab version: R2020a

% Cleaned to obtain figure 5a (viscosity curves) in ESAFORM 2021


%% viscosity curve

% Marten's data (from PEEK rheology presentation)
gamma_meas = [0.5 0.8 1 2 4 5 8 10 20 40 50 80 100 200];  % measured shear rates
eta_380 = [620 620 615 605 578 565 545 525 468 408 386 344 322 260]; % viscosity values, 380 deg C
eta_390 = [505 497 495 480 465 456 436 425 385 338 320 286 270 220]; % viscosity values, 390 deg C
eta_385 = [];

% Viscosity curve at 385 deg C by averaging measured 380 and 390 deg C data
for i = 1:length(gamma_meas)
    eta_385 = [eta_385, mean([eta_380(i),eta_390(i)])];
end

% function fit: Cross model
eta_cross = @(eta_0,tau_0,n,gam_dot) (eta_0)./(1+(eta_0.*gam_dot./tau_0).^(1-n));
[A, fvalA] = fminsearch(@(a) norm(eta_cross(a(1),a(2),a(3),gamma_meas)-eta_385),[550,1e5,0.62]);
eta_A = A(1);
tau_A = A(2);
n_A = A(3);

gam_dot_cross = logspace(-0.6,2.6,100);
eta_cross_fit = eta_cross(eta_A,tau_A,n_A,gam_dot_cross);

figure(1), clf(1), hold on
plot(gamma_meas,eta_380,'-k^','displayname',['Measurement 380 $^\circ$C'])
plot(gamma_meas,eta_390,'-ko','displayname',['Measurement 390 $^\circ$C'])
plot(gam_dot_cross,eta_cross_fit,'-k','linewidth',2.0,'displayname',['Cross model, 385 $^\circ$C' newline '$\eta_0$ = ', num2str(eta_A,'%0.f'),', $\tau^*$ = ', num2str(tau_A,'%0.f'), ', $n$ = ', num2str(n_A,'%0.2f')])


box on
grid on
axis([0.4 210 200 650])
legend('location','southwest','interpreter','latex','fontsize',16,'box','off')
xlabel('Shear rate, $\dot{\gamma}$ [1/s]','interpreter','latex','fontsize',18)
ylabel('Viscosity, $\eta$ [Pas]','interpreter','latex','fontsize',18)
set(gca,'XScale','log','YScale','log','fontsize',18)




