%This script assembles the matrices and vectors for the displacement
%velocity and the effective strain.
S_vv=zeros(n,n); S_ve=S_vv; S_ev=S_vv; S_ee=S_vv;
F_v=zeros(n,1);
for i = 1:(n-1)
    h=x(i+1)-x(i);
    Selem_ve=E/2*[-sqrt(rho(i)),-sqrt(rho(i+1));sqrt(rho(i)),sqrt(rho(i+1))];
    
    S_vv(i:i+1,i:i+1)=S_vv(i:i+1,i:i+1)+mu/h*[1,-1;-1,1];
    S_ve(i:i+1,i:i+1)=S_ve(i:i+1,i:i+1)+Selem_ve;
    
    f=xi*M(i)*rho(i)/(R^2+(rho(i)^2))+xi*M(i+1)*rho(i+1)/(R^2+(rho(i+1)^2));    
    F_v(i:i+1)=F_v(i:i+1)+f/2*[1;-1];
    
    g_1=zeta*(N(i)+eta_II*M(i))*c(i)/(1+a_c_III*c(i));
    g_2=zeta*(N(i+1)+eta_II*M(i+1))*c(i+1)/(1+a_c_III*c(i+1));
    
    S_ee(i:i+1,i:i+1)=S_ee(i:i+1,i:i+1)+h/2*[g_1,0;0,g_2];
    S_ev(i:i+1,i:i+1)=S_ev(i:i+1,i:i+1)+[1,-1;1,-1]/2;
end