% This script assembles the matrices and vector for the (myo)fibroblasts.
S_n=zeros(n,n); S_m=S_n; F_n=zeros(n,1); F_m=F_n;
for i = 1:(n-1)
	h=x(i+1)-x(i);
    
    f_1=(1+r_F_max*c(i)/(a_c_I+c(i)))*(1-kappa_F*(N(i)+M(i)))*N(i)^q;
    f_2=(1+r_F_max*c(i+1)/(a_c_I+c(i+1)))*(1-kappa_F*(N(i+1)+M(i+1)))*N(i+1)^q;
    
    % Derivative of c.
    c_1=(c(i+1)-c(i))/h;
    if i~=n-1
        c_2=(c(i+2)-c(i+1))/(x(i+2)-x(i+1));
    else
        c_2=0;
    end
    
    diffs=D_F*(N(i)+M(i)+N(i+1)+M(i+1))/(2*h)*[1,-1;-1,1]-chi_F/2*[-c_1,-c_2;c_1,c_2];
    Selem=diffs+k_F*h/2*[c(i),0;0,c(i+1)]-r_F*h/2*[f_1,0;0,f_2]+delta_N*h/6*[2,1;1,2];
    S_n(i:i+1,i:i+1)=S_n(i:i+1,i:i+1)+Selem;
         
    % Boundary conditions for N.
    F_n(:)=F_n(:)-S_n(:,1)*N_eq;
    S_n(:,1)=0; S_n(1,:)=0; S_n(1,1)=1; F_n(1)=N_eq;
        
    if M(i)~=0
        f_1=(1+r_F_max)*c(i)*(1-kappa_F*(N(i)+M(i)))*M(i)^q/(a_c_I+c(i));
    else
        f_1=0;
    end
    if M(i+1)~=0
        f_2=(1+r_F_max)*c(i+1)*(1-kappa_F*(N(i+1)+M(i+1)))*...
            M(i+1)^q/(a_c_I+c(i+1));
    else
        f_2=0;
    end
    
    Selem=diffs-r_F*h/2*[f_1,0;0,f_2]+delta_M*h/6*[2,1;1,2];
    Felem=k_F*h/2*[c(i)*N(i);c(i+1)*N(i+1)];
    S_m(i:i+1,i:i+1)=S_m(i:i+1,i:i+1)+Selem;
    F_m(i:i+1)=F_m(i:i+1)+Felem;
    
    % Boundary conditions for M.
    S_m(:,1)=0; S_m(1,:)=0; S_m(1,1)=1; F_m(1)=0;
end