% This script assembles the matrices and vector for the signaling molecules
% and collagen.
S_c=zeros(n,n); S_r=S_c; F_r=zeros(n,1);
for i = 1:(n-1)
    h=x(i+1)-x(i);
    
    f_1=delta_c*(N(i)+eta_II*M(i))*rho(i)/(1+a_c_III*c(i)) ...
        - k_c*(N(i)+eta_I*M(i))/(a_c_II+c(i));
    f_2=delta_c*(N(i+1)+eta_II*M(i+1))*rho(i+1)/(1+a_c_III*c(i+1)) ...
        - k_c*(N(i+1)+eta_I*M(i+1))/(a_c_II+c(i+1));
    
    Selem=D_c/h*[1,-1;-1,1]+h/2*[f_1,0;0,f_2];
    S_c(i:i+1,i:i+1)=S_c(i:i+1,i:i+1)+Selem;
    
    % Boundary conditions for c. 
    S_c(:,1)=0; S_c(1,:)=0; S_c(1,1)=1;
        
    f_1=(N(i)+eta_II*M(i))*rho(i)/(1+a_c_III*c(i));
    f_2=(N(i+1)+eta_II*M(i+1))*rho(i+1)/(1+a_c_III*c(i+1));
    Selem=delta_rho*h/2*[f_1,0;0,f_2];
    
    f_1=(1+k_rho_max*c(i)/(a_c_IV+c(i)))*(N(i)+eta_I*M(i));
    f_2=(1+k_rho_max*c(i+1)/(a_c_IV+c(i+1)))*(N(i+1)+eta_I*M(i+1));
    Felem=k_rho*h/2*[f_1;f_2];
    
    S_r(i:i+1,i:i+1)=S_r(i:i+1,i:i+1)+Selem;
    F_r(i:i+1)=F_r(i:i+1)+Felem;
end