% This script is used to show the convergence of the numerical method.

clear all
close all
clc
addpath('InputOutput');
T=1; % Sets simulation time
L=10; % Sets the length of half the domain (in cm)
Lw=4; % Sets the length of half the wound
s=1; % Sets the steepness of the boundary of the wound

n_vector=[41,81,161,321,641,1281]; % Defines the vector of number of nodes n
h_vector=10./(n_vector-1); % Defines the mesh step sizes h

Ns=cell(6,1);
Ms=cell(6,1);
Cs=cell(6,1);
Rs=cell(6,1);
Vs=cell(6,1);
Es=cell(6,1);
Xs=cell(6,1);
RSAWs=zeros(6,1);
WB_index=zeros(1,6);

tic
for sim=1:6
    n=n_vector(sim);
    input_morpho; WB_index(sim)=lW;
    output_morpho;
end
toc

tic
sim=3;
n=n_vector(sim);
for iter=1:100
    input_morpho; WB_index(sim)=lW;
    output_morpho;
    iter
end
toc

Points=zeros(41,6);
Points(1,:)=ones(1,6);
Points(:,1)=1:41;
Points(2:41,2)=3:2:n_vector(2);
Points(2:41,3)=5:4:n_vector(3);
Points(2:41,4)=9:8:n_vector(4);
Points(2:41,5)=17:16:n_vector(5);
Points(2:41,6)=33:32:n_vector(6);

%% Absolute errors on full domain
errors_abs_domain=zeros(6,7); % Initializes the error matrix
for i=1:6
   errors_abs_domain(i,1)=sum(abs(Ns{i}(Points(:,i))-Ns{6}(Points(:,6))));
   errors_abs_domain(i,2)=sum(abs(Ms{i}(Points(:,i))-Ms{6}(Points(:,6))));
   errors_abs_domain(i,3)=sum(abs(Cs{i}(Points(:,i))-Cs{6}(Points(:,6))));
   errors_abs_domain(i,4)=sum(abs(Rs{i}(Points(:,i))-Rs{6}(Points(:,6))));
   errors_abs_domain(i,5)=sum(abs(Vs{i}(Points(:,i))-Vs{6}(Points(:,6))));
   errors_abs_domain(i,6)=sum(abs(Es{i}(Points(:,i))-Es{6}(Points(:,6))));
end

% for i=5 %displacement velocity
%     figure();
%     plot(log(h_vector),log(errors_abs_domain(:,i)));
%     xlabel('$\log(h)$','interpreter','latex');
%     ylabel('$\log\left(\sum\limits_{i=1}^{41} \left|v_{h/r}(x_{i,41})-v_h(x_{i,41})\right|\right)$','interpreter','latex');
% end

slopes_abs_domain=zeros(6,4);
for i=1:6 % for all variables
    for j=1:4
        slopes_abs_domain(i,j)=log(errors_abs_domain(j,i)/errors_abs_domain(5,i))/log(h_vector(j)/h_vector(5));
    end
end

mean_slopes_abs_domain=zeros(6,1);
for i=1:6
    mean_slopes_abs_domain(i,1)=mean(slopes_abs_domain(i,:));
end

%% L^1-norm on full domain
Points1=cell(6,1);
Points1{1} = [1,33:32:n_vector(6)];
Points1{2} = [1,17:16:n_vector(6)];
Points1{3} = [1,9:8:n_vector(6)];
Points1{4} = [1,5:4:n_vector(6)];
Points1{5} = [1,3:2:n_vector(6)];
Points1{6} = 1:n_vector(6);

errors_abs_domain_L1 = zeros(6,7); % Initializes the error matrix
for i=1:6
   errors_abs_domain_L1(i,1) = h_vector(i)*sum( abs(Ns{i} - Ns{6}(Points1{i})) );
   errors_abs_domain_L1(i,2) = h_vector(i)*sum( abs(Ms{i} - Ms{6}(Points1{i})) );
   errors_abs_domain_L1(i,3) = h_vector(i)*sum( abs(Cs{i} - Cs{6}(Points1{i})) );
   errors_abs_domain_L1(i,4) = h_vector(i)*sum( abs(Rs{i} - Rs{6}(Points1{i})) );
   errors_abs_domain_L1(i,5) = h_vector(i)*sum( abs(Vs{i} - Vs{6}(Points1{i})) );
   errors_abs_domain_L1(i,6) = h_vector(i)*sum( abs(Es{i} - Es{6}(Points1{i})) );
end

slopes_abs_domain_L1 = zeros(6,4);
for i=1:6 % for all variables
    for j=1:4
        slopes_abs_domain_L1(i,j) = log(errors_abs_domain_L1(j,i)/errors_abs_domain_L1(5,i))/log(h_vector(j)/h_vector(5));
    end
end

mean_slopes_abs_domain_L1=zeros(6,1);
for i=1:6
    mean_slopes_abs_domain_L1(i,1)=mean(slopes_abs_domain_L1(i,:));
end

%% L^2-norm on full domain
errors_abs_domain_L2 = zeros(6,7); % Initializes the error matrix
for i=1:6
   errors_abs_domain_L2(i,1) = sqrt( h_vector(i)*sum( ( Ns{i} - Ns{6}(Points1{i}) ).^2 ) );
   errors_abs_domain_L2(i,2) = sqrt( h_vector(i)*sum( ( Ms{i} - Ms{6}(Points1{i}) ).^2 ) );
   errors_abs_domain_L2(i,3) = sqrt( h_vector(i)*sum( ( Cs{i} - Cs{6}(Points1{i}) ).^2 ) );
   errors_abs_domain_L2(i,4) = sqrt( h_vector(i)*sum( ( Rs{i} - Rs{6}(Points1{i}) ).^2 ) );
   errors_abs_domain_L2(i,5) = sqrt( h_vector(i)*sum( ( Vs{i} - Vs{6}(Points1{i}) ).^2 ) );
   errors_abs_domain_L2(i,6) = sqrt( h_vector(i)*sum( ( Es{i} - Es{6}(Points1{i}) ).^2 ) );
end

slopes_abs_domain_L2 = zeros(6,4);
for i=1:6 % for all variables
    for j=1:4
        slopes_abs_domain_L2(i,j) = log(errors_abs_domain_L2(j,i)/errors_abs_domain_L2(5,i))/log(h_vector(j)/h_vector(5));
    end
end

mean_slopes_abs_domain_L2=zeros(6,1);
for i=1:6
    mean_slopes_abs_domain_L2(i,1)=mean(slopes_abs_domain_L2(i,:));
end

%% Absolute errors on the boundary of the wound
errors_abs_wound=zeros(6,7); % Initializes the error matrix
for i=1:6
   errors_abs_wound(i,1)=abs(Ns{i}(WB_index(i))-Ns{6}(WB_index(6)));
   errors_abs_wound(i,2)=abs(Ms{i}(WB_index(i))-Ms{6}(WB_index(6)));
   errors_abs_wound(i,3)=abs(Cs{i}(WB_index(i))-Cs{6}(WB_index(6)));
   errors_abs_wound(i,4)=abs(Rs{i}(WB_index(i))-Rs{6}(WB_index(6)));
   errors_abs_wound(i,5)=abs(Vs{i}(WB_index(i))-Vs{6}(WB_index(6)));
   errors_abs_wound(i,6)=abs(Es{i}(WB_index(i))-Es{6}(WB_index(6)));
   errors_abs_wound(i,7)=abs(RSAWs(i)-RSAWs(6));
end

% for i=7 %RSAW
%     figure();
%     plot(log(h_vector),log(errors_abs_wound(:,i)));
%     xlabel('$\log(h)$','interpreter','latex');
%     ylabel('$\log\left(|RSAW_{h/r}-RSAW_h|\right)$','interpreter','latex');
% end

slopes_abs_wound=zeros(7,4);
for i=1:7 % for all variables
    for j=1:4
        slopes_abs_wound(i,j)=log(errors_abs_wound(j,i)/errors_abs_wound(5,i))/log(h_vector(j)/h_vector(5));
    end
end

mean_slopes_abs_wound=zeros(7,1);
for i=1:7
    mean_slopes_abs_wound(i,1)=mean(slopes_abs_wound(i,:));
end

Averaged = [mean_slopes_abs_domain,mean_slopes_abs_domain_L1,mean_slopes_abs_domain_L2,mean_slopes_abs_wound(1:6),zeros(6,1)];
for i=1:6
    Averaged(i,5) = mean(Averaged(i,1:4));
end

%sympref('FloatingPointOutput',true);
%latex(sym(Averaged))

%% Save some data
save('Ns.mat','Ns')
save('Ms.mat','Ms')
save('Cs.mat','Cs')
save('Rs.mat','Rs')
save('Vs.mat','Vs')
save('Es.mat','Es')
save('Xs.mat','Xs')
save('n_vector.mat','n_vector')
save('h_vector.mat','h_vector')
save('RSAWs.mat','RSAWs')
save('WB_index.mat','WB_index')
save('Averaged.mat','Averaged')

%dlmwrite('errors.txt',errors)