# medlabs‑heros urban-maladaptation archive

This archive contains output data generated with the **medlabs‑heros** simulation model ([GitHub repo](https://github.com/averbraeck/medlabs-heros)) made for 'Urban Maladaptation in Times of Epidemics' study. It bundles results for two scenarios:

* **No‑response (baseline)**
* **Hard lockdown starting on day 20**

The data here is intended for anyone who would like to replicate the results of the underlying publication, or to use the data for their own research.

## What’s inside

```
results/
├─ baseline/
│  ├─ out-flip-normal-area-seed-111/
│  │  └─ infectedPersons.csv
│  ├─ out-flip-normal-area-seed-112/
│  │  └─ infectedPersons.csv
│  └─ ... (total 10 runs, different seeds)
├─ lockdown/
│  ├─ out-flip-lockdown-day20-area-seed-111/
│  │  └─ infectedPersons.csv
│  ├─ out-flip-lockdown-day20-area-seed-112/
│  │  └─ infectedPersons.csv
│  └─ ... (total 10 runs, different seeds)
└─ README.md  (this file)
```

* Each **scenario** folder contains **10 independent runs** with different random seeds (the seed is shown in the folder name).
* Results are split per run to make comparisons straightforward and reproducible.

> **Note:** The medlabs‑heros model can produce multiple output files. In this archive we include the most commonly used file for person‑level analysis:

### `infectedPersons.csv`

A tidy, row‑per‑person record of everyone who became infected in a run, including **where** the infection happened. This is especially useful to study hotspots (e.g., whether infections cluster in particular locations).

## Column reference for `infectedPersons.csv`

This summary reiterates the official docs and highlights the fields people most often use. For full details, see the upstream model documentation: [docs/4-output.md](https://github.com/averbraeck/medlabs-heros/blob/main/docs/4-output.md).

| Column                                   | Type    | Meaning                                                                                              |
| ---------------------------------------- | ------- | ---------------------------------------------------------------------------------------------------- |
| `Time(h)`                                | number  | Simulation time (in **hours**) when the person became infected (time 0 = simulation start).          |
| `personId`                               | integer | Unique identifier of the person within the simulation.                                               |
| `personType`                             | text    | Role/group, e.g., `Infant`, `PrimarySchoolStudent`, `SecondarySchoolStudent`, `Worker`, `Pensioner`. |
| `Age`                                    | integer | Person’s age (years).                                                                                |
| `Gender`                                 | text    | `M` or `F` (per model encoding).                                                                     |
| `homeId`                                 | integer | ID of the home (accommodation) linked to the person.                                                 |
| `homeSubId`                              | integer | Sub‑unit inside the home/building (e.g., apartment index).                                           |
| `homeLat`, `homeLon`                     | number  | Home location in **WGS84** (latitude, longitude).                                                    |
| `diseasePhase`                           | text    | Disease state at infection record time (often `Exposed`).                                            |
| `workId`                                 | integer | Workplace ID, or `-1` if not applicable.                                                             |
| `schoolId`                               | integer | School ID, or `-1` if not applicable.                                                                |
| `infectLocationType`                     | text    | Type of location where the infection occurred (e.g., `Accommodation`, `Supermarket`).                |
| `infectLocationId`                       | integer | ID of the specific location instance where infection occurred.                                       |
| `infectLocationLat`, `infectLocationLon` | number  | Infection location coordinates (WGS84).                                                              |

**Special values**

* `-1` is used for fields that **don’t apply** to a person (e.g., `schoolId` for a worker).

**Mini‑example**

```csv
Time(h),personId,personType,Age,Gender,homeId,homeSubId,homeLat,homeLon,diseasePhase,workId,schoolId,infectLocationType,infectLocationId,infectLocationLat,infectLocationLon
54.1576,56013,PrimarySchoolStudent,7,F,17720,4,52.09154,4.25863,Exposed,-1,142786,Accommodation,17720,52.09154,4.25863
```

## Scenarios

* **No‑response (baseline):** The model runs without an active intervention policy.
* **Hard lockdown (day 20):** A strict lockdown policy activates at **simulation day 20**. Exact policy settings follow the medlabs‑heros configuration for a hard lockdown (see the model repository for policy definitions and parameters).

Each scenario is run **10 times** with different random seeds to capture stochastic variation. This lets you summarize average effects and uncertainty.

## Quickstart: load and explore

You can open `infectedPersons.csv` in any spreadsheet app. Here’s a minimal Python example:

```python
import pandas as pd
from pathlib import Path

root = Path('results')  # adjust if needed
run = root / 'baseline' / 'out-flip-normal-area-seed-111' / 'infectedPersons.csv'

df = pd.read_csv(run)

# Simple summaries
print(df.head())
print('\nTotal infected:', len(df))
print('\nBy location type:')
print(df['infectLocationType'].value_counts())
```

Mapping infection locations is straightforward as well (lat/lon are already provided in WGS84). Use your preferred GIS tool or libraries such as GeoPandas, QGIS, or kepler.gl.

## How this archive relates to the simulation model project

* Simulation model and documentation: **medlabs‑heros** → [https://github.com/averbraeck/medlabs-heros](https://github.com/averbraeck/medlabs-heros)
* The results in this archive follow the **output schema** described in the simulation model docs (see `docs/4-output.md`).
* Additional, downstream analyses of these files are available here: **urban‑maladaptation** → [https://github.com/miskh/urban-maladaptation](https://github.com/miskh/urban-maladaptation)

## Citation & attribution

If you use this archive in your research, publications, or presentations, please acknowledge the **medlabs‑heros** simulation model by citing the [model repository](https://github.com/averbraeck/medlabs-heros). If you build upon any analyses included here, kindly reference both the underlying publication and the [analysis repository](https://github.com/miskh/urban-maladaptation). 

Recommended citation:

@article{sirenko2025maladaptation,
  title={On Urban Maladaptation in Times of Epidemics},
  author={Sirenko, Mikhail and Verbraeck, Alexander and Comes, Tina},
  journal={Under review},
  year={2025}
}

## Contact

Questions or suggestions? Feel free to open an issue in the [simulation model](https://github.com/averbraeck/medlabs-heros) or the [analysis](https://github.com/miskh/urban-maladaptation) repositories.