function Vars = Perturbations(p,P,k)
%Perturbations writes the initial perturbated conditions of the variables
%of the model for the numerical validation of stability in R2.

% Points
x = p(1,:)'; y = p(2,:)'; n = length(x);

va = 0.5; % amplitude velocity
v1 = va*sin(2*k*pi*x).*sin(2*k*pi*y);
v2 = -v1;

e11 = zeros(n,1);
e22 = e11;

Na = 10; % amplitude fibroblasts
Ra = 1e-2; % amplitude collagen
N = Na*sin(2*pi*k*x).*sin(2*k*pi*y) + P(28);
R = Ra*sin(2*pi*k*x).*sin(2*k*pi*y) + P(29);

% myofibroblast, signaling molecule and effective strain 12 using splines
xx = 0:1/(2*k):1;

Ma1 = 3; Ma2 = 1;
yy = [0 repmat([Ma1 Ma2],1,k-1) Ma1 0];
M = spline(xx,yy,x).*spline(xx,yy,y);

Ca1 = 2e-7; Ca2 = 0.5e-7;
yy = [0 repmat([Ca1 Ca2],1,k-1) Ca1 0];
C = spline(xx,yy,x).*spline(xx,yy,y);

e12 = e11;

n = length(x);
Vars = {[N, M, C, R, v1, v2, e11, e12, e22, zeros(n,1), zeros(n,1)]};