function [S1,S2,S3,S4,S5,S6,S7,S8,S9,S10] = Assemble_Sbnd(n, x, bnd, P, R)
S1 = zeros(n,n); S2=S1; S3=S1; S4=S1; S5=S1; S6=S1; S7=S1; S8=S1; S9=S1; S10=S1;

n1 = 1/sqrt(2);
n2 = -1/sqrt(2);

b = [-1,1]*0.5;
c = b;
for i = 1:size(bnd,1)
    a = bnd(i,:);
    dx = abs(diff(x(a)));
    L = dx*sqrt(2);
    
    b = [-1,1]*0.5/dx;
    c = b;
    
    mu1 = P(21); mu2 = P(22);
    E = P(23); nu = P(24);
    p_vec = sqrt(R(a));
    
    S1(a,a) = S1(a,a) + (n1*(mu1+mu2)*b + n2*mu1/2*c)*L/2; %v1 v1
    S2(a,a) = S2(a,a) + (n1*mu2*c + n2*mu1/2*b)*L/2; %v1 v2
    S3(a,a) = S3(a,a) + n1*E/(1+nu)*p_vec.*eye(2)*(1+nu/(1-2*nu))*L/2; %v1 e11
    S4(a,a) = S4(a,a) + n2*E/(1+nu)*p_vec.*eye(2)*L/2; %v1 e12
    S5(a,a) = S5(a,a) + n1*E/(1+nu)*nu/(1-2*nu)*p_vec.*eye(2)*L/2; %v1 e22
 
    S6(a,a) = S6(a,a) + (n1*mu1/2*c + n2*mu2*b)*L/2; %v2 v1
    S7(a,a) = S7(a,a) + (n1*mu1/2*b + n2*(mu1+mu2)*c)*L/2; %v2 v2
    S8(a,a) = S8(a,a) + n2*E/(1+nu)*nu/(1-2*nu)*p_vec.*eye(2)*L/2; %v2 e11
    S9(a,a) = S9(a,a) + n1*E/(1+nu)*p_vec.*eye(2)*L/2; %v2 e12
    S10(a,a) = S10(a,a) + n2*E/(1+nu)*p_vec.*eye(2)*(1+nu/(1-2*nu))*L/2; %v2 e22
end
S1 = sparse(S1); S2 = sparse(S2); S3 = sparse(S3); S4 = sparse(S4);
S5 = sparse(S6); S6 = sparse(S6); S7 = sparse(S7); S8 = sparse(S8);
S9 = sparse(S9); S10 = sparse(S10);
end