function [ar,qt,te]=tarea(p,t)
%Compute triangle area and quality
%
it1=t(:,1); it2=t(:,2); it3=t(:,3);
x21=p(it2,1)-p(it1,1); y21=p(it2,2)-p(it1,2); 
x31=p(it3,1)-p(it1,1); y31=p(it3,2)-p(it1,2);
x32=p(it3,1)-p(it2,1); y32=p(it3,2)-p(it2,2);
ar=(x21.*y31-y21.*x31)/2;
if (nargout==1), return, end
a1=sqrt(x21.^2+y21.^2); a2=sqrt(x31.^2+y31.^2); a3=sqrt(x32.^2+y32.^2);
qt=(a2+a3-a1).*(a3+a1-a2).*(a1+a2-a3)./(a1.*a2.*a3);
if (nargout == 2) , return, end
te=[a1,a2,a3];
end