function [p, t, Vars, EssBnd, HorzBnd, VertBnd] = remesh_global_domain(s, h0, p, WoundBnd, Vars, geo)

p_old = p; L = 1;

fd = @dsquare;
fh = @hglobal;
bbox = [0,0; L,L];
pfix = [0,0; 0,L; L,L; L,0];
Pgon = polyshape(pfix);

[p,t,be] = remesh_global(fd, fh, h0, bbox, pfix, ...
    {Pgon,WoundBnd,s,geo}); clear pfix

% Boundaries
I = find((p(be(:,1),2) == L).*(p(be(:,2),2) == L));
I = [I; find((p(be(:,1),1) == L).*(p(be(:,2),1) == L))];
EssBnd = unique(be(I,:));
I = find((p(be(:,1),1) == 0).*(p(be(:,2),1) == 0));
VertBnd = unique(be(I,:));
I = find((p(be(:,1),2) == 0).*(p(be(:,2),2) == 0));
HorzBnd = unique(be(I,:));

Vars = Interpolate_new_mesh(p', p_old, Vars);
p = p';
end
