function Vars = InitialConditions(n,p,P,a,s)
%InitialConditions writes the initial conditions for the variables of the
%biomorphoelastic model for burn injuries in R2.

% Initialize variables
N = zeros(n,1); C = N; R = N;

% Wounded area
ind1 = find(p(2,:) <= a);
ind2 = p(1,ind1) <= a;
ind = ind1(ind2);

N(ind) = P(30);
C(ind) = P(31);
R(ind) = P(32);

% Healthy area
ind = setdiff(1:n,ind);
N(ind) = P(28);
R(ind) = P(29);

% Steepness area
ind1 = find(p(2,:) < a);
ind2 = p(1,ind1) < a;
ind = ind1(ind2);
ind1 = p(1,ind) >= a-s; 
ind1 = ind(ind1);
ind2 = p(2,ind) >= a-s; 
ind2 = ind(ind2);
ind = unique([ind1,ind2]);

d1 = abs(p(2,ind) - a);
d2 = abs(p(1,ind) - a);
d = [d1',d2'];
d = min(d,[],2);

N(ind) = (P(28)-P(30))/2*sin(pi/s*(d+s/2)) + (P(28)+P(30))/2;
R(ind) = (P(29)-P(32))/2*sin(pi/s*(d+s/2)) + (P(29)+P(32))/2;
C(ind) = P(31)/2*sin(pi/s*(d-0.5*s)) + P(31)/2;

Vars = {[N, zeros(n,1), C, R, zeros(n,7)]};