function [Vars, max_norm] = SolveChemicals(n, elmat, EssBnd, p, p_half, ...
    Vars_tdt, Vars_t, P, Mass_tdt, Mass_t, dt)
%SolveChemicals - solves the partial differential equations for the
%chemical constituents: fibroblasts (N), myofibroblasts (M), signaling
%molecules (C), and collagen (R). The myofibroblasts are solved according
%the flux corrected transport (FCT) method. The matrices are stored in
%sparse arrays.

% Initialize guess for solutions on time t+dt
N = Vars_tdt(:,1);
M = Vars_tdt(:,2);
C = Vars_tdt(:,3);
R = Vars_tdt(:,4);

% Retrieve solutions on time t
N_t = Vars_t(:,1);
M_t = Vars_t(:,2);
C_t = Vars_t(:,3);
R_t = Vars_t(:,4);

% Allocate memory for the parallel loop
N1 = zeros(n,1);
M1 = zeros(n,1);
C1 = zeros(n,1);
R1 = zeros(n,1);

parfor k = 1:4
    if k == 1
        N1 = N1 + Solve_N(n, EssBnd, elmat, p, p_half, N, M, C, P, ...
            Mass_tdt, Mass_t, N_t, M_t, C_t, dt);
    elseif k == 2
        M1 = M1 + Solve_M(n, EssBnd, elmat, p, p_half, N, M, C, P, ...
            Mass_tdt, Mass_t, N_t, M_t, C_t, dt);
    elseif k == 3
        C1 = C1 + Solve_C(n, EssBnd, elmat, p, p_half, N, M, C, R, P, ...
            Mass_tdt, Mass_t, N_t, M_t, C_t, R_t, dt);
    elseif k == 4
        R1 = R1 + Solve_R(n, elmat, p, N, M, C, R, P, Mass_tdt, ...
            Mass_t, dt, R_t);
    end
end

% Compute norms
norm_N = norm(abs(N1-N)/abs(N1+1e-40),1);
norm_M = norm(abs(M1-M)/abs(M1+1e-40),1);
norm_C = norm(abs(C1-C)/abs(C1+1e-40),1);
norm_R = norm(abs(R1-R)/abs(R1+1e-40),1);
max_norm = max([norm_N, norm_M, norm_C, norm_R]);

Vars = [N1, M1, C1, R1];

