### Visualize P vs n vs fraction
{
  ## Set working directory
  setwd("repository/scripts")
  
  ## Load packages
  library(data.table)
  library(ggplot2)
  library(metR)
  
  ## Create 2D range of data (1/(#rhinos + 1) & 
  ## fraction of area observed by poachers)
  dat = as.data.table(expand.grid("1_n+1" = seq(2e-3,1,2e-3),
                                  "frac" = seq(0,1,2e-3)))
  
  ## Compute number of rhinos
  dat[, n := (1/`1_n+1`)-1]
  
  ## Compute probability of encountering a rhino
  dat[, P := 1 - (1 - frac)^n]
  
  ## Compute expected fraction of area observed to encounter 1 rhino
  dat[, E := 1/(n+1)]
  
  ## Verify that expected observed fraction is identical to 1/(n+1)
  identical(round(dat$`1_n+1`,6),round(dat$E,6))
  
  ## Create manuscript figure 3
  p = ggplot(dat, 
             aes(x = `1_n+1`, y = frac, z = P,
                 fill = P)) + 
    geom_tile() +
    geom_line(aes(x = `1_n+1`, y = E,
                  linetype = "E"),
              colour = "#000000") +
    geom_contour(aes(x = `1_n+1`, y = frac, z = P,
                     linetype = "P"),
                 breaks = seq(.1,.9,.1),
                 colour = "#000000") +
    geom_text_contour(label.placer = label_placer_random(seed = 10)) +
    scale_fill_gradient(name = expression("P"~("X">=1)),
                        low = "#FF0000", high = "#00FF00") +
    scale_linetype_manual(name = "", 
                          values = c("E" = "solid",
                                     "P" = "dotted"),
                          labels = c(expression("E"~(phi)),
                                     expression("P"~("X">=1)))) +
    labs(x = expression(1/(n+1)),
         y = expression(phi)) +
    scale_x_continuous(breaks = 1/(10^seq(-2,2,1)+1),
                       labels = round(1/(10^seq(-2,2,1)+1),
                                      2),
                       sec.axis = dup_axis(labels = round(10^seq(-2,2,1),
                                                          2),
                                           name = expression(n))) +
    coord_fixed(expand = 0) +
    theme(legend.position="top")
  
  ## Save figure
  ggsave("../plots/fig3.pdf",
         p,
         width = 2000,
         height = 2000,
         units = "px")
}
