import pandas as pd
from iwtoperator import IWToperator
   
def writeExcelFile(iwtop1, iwtop2, assigmatrix, desiredname):
    dobj = {'IWT1': [iwtop1.computeActProfits(assigmatrix['IWT1']), iwtop1.computeActRevenues(assigmatrix['IWT1']), iwtop1.computeActFcosts(), iwtop1.computeActVcosts(assigmatrix['IWT1'])], 'IWT2': [iwtop2.computeActProfits(assigmatrix['IWT2']), iwtop2.computeActRevenues(assigmatrix['IWT2']), iwtop2.computeActFcosts(), iwtop2.computeActVcosts(assigmatrix['IWT2'])]}
    (pind,pdic)=createPriceFreqDic(iwtop1,iwtop2)
    (fvind,fvdic)=createFreqVessDic(iwtop1,iwtop2)
    (vind,vdic)=createVolDic(iwtop1,iwtop2,assigmatrix)
    with pd.ExcelWriter(desiredname+'.xlsx') as writer:
        pd.DataFrame(dobj, index=["Profit","Revenue","FixCost","VarCost"]).to_excel(writer,sheet_name='Profits')
        pd.DataFrame(pdic, index=pind).to_excel(writer,sheet_name='PricesFreqs')
        pd.DataFrame(fvdic, index=fvind).to_excel(writer,sheet_name='VesselsFreqs')
        pd.DataFrame(vdic, index=vind).to_excel(writer,sheet_name='Volumes')

        
def createPriceFreqDic(iwtop1, iwtop2):
    N_nodes=len(iwtop1.network.listTerminals)
    N = range(N_nodes)
    dicopf={'fIWT1':[],'fIWT2':[],'pIWT1':[],'pIWT2':[]}
    indices=[]
    freqsod1=iwtop1.getFreqOD()
    freqsod2=iwtop2.getFreqOD()
    for i in N:
        for j in N:
            if i!=j:
                dicopf['fIWT1'].append(freqsod1[i][j])
                dicopf['fIWT2'].append(freqsod2[i][j])
                dicopf['pIWT1'].append(iwtop1.pricesOD[i][j])
                dicopf['pIWT2'].append(iwtop2.pricesOD[i][j])
                indices.append(iwtop1.network.listTerminals[i]+'-'+iwtop1.network.listTerminals[j])    
    return (indices, dicopf)
        
def createFreqVessDic(iwtop1, iwtop2):       
    N_Vtypes = len(iwtop1.fleet.vesselnames)
    K=range(N_Vtypes)
    N_services = len(iwtop1.network.services.nameslist)
    S=range(N_services)
    dicofv={'fIWT1small':[], 'fIWT1big':[], 'vIWT1small':[], 'vIWT1big':[], 'fIWT2small':[], 'fIWT2big':[], 'vIWT2small':[], 'vIWT2big':[]}
    indices=[]
    for s in S:
        dicofv['fIWT1small'].append(iwtop1.freqs[s][0])
        dicofv['fIWT1big'].append(iwtop1.freqs[s][1])
        dicofv['vIWT1small'].append(iwtop1.vesseluses[s][0])
        dicofv['vIWT1big'].append(iwtop1.vesseluses[s][1])
        dicofv['fIWT2small'].append(iwtop2.freqs[s][0])
        dicofv['fIWT2big'].append(iwtop2.freqs[s][1])
        dicofv['vIWT2small'].append(iwtop2.vesseluses[s][0])
        dicofv['vIWT2big'].append(iwtop2.vesseluses[s][1])
        indices.append("-".join(iwtop1.network.services.nameslist[s]))
    # print(dicofv['fIWT1small'])
    # print(dicofv['fIWT1big'])
    # print(dicofv['vIWT1small'])
    # print(dicofv['vIWT1big'])
    # print(dicofv['fIWT2small'])
    # print(dicofv['fIWT2big'])
    # print(dicofv['vIWT2small'])
    # print(dicofv['vIWT2big'])
    # print(indices)    
    return (indices, dicofv)
        
def createVolDic(iwtop1, iwtop2, assignMatrix):
    N_nodes=len(iwtop1.network.listTerminals)
    N = range(N_nodes)
    dicovs={'IWT1':[],'IWT2':[],'Road':[],'Rail':[],'Total':[]}
    indices=[]
    for i in N:
        for j in N:
            if i!=j:
                dicovs['IWT1'].append(assignMatrix['IWT1'][i][j])
                dicovs['IWT2'].append(assignMatrix['IWT2'][i][j])
                dicovs['Road'].append(assignMatrix['ROAD'][i][j])
                dicovs['Rail'].append(assignMatrix['RAIL'][i][j])
                dicovs['Total'].append(assignMatrix['IWT1'][i][j]+assignMatrix['IWT2'][i][j]+assignMatrix['ROAD'][i][j]+assignMatrix['RAIL'][i][j])
                indices.append(iwtop1.network.listTerminals[i]+'-'+iwtop1.network.listTerminals[j])    
    return (indices, dicovs)
        
        
        
        
        
        
        
        
        
        
        
        