import itertools
import numpy as np
from utility import ODpair
   
class Services:
    def __init__(self, listTerminals):
        N_nodes=len(listTerminals)
        N=range(N_nodes)
        nodes = list(N)
        maxLegs=2*(N_nodes-1)
        legs_matrix=[]
        servicesindex=[]
        service_list=[]
        for P in range(2,N_nodes + 1):
            for subset in itertools.combinations(nodes, P):
                legs=np.zeros((maxLegs,N_nodes,N_nodes))
                l=0
                for seq in range(1,len(subset)):
                    legs[l][subset[seq-1]][subset[seq]]=1
                    l+=1
                for revseq in reversed(range(1,len(subset))):
                    legs[l][subset[revseq]][subset[revseq-1]]=1
                    l+=1
                legs_matrix.append(legs)
                servicesindex.append(subset)
                node_list=[]
                for w in subset:
                    node_list.append(listTerminals[w])
                service_list.append(node_list)
        self.nameslist = service_list
        self.indiceslist = servicesindex
        self.legsmatrix = legs_matrix
        
        N_services=len(servicesindex)
        S=range(N_services)
        usage_matrix=np.zeros((N_services,maxLegs,N_nodes,N_nodes))
        for s in S:
            for l in range(len(servicesindex[s])-1):
                for k in range(l+1):
                    for q in range(l+1,len(servicesindex[s])):
                        usage_matrix[s][l][servicesindex[s][k]][servicesindex[s][q]]=1
            lt=0
            for r in reversed(range(l+1,2*(l+1))):
                usage_matrix[s][r]=np.transpose(usage_matrix[s][lt])
                lt+=1
        self.usagematrix = usage_matrix

        servOD_matrix=np.zeros((N_services,N_nodes,N_nodes))
        for i in N:
            for j in N:
                if i!=j:
                    for idxs,serv in enumerate(servicesindex):
                        if (i in serv) and (j in serv):
                            servOD_matrix[idxs][i][j]=1
        self.servODmatrix = servOD_matrix

class Network:
    def __init__(self, listTerminals, waitIWTterm, listODs):
        self.listTerminals = listTerminals
        self.waitIWTterm = waitIWTterm
        self.ODs = {}
        for i in listTerminals:
            for j in listTerminals:
                for k in listODs:
                    if (k.name==i+j):
                        self.ODs[i+j]=k              
        self.services = Services(listTerminals)
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        