library(glmmTMB)
library(performance)
library(DHARMa)
library(Cairo)
library(effects)



rm(list=ls())
OSR <- read.table("/Users/bjornkristianklatt/Documents/Publikationen/ Published/Artikel_climate_OSR/data_climate_OSR.txt",header=T,sep="\t",dec=",")

names(OSR)
str(OSR)



### *** Number of flowers *** ###

m0 = glmmTMB(flowers ~ treatment, data=OSR)

check_autocorrelation(m0)
check_outliers(m0)

res=simulateResiduals(m0)
plot(res, asFactor=T)

m1 = update(m0, ~.-treatment)
anova(m0,m1)

contrast(emmeans(m0, "treatment"), "pairwise", adjust="holm", transform="none")

plot(eff <- effect('treatment', m0))
eff_df = data.frame(eff)
eff_df

CairoPS("PATH/Fig1a.ps", width=6, height=6)
ggplot(data= eff_df, aes(treatment)) + geom_point(aes(y=fit), colour="black", size=4) + geom_errorbar(aes(ymin=lower, ymax=upper), width=0.1) + geom_point(data=OSR, aes(x=jitter(treatment_num), y=flowers), colour="grey") + theme_bw() + theme_classic() + xlab("Treatment") + ylab("Number of flowers") + scale_y_continuous(limits=c(0,410), breaks=c(0,100,200,300,400))
dev.off()



### *** Number of axillary shoots *** ###

m0 = glmmTMB(axillary_shoots ~ treatment, data=OSR, dispformula=~treatment)

check_autocorrelation(m0)
check_outliers(m0)

res=simulateResiduals(m0)
plot(res, asFactor=T)

m1 = update(m0, ~.-treatment)
anova(m0,m1)

contrast(emmeans(m0, "treatment"), "pairwise", adjust="holm", transform="none")

plot(eff <- effect('treatment', m0))
eff_df = data.frame(eff)
eff_df

CairoPS("PATH/Fig1b.ps", width=6, height=6)
ggplot(data= eff_df, aes(treatment)) + geom_point(aes(y=fit), colour="black", size=4) + geom_errorbar(aes(ymin=lower, ymax=upper), width=0.1) + geom_point(data=OSR, aes(x=jitter(treatment_num), y= no_side_stems), colour="grey") + theme_bw() + theme_classic() + xlab("Treatment") + ylab("Number of axilliary shoots") + scale_y_continuous(limits=c(0,15), breaks=c(0,3,6,9,12,15))
dev.off()



### *** Stem length *** ###

m0 = glmmTMB(stem_length ~ treatment, data=OSR)

check_autocorrelation(m0)
check_outliers(m0)

res=simulateResiduals(m0)
plot(res, asFactor=T)

m1 = update(m0, ~.-treatment)
anova(m0,m1)

contrast(emmeans(m0, "treatment"), "pairwise", adjust="holm", transform="none")



### *** Yield *** ###

m0 = glmmTMB(sqrt(yield_after_storm) ~ treatment, data=OSR)

check_autocorrelation(m0)
check_outliers(m0)

res=simulateResiduals(m0)
plot(res, asFactor=T)

m1 = update(m0, ~.-treatment)
anova(m0,m1)

contrast(emmeans(m0, "treatment"), "pairwise", adjust="holm", transform="sqrt")

plot(eff <- effect('treatment', m0))
eff_df = data.frame(eff)
eff_df

CairoPS("PATH/Fig1c.ps", width=6, height=6)
ggplot(data= eff_df, aes(treatment)) + geom_point(aes(y=fit^2), colour="black", size=4) + geom_errorbar(aes(ymin=lower^2, ymax=upper^2), width=0.1) + geom_point(data=OSR, aes(x=jitter(treatment_num), y=yield_after_winter), colour="grey") + theme_bw() + theme_classic() + xlab("Treatment") + ylab("Yield (g)") + scale_y_continuous(limits=c(0,16), breaks=c(0,4,8,12,16))
dev.off()



### *** Yield (Supplementary data) *** ###

m0 = glmmTMB(sqrt(yield_after_winter) ~ treatment, data=OSR)

check_autocorrelation(m0)
check_outliers(m0)

res=simulateResiduals(m0)
plot(res, asFactor=T)

m1 = update(m0, ~.-treatment)
anova(m0,m1)

contrast(emmeans(m0, "treatment"), "pairwise", adjust="holm", transform="sqrt")

plot(eff <- effect('treatment', m0))
eff_df = data.frame(eff)
eff_df

CairoPS("PATH/FigS2.ps", width=6, height=6)
ggplot(data= eff_df, aes(treatment)) + geom_point(aes(y=fit^2), colour="black", size=4) + geom_errorbar(aes(ymin=lower^2, ymax=upper^2), width=0.1) + geom_point(data=OSR, aes(x=jitter(treatment_num), y=yield_after_winter), colour="grey") + theme_bw() + theme_classic() + xlab("Treatment") + ylab("Yield (g)") + scale_y_continuous(limits=c(0,16), breaks=c(0,4,8,12,16))
dev.off()