%% get_pico_data.m
% Description: This script extracts variables from '.mat' files directly
% generated from the PicoScope data file.

%% Extracr time sampling parameters
t0 = Tstart;
dt = Tinterval;
sigL = RequestedLength;

%% Extract actuator, sensor numbers and sensor distribution
p = strfind(fname,'_A');
if isempty(p) == 0
    if length(p) > 1
        act_str = fname(p(2)+2:p(2)+3);
        a_num = str2num(act_str);
        s_num = GetSenNum(fname,a_num);
        s_dist = {[1,length(s_num)]};
    end
end

%% Extract signals
alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
Max_ch = 4;
possible_ch = alphabet(1:Max_ch);
x_sen = cell(1,Max_ch);
Nch = 0;
for g = 1:Max_ch
    ch_id = possible_ch(g);
    Nch = Nch + exist(possible_ch(g),'var');
    
    % The function 'eval' is used to mimic the variable
    % assignment
    if exist(possible_ch(g),'var') == 1
        if g == 1
            x_act = eval(possible_ch(g));
        else
            x_sen{g} = {ch_id,eval([possible_ch(g),'(1:sigL)'])};
        end
        clearvars(ch_id);
    else
        x_sen{g} = [];
    end
end

% Delete cells which have empty array
x_sen = x_sen(~cellfun('isempty',x_sen));