%% get_comb_data.m
% Description: This script extracts variables from '.mat' files with 
% combined data sets.

%% Extracr time sampling parameters
t0 = [test_data(1).Tstart,test_data(2).Tstart];
dt = [test_data(1).Tinterval,test_data(2).Tinterval];
sigL = [test_data(1).ChLength,test_data(2).ChLength];

%% Extract actuator, sensor numbers and sensor distribution
Nch = [test_data(1).NumChannels,test_data(2).NumChannels];
a_num = test_data(1).Actuator;
s_num = [test_data(1).Sensors,test_data(2).Sensors];
if isempty(test_data(1).Sensors) == 0
    s_dist = {[1,length(test_data(1).Sensors)],...
        [length(test_data(1).Sensors) + 1,...
        length(test_data(1).Sensors) + length(test_data(2).Sensors)]};
else
    s_dist = {0,...
        [length(test_data(1).Sensors) + 1,...
        length(test_data(1).Sensors) + length(test_data(2).Sensors)]};
end

%% Extract signals
if iscell(test_data(1).Signals) == 1
    x_act = test_data(1).Signals{1}{2};
    x_sen = {test_data(1).Signals{2:Nch(1)},...
                test_data(2).Signals{1:Nch(2)}};
else
    x_act = test_data(1).Signals;
    x_sen = test_data(2).Signals(1:Nch(2));
end

%% Attribute the correct length to the signals
for h = 1:Nosc
    if s_dist{h} ~= 0
        si = s_dist{h}(1);
        sf = s_dist{h}(2);
        for s = si:sf
            %aux_sig = x_sen{s}{2}(1:sigL(h));
            x_sen{s}{2} = x_sen{s}{2}(1:sigL(h));
        end
    end
end