function fmain = findFmain(x_act,dt_a,L_a)
%FINDFMAX Finds frequency of maximum spectrum magnitude

    % Compute FFT of actuation
    fft_x = fftshift(fft(x_act));

    % Frequency specifications:
    Fs_a = 1/dt_a;
    dF = Fs_a/L_a;                  % hertz
    f_vec = -Fs_a/2:dF:Fs_a/2-dF;   % hertz

    % Find index of freq = 0
    k1 = find(f_vec >= 0,1);
    
    % Truncate vectors
    fft_x = fft_x(k1:end);
    f_vec = f_vec(k1:end);
    
    % Find frequency of maximum magnitude
    [~,idx] = max(abs(fft_x));
    fmain = f_vec(idx);

end

