function x_rec = cwtGWfilter(x,x_act,L_a,dt,dt_a,bw_lev,opt_filter)
%CWTFILTER Filters a GW signal with the pass-band of the excitation signal

    % Sampling frequency
    Fs = 1/dt;
    Fs_a = 1/dt_a;

    % Filter GW signal with CWT using the desired bandwidth
    wname = 'amor'; % The Morlet wavelet ('amor') provides the best result
    [wt,f] = cwt(x,wname,Fs);
    switch opt_filter
        case 'single'
            % Single frequency of excitation 
            fc = findFmain(x_act,dt_a,L_a);
            
            % 20 kHz bandwidth around excitation main frequency
            fhi = fc + 10e3;
            flo = fc - 10e3;
            
        case 'narrow'
            % Narrow frequency band of excitation 
            [~,flo,fhi,~] = powerbw(x_act,Fs_a,[],bw_lev);
          
            %if flo < min(f)
            %    flo = min(f);
            %end

        case 'wide_1'
            % Wide frequency band, option 1
            flo = 20e3;
            fhi = 1000e3;
        case 'wide_2'
            % Wide frequency band, option 2
            flo = 50e3;
            fhi = 500e3;
    end
    frange = [flo fhi];
    wt(f > fhi | f < flo,:) = 0;
    wt(f <= fhi & f >= flo,1) = 0;
    x_rec = transpose(icwt(wt,f,frange));

end

