function varargout = GetSenNum(fname,act_num)
%GETSENNUM Extracts sensor numbers from file name

    p = strfind(fname,'_to_');
    if isempty(p) == 1
        p = strfind(fname,'_S');

        sen_str = fname(p(1)+1:p(end)+3);
        s_num = zeros(1,length(p));
        for k = 1:length(p)
            s_num(k) = str2num(fname(p(k)+2:p(k)+3));
        end

        sensors = s_num;
        varargout = {sensors,sen_str};
    else
        si_str = fname(p-2:p-1);
        sf_str = fname(p+4:p+5);
        si_num = str2num(si_str);
        sf_num = str2num(sf_str);

        sensors = si_num:sf_num;
        sensors(sensors(:) == act_num) = [];
        varargout = {sensors};
    end

end

