close all;clc

key % load API key

Questions={'De functie f wordt voor x > 0 gegeven door f(x) = 2x + 1/x. De functie f heeft een minimum. Bereken exact dit minimum.' % 1
    'De functie f wordt voor x > 0 gegeven door f(x) = 2x + 1/x. Lijn k is de scheve asymptoot van de grafiek van f. Het vlakdeel V wordt ingesloten door de grafiek van f, lijn k en de lijnen met vergelijking x = a en x = 2a met a > 0. De oppervlakte van dit vlakdeel is onafhankelijk van de waarde van a. Bewijs dit.' % 2
    'De functie f wordt voor x > 0 gegeven door f(x) = 2x + 1/x. Verder is gegeven de lijn met vergelijking y = 3. Deze lijn en de gradiek van f sluiten een vlakdeel W in dat wordt gewenteld om de lijn met vergelijking y = 3. Bereken de inhoud van het omwentelingslichaam dat zo ontstaat. Geef je eindantwoord in twee decimalen.' % 3

    'In de werktuigbouw moeten vaak metalen platen in een bepaalde hoek worden gebogen. Een van de technieken die daarbij worden gebruikt is vrijbuigen. Daarbij ligt de metalen plaat op een matrijs met een bepaalde vorm. Hierna wordt een stempel met kracht op de plaat gedrukt, zodat deze de gewenste vorm krijgt. Tijdens het vrijbuigen treedt vervorming op: aan de buitenkant rekt het metaal iets op en aan de binnenkant wordt het samengedrukt. In het inwendige van de metalen plaat bevindt zich de neutrale lijn: de lengte hiervan blijft gelijk na vervorming. In deze opgave nemen we aan dat de dikte van de plaat bij het buigen gelijk blijft. Wanneer de plaat wordt gebogen over een hoek van 45°, verandert rechthoek ABCD in de vorm A''B''C''D''. Hierbij is boog C''D'' de boog van een cirkel met middelpunt M en straal 2d en A''B'' de boog van een cirkel met middelpunt M en straal 3d. De neutrale lijn P''Q'' is een cirkelboog op een afstand van 0,4d van boog C''D''. Verder geldt dat de lengte van de neutrale lijn gelijk blijft, dus de lengte van boog P''Q'' is gelijk aan de lengte van PQ. Bereken algebraïsch hoeveel procent de oppervlakte van vlakdeel A''B''C''D'' groter is dan de oppervlakte van vlakdeel ABCD. Geef je eindantwoord als geheel getal.' % 4
    'In de werktuigbouw moeten vaak metalen platen in een bepaalde hoek worden gebogen. Een van de technieken die daarbij worden gebruikt is vrijbuigen. Daarbij ligt de metalen plaat op een matrijs met een bepaalde vorm. Hierna wordt een stempel met kracht op de plaat gedrukt, zodat deze de gewenste vorm krijgt. De kracht die uitgeoefend moet worden op een metalen plaat om deze te buigen, hangt af van het soort metaal, de dikte van het metaal en de breedte van de opening van de matrijs. De formule om deze kracht uit te rekenen luidt: F = (R*d^2/V) * (1+4d/V) (formule 1). Hierbij is: F de benodigde kracht (in kN/m); R een constante die afhangt van het soort metaal; d de dikte van het metaal (in mm); V de breedte van de opening van de matrijs (in mm). Voor het buigen van een metalen plaat met een dikte van 10 mm op een matrijs met een opening van 200 mm is een kracht van 420 kN/m nodig. Als je deze metalen plaat zou buigen op een matrijs met een opening van 100 mm is meer kracht nodig. Bereken algebraïsch hoeveel kracht er nodig is om deze metalen plaat te buigen op een matrijs met een opening van 100 mm breed. Geef je eindantwoord als een geheel getal.' % 5
    'In de werktuigbouw moeten vaak metalen platen in een bepaalde hoek worden gebogen. Een van de technieken die daarbij worden gebruikt is vrijbuigen. Daarbij ligt de metalen plaat op een matrijs met een bepaalde vorm. Hierna wordt een stempel met kracht op de plaat gedrukt, zodat deze de gewenste vorm krijgt. De kracht die uitgeoefend moet worden op een metalen plaat om deze te buigen, hangt af van het soort metaal, de dikte van het metaal en de breedte van de opening van de matrijs. De formule om deze kracht uit te rekenen luidt: F = (R*d^2/V) * (1+4d/V) (formule 1). Hierbij is: F de benodigde kracht (in kN/m); R een constante die afhangt van het soort metaal; d de dikte van het metaal (in mm); V de breedte van de opening van de matrijs (in mm). Om bij een gegeven plaatdikte de breedte van de opening van de matrijs te berekenen, wordt de volgende formule gebruikt: V =  d^1,75 (formule 2). Door formule 1 en formule 2 te combineren krijg je een formule die de benodigde kracht F uitdrukt in R en d. Er is een plaatdikte d waarbij de benodigde kracht F minimaal is. Bereken exact deze waarde van d.' % 6

    'De bewegingsvergelijkingen van een punt P worden gegeven door: x_P(t) = 2t, y_P(t) = 2t^2. Punt M is het midden van lijnstuk OP. Vector MP wordt rechtsom geroteerd om M over 90°. Zo ontstaat de beeldvector MQ. Tijdens de beweging van P beschrijft ook het punt Q een baan. De bewegingsvergelijkingen van Q worden gegeven door: x_Q(t) = t + t^2, y_Q(t) = t^2 - t. Bewijs dat dit inderdaad de bewegingsvergelijkingen van Q zijn.' % 7
    'De bewegingsvergelijkingen van een punt P worden gegeven door: x_P(t) = 2t, y_P(t) = 2t^2. Punt M is het midden van lijnstuk OP. Vector MP wordt rechtsom geroteerd om M over 90°. Zo ontstaat de beeldvector MQ. Tijdens de beweging van P beschrijft ook het punt Q een baan. De bewegingsvergelijkingen van Q worden gegeven door: x_Q(t) = t + t^2, y_Q(t) = t^2 - t. De snelheid waarmee P beweegt, is gegeven door sqrt(4 + 16t^2) . Voor elke waarde van t is deze snelheid een factor c keer zo groot als de snelheid van Q. Bereken exact de waarde van c.' % 8
    'De bewegingsvergelijkingen van een punt P worden gegeven door: x_P(t) = 2t, y_P(t) = 2t^2. Punt M is het midden van lijnstuk OP. Vector MP wordt rechtsom geroteerd om M over 90°. Zo ontstaat de beeldvector MQ. Tijdens de beweging van P beschrijft ook het punt Q een baan. De bewegingsvergelijkingen van Q worden gegeven door: x_Q(t) = t + t^2, y_Q(t) = t^2 - t. De snelheid waarmee P beweegt, is gegeven door sqrt(4 + 16t^2) . Voor elke waarde van t wordt de lengte L van lijnstuk PQ bepaald. Er geldt: L = |t| * sqrt(2t^2 + 2). Bewijs dit.' % 9
    'De bewegingsvergelijkingen van een punt P worden gegeven door: x_P(t) = 2t, y_P(t) = 2t^2. Punt M is het midden van lijnstuk OP. Vector MP wordt rechtsom geroteerd om M over 90°. Zo ontstaat de beeldvector MQ. Tijdens de beweging van P beschrijft ook het punt Q een baan. De bewegingsvergelijkingen van Q worden gegeven door: x_Q(t) = t + t^2, y_Q(t) = t^2 - t. De snelheid waarmee P beweegt, is gegeven door sqrt(4 + 16t^2) . Voor elke waarde van t wordt de lengte L van lijnstuk PQ bepaald. Er geldt: L = |t| * sqrt(2t^2 + 2). In de oorsprong, bij t = 0 , zien we een knik. Als t vanaf links of vanaf rechts tot 0 nadert, nadert de waarde van L in beide situaties ook tot 0. De helling van de grafiek van L nadert echter niet in beide situaties tot dezelfde waarde. Bereken exact tot welke waarde de helling van de grafiek van L nadert als t vanaf links tot 0 nadert.' % 10

    'De functie f wordt gegeven door f(x) = abs(sin(x) + 1/2*sqrt(3)). A en B zijn de toppen die horen bij de eerste twee maxima van f rechts van de y-as. Er bestaat een sinusoïde die gegeven wordt door g(x) = a + bsin(x), waarvan twee opeenvolgende toppen samenvallen met de punten A en B. Bereken exact de waarde van a and b.' % 11
    'De functie f wordt gegeven door f(x) = abs(sin(x) + 1/2*sqrt(3)). De grafiek van f en de x-as sluiten twee soorten vlakdelen in: kleine vlakdelen en grote vlakdelen. Bereken exact de oppervlakte van een enkel klein vlakdeel.' % 12

    'De functie f wordt gegeven door: f(x) = ln(x). De functie g wordt gegeven door: g(x) = 1 + e^2 * (1-ln(x)). De raaklijnen aan de grafieken van f en g snijden elkaar loodrecht in het snijpunt. Bewijs dit' % 13
    'De functie f wordt gegeven door: f(x) = ln(x). De functie g wordt gegeven door: g(x) = 1 + e^2 * (1-ln(x)). De lijn y = q snijdt de grafiek van g in punt A en de grafiek van f in punt B,  waarbij punt A links van punt B ligt. Er geldt dat AB = 3. Bereken de bijbehorende waarde van q. Geef je eindantwoord in één decimaal.' % 14

    'Gegeven is rechthoek OABC met O(0,0), A(8,0) en C(0,4). De punten F en E zijn de middens van respectievelijk OA en BC. Op de negatieve y-as ligt punt P(0, p). Punt D is het snijpunt van het verlengde van lijnstuk PF en lijnstuk AC. De lijn door E en F is de bissectrice van hoek PED. Bewijs dit voor het geval p = -2.' % 15
    'Gegeven is rechthoek OABC met O(0,0), A(8,0) en C(0,4). De punten F en E zijn de middens van respectievelijk OA en BC. Op de negatieve y-as ligt punt P(0, p). Punt D is het snijpunt van het verlengde van lijnstuk PF en lijnstuk AC. De lijn door E en F is de bissectrice van hoek PED. M(4, 2) is het snijpunt van AC en EF. Cirkel c heeft middelpunt M en gaat door D. Afhankelijk van de positie van punt P (en dus van de waarde van p) is de cirkel groter of kleiner. Er is precies één waarde van p waarvoor cirkel c raakt aan OA en BC. Bereken exact deze waarde van p.' % 16

    'De functie f wordt gegeven door f(x) = 1/(e^x + 1). De grafiek van f heeft twee horizontale asymptoten. Bereken exact de afstand tussen deze twee horizontale asymptoten.' % 17
    'De functie f wordt gegeven door f(x) = 1/(e^x + 1). Een primitieve van f is F(x) = x - ln(e^x + 1). Bewijs dit.' % 18
    'De functie f wordt gegeven door f(x) = 1/(e^x + 1). Lijn k heeft vergelijking x = a, met a > 0. De grafiek van f, de x-as, de y-as en lijn k sluiten een vlakdeel in. De oppervlakte van dit vlakdeel is voor elke waarde van a kleiner dan ln(2). Bewijs dit.'; % 19

    'De functie f wordt gegeven door f(x) = x^5 - 3xsqrt(x). Op de grafiek ligt het punt A(1, -2). Bewijs dat de grafiek van f in A stijgt.' % 20 (2024 - 1)
    'De functie f wordt gegeven door f(x) = x^5 - 3xsqrt(x). Op de grafiek ligt het punt A(1, -2). Het lijnstuk PQ is horizontaal en heeft lengte 1/2. De eindpunten P en Q van dit lijnstuk liggen op de grafiek van f. Bereken de x-coördinaat van P. Geef je eindantwoord in drie decimalen.' % 21 (2024 - 2)

    'Een wachttijd is de tijd die je op een dienst moet wachten. Denk hierbij bijvoorbeeld aan de tijd die nodig is om een medewerker van een klantenservice aan de telefoon te krijgen of de tijd die nodig is voordat je wordt geholpen bij de bakker. In 1909 ontwikkelde de Deense wiskundige Agner Erlang een wiskundig model om te berekenen in hoeveel procent van de gevallen bepaalde wachttijden voorkomen. Dit percentage komt overeen met de oppervlakte onder een grafiek. In deze opgave gaan we uit van een dienst waarbij het volgende model van Erlang hoort: f(t) = 50exp(-(1/2)t) met t>=0. Hierbij is t de tijd in minuten. Stel dat je wilt weten in hoeveel procent van de gevallen de wachttijd tussen 3 en 4 minuten ligt. Je bepaalt dan de oppervlakte van het gebied dat wordt ingesloten door de grafiek van f, de t as en de lijnen met vergelijking t = 3 en t = 4. Deze oppervlakte blijkt (afgerond) 8,8 te zijn. Dit wil zeggen dat in 8,8% van alle gevallen de wachttijd tussen 3 en 4 minuten ligt. Bereken algebraïsch in hoeveel procent van de gevallen de wachttijd tussen 0 en 3 minuten ligt. Geef je eindantwoord in één decimaal.' % 22 (2024 - 3)
    'Een wachttijd is de tijd die je op een dienst moet wachten. Denk hierbij bijvoorbeeld aan de tijd die nodig is om een medewerker van een klantenservice aan de telefoon te krijgen of de tijd die nodig is voordat je wordt geholpen bij de bakker. In 1909 ontwikkelde de Deense wiskundige Agner Erlang een wiskundig model om te berekenen in hoeveel procent van de gevallen bepaalde wachttijden voorkomen. Dit percentage komt overeen met de oppervlakte onder een grafiek. In deze opgave gaan we uit van een dienst waarbij het volgende model van Erlang hoort: f(t) = 50exp(-(1/2)t) met t>=0. Hierbij is t de tijd in minuten. Stel dat je wilt weten in hoeveel procent van de gevallen de wachttijd tussen 3 en 4 minuten ligt. Je bepaalt dan de oppervlakte van het gebied dat wordt ingesloten door de grafiek van f, de t as en de lijnen met vergelijking t = 3 en t = 4. Deze oppervlakte blijkt (afgerond) 8,8 te zijn. Dit wil zeggen dat in 8,8% van alle gevallen de wachttijd tussen 3 en 4 minuten ligt. Een wachttijd van meer dan twintig minuten komt in dit voorbeeld zelden voor. Daarom wordt de gemiddelde wachttijd berekend met: (1/100)int(0,20)t.f(t)dt. Om de gemiddelde wachttijd te kunnen berekenen, maakt iemand gebruik van het gegeven dat y = ((1/a)t - (1/a^2))exp(at) een primitieve is van y = texp(at), met a~=0. Bewijs dat y = ((1/a)t - (1/a^2))exp(at) inderdaad een juiste primitieve is van y = texp(at) voor elke waarde van a.'  % 23 (2024 - 4)
    'Een wachttijd is de tijd die je op een dienst moet wachten. Denk hierbij bijvoorbeeld aan de tijd die nodig is om een medewerker van een klantenservice aan de telefoon te krijgen of de tijd die nodig is voordat je wordt geholpen bij de bakker. In 1909 ontwikkelde de Deense wiskundige Agner Erlang een wiskundig model om te berekenen in hoeveel procent van de gevallen bepaalde wachttijden voorkomen. Dit percentage komt overeen met de oppervlakte onder een grafiek. In deze opgave gaan we uit van een dienst waarbij het volgende model van Erlang hoort: f(t) = 50exp(-(1/2)t) met t>=0. Hierbij is t de tijd in minuten. Stel dat je wilt weten in hoeveel procent van de gevallen de wachttijd tussen 3 en 4 minuten ligt. Je bepaalt dan de oppervlakte van het gebied dat wordt ingesloten door de grafiek van f, de t as en de lijnen met vergelijking t = 3 en t = 4. Deze oppervlakte blijkt (afgerond) 8,8 te zijn. Dit wil zeggen dat in 8,8% van alle gevallen de wachttijd tussen 3 en 4 minuten ligt. Een wachttijd van meer dan twintig minuten komt in dit voorbeeld zelden voor. Daarom wordt de gemiddelde wachttijd berekend met: (1/100)int(0,20)t.f(t)dt. Om de gemiddelde wachttijd te kunnen berekenen, maakt iemand gebruik van het gegeven dat y = ((1/a)t - (1/a^2))exp(at) een primitieve is van y = texp(at), met a~=0. Bereken algebraïsch de gemiddelde wachttijd in minuten voor de situatie f(t) = 50exp((-1/2)t). Geef je eindantwoord als geheel getal.'  % 24 (2024 - 5)

    'De functie f wordt gegeven door f(x) = (3x - 7)^2. De grafiek van f wordt naar rechts en omhoog verschoven. Hierdoor ontstaat de grafiek van de functie g. De grafiek van g gaat door het punt A(5,40). De helling van de raaklijn in A aan de grafiek van g is -6. Stel op exacte wijze een functievoorschrift van g op.' % 25 (2024 - 6)
    'De functie f wordt gegeven door f(x) = base2log(sqrt(1+8^x)). De functie g is de inverse functie van f. Het  lijnstuk is het kortst mogelijke verticale lijnstuk dat de grafieken van f en g met elkaar verbindt. Bereken de lengte van dit lijnstuk. Geef je eindantwoord in twee decimalen.' % 26 (2024 - 7)
    'De functie f wordt gegeven door f(x) = base2log(sqrt(1+8^x)). Op de grafiek van f ligt punt P met x-coördinaat p en punt Q met x-coördinaat p+1. Voor elke waarde van p kan het verschil yQ - yP worden bepaald. Onderzoek op exacte wijze of er een waarde van p is waarvoor dit verschil gelijk is aan 3.' % 27 (2024 - 8)

    'Het punt P beweegt over een baan gegeven door de volgende  bewegingsvergelijkingen: xp(t) = 4cos(t) + cos(4t), yp(t) = 4sin(t) + sin(4t), met t in seconden en 0 <= t <= 2pi. Het punt O beweegt ook over deze baan. Punt O loopt pi seconden voor op punt P. De bewegingsvergelijkingen van Q zijn dus: xq(t) = 4cos(t+pi) + cos(4(t+pi)), yq(t) = 4sin(t+pi) + sin(4(t+pi)), met t in seconden en 0 <= t <= 2pi. Er zijn twee momenten waarop P en Q recht boven elkaar liggen, dus dan geldt x_p = x_q. Berekend exact de afstand tussen P en Q in deze situaties.' % 28 (2024 - 9)
    'Het punt P beweegt over een baan gegeven door de volgende  bewegingsvergelijkingen: xp(t) = 4cos(t) + cos(4t), yp(t) = 4sin(t) + sin(4t), met t in seconden en 0 <= t <= 2pi. Op tijdstip t = (2/3)pi bevindt het punt P zich in (-5/2, (5/2)sqrt(3)). Bereken exact de scherpe hoek in graden tussen de raaklijn aan de baan in punt P en de x as.'; % 29 (2024 - 10)

    'Gegeven zijn de punten A(-1, 0) en B(3, 0). Verder is gegeven de cirkel c met middellijn AB. De lijn k gaat door de oorsprong O en snijdt cirkel c in punt P. De afstand tussen O en P is gelijk is aan 5/2. Bereken exact de x-coördinaat van P.' % 30 (2024 - 11)
    'Gegeven zijn de punten A(-1, 0) en B(3, 0). Verder is gegeven de cirkel c met middellijn AB. De driehoek BRO heeft hoek BRO = 90°, punt R ligt boven de x-as en OR = 1. De lijn door B en R snijdt c in het punt S. Driehoek BSA is dan een driehoek met hoek ASB = 90°. Bereken exact de oppervlakte van vierhoek AORS.'; % 31 (2024 - 12)

    'Voor elke waarde van a wordt de functie fa gegeven door: fa(x) = (ax^2-2)/(x^2+a). Er bestaat geen waarde van a waarvoor de grafiek van fa een perforatie heeft. Bewijs dit.' % 32 (2024 - 13)
    'Voor elke waarde van a wordt de functie fa gegeven door: fa(x) = (ax^2-2)/(x^2+a). In het volgende onderdeel zijn de mogelijke waarden van a de positieve getallen, dus a > 0. De grafiek van fa heeft één top T en deze ligt op de y-as. Verder heeft de grafiek van fa een horizontale asymptoot. Punt S is het snijpunt van de horizontale asymptoot en de y-as. De lengte van lijnstuk ST is afhankelijk van a. Deze lengte heeft een minimum. Bereken exact voor welke positieve waarde van a de lengte van lijnstuk ST minimaal is.'; % 33 (2024 - 14)

    'De Wet van Titius-Bode is een wet uit de astronomie die door Johann Titius werd opgesteld in de achttiende eeuw. Deze wet legt een verband tussen het rangnummer van een planeet en de afstand van die planeet tot de zon. Met het rangnummer van een planeet wordt bedoeld: ‘de zoveelste planeet geteld vanaf de zon’. De planeet die het dichtst bij de zon staat krijgt nummer 1, de volgende 2 enzovoorts. De wet luidt: a = 0,4 +0,3*2^(n-2). Hierin is a de afstand van de planeet tot de zon uitgedrukt in AE (Astronomische Eenheid, 1 AE = afstand van de aarde tot de zon) en is n het rangnummer van de planeet. Saturnus heeft volgens de Wet van Titius-Bode een afstand van 10 AE tot de zon. Bereken exact welk rangnummer Saturnus dan zou hebben.'  % 34 (2024 - 15)
    'We bekijken de planeten Mars, Venus en de aarde. We gaan uit van het volgende eenvoudige model: De drie planeten draaien ieder in een cirkelvormige baan met de zon als middelpunt. De drie banen liggen in één plat vlak. De afstand van Venus tot de zon is 0,7 AE, de afstand van de aarde tot de zon is 1,0 AE en de afstand van Mars tot de zon is 1,6 AE. Het is mogelijk dat de drie planeten op één lijn liggen waarbij Venus precies midden tussen Mars en de aarde in ligt. De afstand in AE van de aarde tot Venus is d en hoek AVZ in graden is α. Het volgende verband tussen d en alpha kan worden gevonden: (d^2 - 0,51)/cos(α) = (d^2 - 2,07)/cos(180° - α). Bewijs dat dit verband juist is.' % 35 (2024 - 16)
    'We bekijken de planeten Mars, Venus en de aarde. We gaan uit van het volgende eenvoudige model: De drie planeten draaien ieder in een cirkelvormige baan met de zon als middelpunt. De drie banen liggen in één plat vlak. De afstand van Venus tot de zon is 0,7 AE, de afstand van de aarde tot de zon is 1,0 AE en de afstand van Mars tot de zon is 1,6 AE. Het is mogelijk dat de drie planeten op één lijn liggen waarbij Venus precies midden tussen Mars en de aarde in ligt. Bereken algebraïsch de afstand in AE van de aarde tot Venus in de gegeven situatie. Geef je eindantwoord in twee decimalen.' % 36 (2024 - 17)
    'Meestal wordt gezegd dat de planeten in ons zonnestelsel om de zon draaien. Dat klopt echter niet helemaal: de zon en de planeten draaien allemaal om hun gemeenschappelijke zwaartepunt. Stel dat het zonnestelsel alleen zou bestaan uit Jupiter en de zon. We beschouwen deze twee hemellichamen als twee puntmassa’s. Jupiter is verreweg de zwaarste planeet in ons zonnestelsel met een massa van 2.10^27 kg en een afstand tot de zon van 8.10^8 km. De zon heeft een massa van 2.10^30 kg. Bereken de straal van de baan van de zon om het zwaartepunt in km. Geef je eindantwoord in honderdduizendtallen.'}; % 37 (2024 - 18)

for m = 1:3 % model type
    for q = 20:37 % loop over questions
        import matlab.net.* matlab.net.http.* matlab.net.http.io.*

        header = [HeaderField('Content-Type', 'application/json');HeaderField('Authorization', api_key)]';
        uri = URI('https://api.openai.com/v1/chat/completions');

        prompt = Questions(q);
        if m==1 % o1-preview
            body = JSONProvider(struct('model', 'o1-preview-2024-09-12','messages', {{struct('role', 'user','content', prompt')}}));
        elseif m==2 % gpt-4o
            body = JSONProvider(struct('model', 'gpt-4o-2024-05-13','messages', {{struct('role', 'user','content', prompt')}}));
        elseif m==3 % o1-mini
            body = JSONProvider(struct('model', 'o1-mini-2024-09-12','messages', {{struct('role', 'user','content', prompt')}}));
        end

        tic % saves the current time that 'toc' uses later to measure the time elapsed between the two.
        response = RequestMessage('post', header, body).send(uri.EncodedURI);
        if q>19 % 2024 exam
            disp(['QUESTION NUMBER: ' num2str(q-19)])
        else % 2023 exam
            disp(['QUESTION NUMBER: ' num2str(q)])
        end
        disp(['MODEL NUMBER: ' num2str(m)])
        disp('TOKEN USAGE:')
        disp([response.Body.Data.usage.prompt_tokens ...
            response.Body.Data.usage.completion_tokens ...
            response.Body.Data.usage.total_tokens ...
            response.Body.Data.usage.completion_tokens_details.reasoning_tokens])
       
        disp(['TIME TAKEN: ' num2str(toc) ' seconds'])
        disp('OUTPUT:')
        disp(response.Body.Data.choices.message.content);
    end
end
