# ChildsPlayAccessibility

Notebooks 3.1-4 allow you to calculate the child's play accessibility metric: calculating the ease with which children can reach places for play in the city without supervision. The child's play accessibility metric takes into account how children may play not only in playgrounds, but also in informal play space such as schoolyards and small greenspaces. In addition, it accounts for (perceived) barriers that may exist for children in the city, such as busy roads, railways, and large natural environments. We recommend complementing our child's play accessibility metric with field work and collecting knowledge of local people, to understand all local nuances that may affects children who wish to access places for play. 

The child's play accessibility metric was co-designed with experts on the built environment and children's health. This code is developed for three cities in Europe (i.e., areas in Milan, Ljubljana, and Utrecht) but can be adapted to fit other geographical contexts. 

## Using ChildsPlayAccessibility?

If you use ChildsPlayAccessibility in your work, please cite the conference paper.

**Citation info:** Roos Teeuwen and Achilleas Psyllidis. Easy as child’s play? Co-designing a network-based metric for children’s access to play space. In press. 2023.

Associated input and output datasets are available at https://doi.org/10.4121/22293538.

<p align="center">
    <img src="https://github.com/rflteeuwen/ChildsPlayAccessibility/blob/main/figures/results.png" width="50%">
</p>

**Abstract:** Accessible outdoor spaces for unsupervised play are important for children’s health. However, parents impose constraints based on their perception of safety, which can have a significant impact on which play spaces are actually accessible to children. Such constraints are not taken into account by widely adopted accessibility indicators that use generic radial buffers or travel distances. We introduce a child’s play accessibility metric, which measures the ease with which children can reach outdoor play spaces without supervision. We developed this metric through an iterative co-design process with experts on the built environment and children’s health, leveraging open data. Our metric considers traffic, natural barriers to children, and a range of playable spaces. It can be used by planners and policymakers to enable large-scale assessments of play space accessibility, identify associated equity issues, and benchmark progress toward healthier environments for all ages.

**Keywords:** Accessibility, Play space, Children, Co-design, OpenStreetMap
