function [dvec_int,pressure,rho_new,mu_new] = makelayer_pressure(depth,dend,dstep);
% c THIS SUBROUTINE TAKES THE VOLUME AVERAGES OF THE PREM PARAMETERS
% c OF A M-LAYER MODEL AND ASSIGNS THEM TO AN N-LAYER MODEL (N<M)
% c
% c It asks for the name of the output file, the number of layers
% c and the layers in PREM that you want to average.
% c
% c Wouter van der Wal, July 2005, University of Calgary
% c
% c November 4 2005: 
% c Input file prem changed to lay111 because this file
% c has a better representation of the discontinuities

% March 23, 2010: changed from fortran to MATLAB code
% March 29, 2010: Boundaries not equal to PREM boundaries can be employed
% March 29, 2010: Gravity added, only for outside CMB
%

% lay111 is the PREM model
infile = 'lay111';
[layer,r,rho,mu] = textread(infile,'%u %f %f %f%*[^\n]','headerlines',4);
r = r/1e3;  % in km

nlayer          = length(depth);
dvec            = dstep/2:dstep:dend-dstep/2;
% first value in pressure is zero;
% integral is approximated by midpoint:
% density(5km)*g(5km)*10km = pressure at 10 km
% density(dend-dstep/2)*g(dend-dstep/2)*10km = pressure at dend
dvec_int        = 0:dstep:dend;

% Initialization
rho_new = zeros(nlayer,1);
mu_new = zeros(nlayer,1);
r_new = r(1)-depth;

premlayers = zeros(nlayer,1);
premlayers(1) = 0;
for ii = 2:nlayer
    premlayers(ii) = find(r>=r_new(ii),1,'last');
end

%% Averaging for density and rigidity

for ii = 1:nlayer-1;    
    mean1 = 0.;
    mean3 = 0.;
    total = 0;
     
    % Part of the layer above the PREM layer, for ii = 1 this layer does
    % not exist
    if (ii>=2)
        mean1  = mean1+ (  (r_new(ii)^3  -  r(premlayers(ii)+1)^3  )/ (r_new(ii)^3-r_new(ii+1)^3)   )*rho(premlayers(ii));
        mean3  = mean3+ (  (r_new(ii)^3  -  r(premlayers(ii)+1)^3  )/ (r_new(ii)^3-r_new(ii+1)^3)   )*mu(premlayers(ii));
        total = total + r_new(ii)  -  r(premlayers(ii)+1);
    end
    
    % PREM layers
    if premlayers(ii)+1 <= premlayers(ii+1)-1    % if not the entire layer 
        
        for jj = premlayers(ii)+1:premlayers(ii+1)-1;
            mean1  = mean1+ ( (r(jj)^3-r(jj+1)^3)/(r_new(ii)^3-r_new(ii+1)^3) )*rho(jj);
            mean3  = mean3+ ( (r(jj)^3-r(jj+1)^3)/(r_new(ii)^3-r_new(ii+1)^3) )*mu(jj);
            if ~(r(jj)-r(jj+1)==0)
                total = total + r(jj)-r(jj+1);
            end
        end
    end
    
    % Part of the layer below the PREM layer
    mean1  = mean1+ ( (r(premlayers(ii+1))^3 - r_new(ii+1)^3)/ (r_new(ii)^3-r_new(ii+1)^3) )*rho(premlayers(ii+1));
    mean3  = mean3+ ( (r(premlayers(ii+1))^3 - r_new(ii+1)^3)/ (r_new(ii)^3-r_new(ii+1)^3) )*mu(premlayers(ii+1));
    total = total + r(premlayers(ii+1)) - r_new(ii+1);
    if (total~=r_new(ii)-r_new(ii+1))
        error('total of averaged layers does not match thickness of the new layer');
    end
    
    rho_new(ii) = mean1;
    mu_new(ii)  = mean3;
    
end
rho_new(nlayer) = rho(end);
mu_new(nlayer)  = mu(end);

kk = 0;
for x = dvec
    kk = kk+1;
    % Determine in which layer of r_new the gravity is computed
    lay(kk) = find(depth<=x,1,'last');
end

%% Computing pressure
z = 1:length(dvec);
% Approximation of integral of rho*g*dz with depth.
pressure = cumsum([0; rho_new( lay(z) ).*gravity(z,depth,rho_new,false)*dstep*1e3 ]);
pressureend = pressure(end);







