% Olivine flow law parameters 
% Wet olivine - Hirth and Kohlstedt 2003
%
% Wouter van der Wal, Delft University of Technology, 2013

function [Bdisl,Bdiff] = flowlawolivinewet(T,d,phi,P,water);


R = 8.314;
Bdiff  = 1e6.*(d.^-3).*water.^1.*exp(30*phi).*exp(-(335e3+P*4e-6).*(R*T).^-1);
Bdisl  = 90.*(d.^0).*water.^1.2.*exp(30*phi).*exp(-(480e3+P*11e-6).*(R*T).^-1);
