% Olivine flow law parameters 
% Dry olivine - Hirth and Kohlstedt 2003
%
% Wouter van der Wal, Delft University of Technology, 2013

function [Bdisl,Bdiff] = flowlawolivine(T,d,phi,P);

R = 8.314;

Bdiff =  1.5e9.*(d.^-3).*exp(30*phi).*exp(-(375e3+P*5e-6).*(R*T).^-1);
Bdisl =  1.1e5.*(d.^0).*exp(30*phi).*exp(-(530e3+P*23e-6).*(R*T).^-1);
