#!/bin/bash

a=-105000 # begin time ANICE simulation [years] 
icestep=5000 # timestep ANICE [years]  
# Adjust the above variables a and icestep, and the variable i below in this file.
# Make sure that the correct restart.nc file is copied to ANICE folder "restartlaststep"
# Add correct fem_deflection_to_ANICE (dHb.dat from last timestep).
# Make sure that step.dat=0, res=1 of 2 in Iter_ult_Ex1.py, j.dat is 0, and that there is a Earth.cae file and a Earth0.cae file in folder  /home/username/HetGroteKoppelScript/GIA_Model/
# The following files are needed for a restart:
    # restart (job-name.res; file size limited to 16 gigabytes), 
    # analysis database (.mdl and .stt), 
    # part (.prt), 
    # output database (.odb)
    # linear dynamics and substructure database (.sim) files.
# Make sure that ANICE starts at -120 000 years and ends at - 115 000 years and that dt's the same at the variable icestep.
# For 3D: run element_list.py and create e.dat for the correct coordinates

for i in {3..50} #loop over timesteps
do
    k=0
    echo 'Start Coupling.sh step:'
    echo $i
    # cp /home/username/HetGroteKoppelScript/ANICE/input_fields/antarctica/RSL/RSL${i}.dat /home/username/HetGroteKoppelScript/ANICE/input_fields/antarctica/RSL/RSL.dat
    sed -i "1s/1/0/g" /home/username/HetGroteKoppelScript/GIA_Model/Converged.dat
    
    if [ $i -eq 20 ]
    then
        icestep=1000 # timestep ANICE [years] 
        sed -i "44,46s/5000/$icestep/g" /home/username/HetGroteKoppelScript/ANICE/config_files/config_ANICE4_restart
        sed -i "24,24s/15000/19000/g" /home/username/HetGroteKoppelScript/ANICE/config_files/config_ANICE4_restart
        echo 'icestep changed to:'
        echo $icestep
    fi
    if [ $i -eq 25 ]
    then
        icestep=500 # timestep ANICE [years] 
        sed -i "44,46s/1000/$icestep/g" /home/username/HetGroteKoppelScript/ANICE/config_files/config_ANICE4_restart
        sed -i "24,24s/14000/14500/g" /home/username/HetGroteKoppelScript/ANICE/config_files/config_ANICE4_restart
        echo 'icestep changed to:'
        echo $icestep
    fi
    if [ $i -eq 45 ]
    then
        icestep=1000 # timestep ANICE [years] 
        sed -i "44,46s/500/$icestep/g" /home/username/HetGroteKoppelScript/ANICE/config_files/config_ANICE4_restart
        sed -i "24,24s/4500/4000/g" /home/username/HetGroteKoppelScript/ANICE/config_files/config_ANICE4_restart
        echo 'icestep changed to:'
        echo $icestep
    fi
    if [ $i -eq 49 ]
    then
        icestep=500 # timestep ANICE [years] 
        sed -i "44,46s/1000/$icestep/g" /home/username/HetGroteKoppelScript/ANICE/config_files/config_ANICE4_restart
        sed -i "24,24s/0/-500/g" /home/username/HetGroteKoppelScript/ANICE/config_files/config_ANICE4_restart
        echo 'icestep changed to:'
        echo $icestep
    fi           
    
    echo 'Start Coupling.sh iteration:'
    j=1
    echo $j
    if [ $i -eq 0 ]
    then
        echo 'Start run ANICE (run_coupled_model_nomaking.sh)'
        /home/username/HetGroteKoppelScript/ANICE/run_coupled_model_nomaking.sh normal 
    else
        /home/username/HetGroteKoppelScript/ANICE/run_coupled_nomaking_restart.sh normal
        echo 'Start run ANICE (run_coupled_model_nomaking_restart.sh)'            
    fi          
    wait       
    echo 'Run ANICE finished'

    # move Ice output from ice folder to oblimap folder and to storage folder
    cp /home/username/HetGroteKoppelScript/ANICE/results/help_fields_ant.nc /home/username/HetGroteKoppelScript/Oblimap_ANICE2FEM/data/help_fields_ant.nc
    for n in /home/username/HetGroteKoppelScript/ANICE/results/*; do cp "$n" "$n"_${i}_${j}; done
    mv /home/username/HetGroteKoppelScript/ANICE/results/*_${i}_${j} /home/username/HetGroteKoppelScript/ANICE/results_storage/        
    wait
    echo 'All files are saved in results_storage'
    
    # run Oblimap
    echo 'Oblimap starts run_interpolation_im_to_fem.sh and run_interpolation_im_to_fem_mask.sh'
    /home/username/HetGroteKoppelScript/Oblimap_ANICE2FEM/run_interpolation_im_to_fem.sh
    wait
    echo 'Oblimap is finished'
    # move interpolated Oblimap ouput
    cp /home/username/HetGroteKoppelScript/Oblimap_ANICE2FEM/oblimap-results/fem_ice_load_from_ANICE.dat /home/username/HetGroteKoppelScript/GIA_Model/DataIce_in.dat 
    cp /home/username/HetGroteKoppelScript/Oblimap_ANICE2FEM/oblimap-results/fem_ice_load_from_ANICE.dat /home/username/HetGroteKoppelScript/GIA_Model/Deflection_storage/DataIce_in_${i}.dat 
    echo 'fem_ice_load_from_ANICE.dat is moved and changed name to DataIce_in.dat'
    
    # Run fem model
    echo 'GIA model starts'
    time abaqus cae noGUI=/home/username/HetGroteKoppelScript/GIA_Model/Iter_ult.py
    wait
    echo 'GIA model finished!'

    # cp /home/username/HetGroteKoppelScript/GIA_Model/Geoid_output.dat /home/username/HetGroteKoppelScript/GIA_Model/Deflection_storage/Geoid_${i}_${j}.dat
    cp /home/username/HetGroteKoppelScript/GIA_Model/DataLoad_in.dat /home/username/HetGroteKoppelScript/GIA_Model/Deflection_storage/DataLoad_in_${i}.dat
    cp /home/username/HetGroteKoppelScript/GIA_Model/Data_output.dat /home/username/HetGroteKoppelScript/GIA_Model/Deflection_storage/Data_output_${i}.dat
    
    cp /home/username/HetGroteKoppelScript/GIA_Model/Earth.cae /home/username/HetGroteKoppelScript/GIA_Model/Earth$(expr $i + 1).cae

    # move deflection to Oblimap and to storage
    if [ $i -eq 0 ]
    then
        cp /home/username/HetGroteKoppelScript/GIA_Model/Deflection${i}.dat /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/data/Deflection.dat
        cp /home/username/HetGroteKoppelScript/GIA_Model/Deflection${i}.dat /home/username/HetGroteKoppelScript/GIA_Model/Deflection_storage/Deflection${i}_${j}.dat
    else
        cp /home/username/HetGroteKoppelScript/GIA_Model/DeflectionDiff.dat /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/data/Deflection.dat
        cp /home/username/HetGroteKoppelScript/GIA_Model/DeflectionDiff.dat /home/username/HetGroteKoppelScript/GIA_Model/Deflection_storage/DeflectionDiff_${i}_${j}.dat
    fi  
    wait
    echo 'DeflectionDiff.dat is moved and renamed to Deflection.dat'
    
    # Run oblimap
    echo 'Oblimap starts (run_deflection_fem_to_ANICE.sh)'
    /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/run_deflection_fem_to_ANICE.sh
    wait
    echo 'Oblimap finished'
    # move file
    cp /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/oblimap-results/fem_deflection_to_ANICE.dat /home/username/HetGroteKoppelScript/ANICE/input_fields/antarctica/
    wait
    echo 'fem_deflection_to_ANICE.dat is copied to ANICE folder'
    if [ $i -eq 0 ]
    then
        echo 'Start run ANICE (run_coupled_model_nomaking.sh)'
        /home/username/HetGroteKoppelScript/ANICE/run_coupled_model_nomaking.sh normal 
    else
        /home/username/HetGroteKoppelScript/ANICE/run_coupled_nomaking_restart.sh normal
        echo 'Start run ANICE (run_coupled_model_nomaking_restart.sh)'            
    fi
    wait       
    echo 'Run ANICE finished'
    cp /home/username/HetGroteKoppelScript/ANICE/results/restart_ant.nc /home/username/HetGroteKoppelScript/ANICE/restartlaststep/restart_ant.nc
    for n in /home/username/HetGroteKoppelScript/ANICE/results/*; do cp "$n" "$n"_${i}; done
    mv /home/username/HetGroteKoppelScript/ANICE/results/*_${i} /home/username/HetGroteKoppelScript/ANICE/results_storage/        
    wait
    
    if [ $i -eq 19 ]
    then
        cp /home/username/HetGroteKoppelScript/GIA_Model/Deflection19to20.dat /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/data/Deflection.dat
        # Run oblimap
        echo 'Oblimap starts (run_deflection_fem_to_ANICE.sh)'
        /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/run_deflection_fem_to_ANICE.sh
        wait
        echo 'Oblimap finished'
        # move file
        cp /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/oblimap-results/fem_deflection_to_ANICE.dat /home/username/HetGroteKoppelScript/ANICE/input_fields/antarctica/
        wait
    fi
    if [ $i -eq 24 ]
    then
        cp /home/username/HetGroteKoppelScript/GIA_Model/Deflection24to25.dat /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/data/Deflection.dat
        # Run oblimap
        echo 'Oblimap starts (run_deflection_fem_to_ANICE.sh)'
        /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/run_deflection_fem_to_ANICE.sh
        wait
        echo 'Oblimap finished'
        # move file
        cp /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/oblimap-results/fem_deflection_to_ANICE.dat /home/username/HetGroteKoppelScript/ANICE/input_fields/antarctica/
        wait
    fi
    if [ $i -eq 44 ]
    then
        cp /home/username/HetGroteKoppelScript/GIA_Model/Deflection44to45.dat /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/data/Deflection.dat
        # Run oblimap
        echo 'Oblimap starts (run_deflection_fem_to_ANICE.sh)'
        /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/run_deflection_fem_to_ANICE.sh
        wait
        echo 'Oblimap finished'
        # move file
        cp /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/oblimap-results/fem_deflection_to_ANICE.dat /home/username/HetGroteKoppelScript/ANICE/input_fields/antarctica/
        wait
    fi
    if [ $i -eq 48 ]
    then
        cp /home/username/HetGroteKoppelScript/GIA_Model/Deflection48to49.dat /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/data/Deflection.dat
        # Run oblimap
        echo 'Oblimap starts (run_deflection_fem_to_ANICE.sh)'
        /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/run_deflection_fem_to_ANICE.sh
        wait
        echo 'Oblimap finished'
        # move file
        cp /home/username/HetGroteKoppelScript/Oblimap_FEM2ANICE/oblimap-results/fem_deflection_to_ANICE.dat /home/username/HetGroteKoppelScript/ANICE/input_fields/antarctica/
        wait
    fi   
    
    # Increase Step.dat with 1 step
    h=$(expr $i + 1)
    sed -i "s/$i/$h/g" /home/username/HetGroteKoppelScript/GIA_Model/Step.dat
    # Change timestep in config file from ANICE
    b=$(expr $a + $icestep)  
    c=$(expr $b + $icestep)
    wait    
    sed -i "24,24s/$b/$c/g" /home/username/HetGroteKoppelScript/ANICE/config_files/config_ANICE4_restart
    sed -i "23,23s/$a/$b/g" /home/username/HetGroteKoppelScript/ANICE/config_files/config_ANICE4_restart
    a=$(expr $a + $icestep)
done
