program read_deflection

implicit none

  integer, parameter :: nlon = 1441
  integer, parameter :: nlat =  721
  
  real, dimension(nlat,nlon) :: deflection
  real, dimension(nlon)      :: longitude
  real, dimension(nlat)      :: latitude
  
  integer :: i, j


!
! -- create longitude and latitude
  do i = 1,nlon
    longitude(i) = -180. + 0.25*real(i-1)
  end do

  do i = 1,nlat
    latitude(i) = 90. - 0.25*real(i-1)
  end do

!
! -- read the data from file (rows is latitude, columns is longitude
  open (1,form='formatted',file='/home/username/HetGroteKoppelScript/Oblimap_FEM2AnIce/data/Deflection.dat',status='old')

  do i = 1,nlat
   read(1,*) (deflection(i,j),j=1,nlon)
  end do

!
! -- output for generating netcdf file

write(111,'(A)') 'netcdf /home/username/HetGroteKoppelScript/Oblimap_FEM2AnIce/data/deflection-input-new {'
write(111,'(A)') 'dimensions:'
write(111,'(A,i4,A2)') '	lon = ',nlon,' ;'
write(111,'(A,i4,A2)') '	lat = ',nlat,' ;'
write(111,'(A)') 'variables:'
write(111,'(A)') 'double lon(lon) ;'
write(111,'(A)') 'double lat(lat) ;'
write(111,'(A)') 'double deflection(lat,lon) ;'
write(111,'(A)') 'data:'

write(111,*)
write(111,'(A)') 'lon = '
write(111,'(1500(f7.2,a2))') longitude(1),(', ',longitude(i),i=2,nlon),' ;'

write(111,*)
write(111,'(A)') 'lat = '
write(111,'(800(f7.2,a2))') latitude(1),(', ',latitude(i),i=2,nlat),' ;'

write(111,*)
write(111,'(A)') 'deflection = '
  do i = 1,nlat
   if (i==nlat) then
    write (111,'(1500(e14.5,a2))') deflection(i,1),(', ',deflection(i,j),j=2,nlon),' ;'
   else 
    write (111,'(1500(e14.5,a2))') (deflection(i,j),', ',j=1,nlon)
   end if
  end do 

write(111,*)
write(111,'(A)') '}'


end
