#!/bin/sh
export LD_LIBRARY_PATH="/usr/local/lib"

rm -f /home/username/HetGroteKoppelScript/Oblimap_AnIce2FEM/oblimap-results/fem_ice_load_from_anice_ant.nc
# To interpolate multiple ice sheet grids to one global grid, one needs to use the mapped field 
# from the previous interpolation step. Also in the case of the NH, the greenland grid overlaps 
# with areas of North America and Eurasia, so order is important here as well. 

# we start with a field of zeros, since ice load is only determined by the output of the ice-sheet model. 

# Please note in the configuration files the path to the initial files of the ice-sheet model, also 
# here as an example we use one time step, but this can be changed whilst running.

# Initial field: fem_field_of_zeros.nc
# Output: fem_ice_load_from_anice_ant.nc
/home/username/HetGroteKoppelScript/Oblimap_AnIce2FEM/src/oblimap_im_to_gcm_program /home/username/HetGroteKoppelScript/Oblimap_AnIce2FEM/config-files/config_oblimap_im_to_fem_antarctica_40x40km_iceload


# # Initial field: fem_ice_load_from_anice_ant.nc
# # Output: fem_ice_load_from_anice_ant_nam.nc
# ./src/oblimap_im_to_gcm_program config-files/config_oblimap_im_to_fem_northamerica_40x40km_iceload

# # Initial field: fem_ice_load_from_anice_ant_nam.nc
# # Output: fem_ice_load_from_anice_ant_nam_eas.nc
# ./src/oblimap_im_to_gcm_program config-files/config_oblimap_im_to_fem_eurasia_40x40km_iceload

# # BdB: interpolation of the last region (Greenland) overlaps with parts of North America 
# #      and Eurasia. Therefore  the mapping program is slightly adjusted such that values 
# #      of the previous field (fem_ice_load_from_anice_ant_nam_eas.nc) are preserved. 
# #      This is done by compiling the oblimap_im_to_gcm_program with the (slightly) adjusted 
# #      module oblimap_im_to_gcm_mapping_module_last.f90. 
# #      Note that for the previous 3 interpolations, the original version is used.
# #
# # Initial field: fem_ice_load_from_anice_ant_nam_eas.nc
# # Output: fem_ice_load_from_anice_ant_nam_eas_grl.nc
# ./src/oblimap_im_to_gcm_program_last config-files/config_oblimap_im_to_fem_greenland_20x20km_iceload

# # Remove previous interpolation fields and files
# rm -f fem_ice_load_from_anice_ant.nc
# rm -f log-config-variable-list-01.txt oblimap-performance.txt
