       SUBROUTINE UEXTERNALDB(LOP,LRESTART,TIME,DTIME,KSTEP,KINC)
! Author: Haiyang Hu

! "User_2.f" is a fortran module that is used by Iter_ult.py to assign the diffusion and dislocation parameters to the 3D GIA model. The rows in the input file e.dat refer to the elements and the file should contain 3 columns; (1) element number in order from 
! low to high, (2) diffusion parameter and (3) dislocation parameter. Adjust the total number of elements in this script to the total number of elements in the input file.

! Created in 2014 by Haiyang Hu
       INCLUDE 'ABA_PARAM.INC'
C       INCLUDE 'param_umat.txt'
       COMMON /SHARE/ Bdiff,Bdisl
C
	   TotalElem = 288472
       INTEGER ii,e
       DIMENSION TIME(2)
       REAL*8 Bdiff(TotalElem),Bdisl(TotalElem)
       CHARACTER(256) filename
C
C
C
       filename='/home/username/3Dvisc/e_wet.dat'
           open(16,file=filename)
	     do ii=1,TotalElem
	       read(16,*) e,Bdiff(ii),Bdisl(ii)
	     enddo
           close(16)
       return
       end 

	 
      SUBROUTINE CREEP(DECRA,DESWA,STATEV,SERD,EC,ESW,P,QTILD,
     1 TEMP,DTEMP,PREDEF,DPRED,TIME,DTIME,CMNAME,LEXIMP,LEND,
     2 COORDS,NSTATV,NOEL,NPT,LAYER,KSPT,KSTEP,KINC)
C
      INCLUDE 'ABA_PARAM.INC'
C       INCLUDE 'param_umat.txt'
      COMMON /SHARE/ Bdiff,Bdisl
C
      CHARACTER*80 CMNAME
	INTEGER els(TotalElem),index,ii
      REAL*8 A,ALIN
      REAL*8 Bdiff(TotalElem),Bdisl(TotalElem)
      DIMENSION DECRA(5),DESWA(5),STATEV(*),PREDEF(*),DPRED(*),
     1 TIME(2),COORDS(*),EC(2),ESW(2)
C
      AN = 3.5
      ANM1 = 2.5
C
	  ALIN = Bdiff(NOEL)
	  A = Bdisl(NOEL)
C	  
	DECRA(1) = ALIN*QTILD*DTIME + A*QTILD**AN*DTIME
	IF(LEXIMP.EQ.1) THEN
	  DECRA(5) = ALIN*DTIME + AN*A*QTILD**(ANM1)*DTIME
	END IF
      RETURN
      END
