# -*- coding: utf-8 -*-
# 3D GIA model using ABAQUS2019: developed at the Technical University of Delft, Astrodynamics and Space Missions. 
# Author: Bas Blank

# "Sph_tools_intial_load" removes spherical harmonics degree 1 and 0 components of the load.
# Created in 2017 by Bas Blank

# Reference: Blank, B., Barletta, V., Hu, H., Pappa, F., & van der Wal, W. (2021). Effect of Lateral and Stress‐Dependent Viscosity Variations on GIA Induced Uplift Rates in the Amundsen Sea Embayment. Geochemistry, Geophysics, Geosystems, 22(9), e2021GC009807.


import sys
import os

sys.path=['','/usr/local/lib64/python2.7/site-packages/distribute-0.6.28-py2.7.egg','/usr/local/lib64/python2.7/site-packages/matplotlib-0_unknown-py2.7-linux-x86_64.egg','/usr/local/lib64/python2.7/site-packages/pyparsing-2.0.6-py2.7.egg','/usr/local/lib64/python2.7/site-packages/cycler-0.9.0-py2.7.egg','/usr/local/lib64/python2.7/site-packages/pytz-2015.7-py2.7.egg','/usr/local/lib64/python2.7/site-packages/functools32-3.2.3_2-py2.7.egg','/usr/local/lib64/python2.7/site-packages/python_dateutil-2.4.2-py2.7.egg','/usr/local/lib64/python2.7/site-packages/six-1.10.0-py2.7.egg','/usr/lib/python27.zip','/usr/lib64/python2.7','/usr/lib64/python2.7/plat-linux2','/usr/lib64/python2.7/lib-tk','/usr/lib64/python2.7/lib-old','/usr/lib64/python2.7/lib-dynload','/usr/lib64/python2.7/site-packages','/usr/local/lib64/python2.7/site-packages','/usr/local/lib/python2.7/site-packages','/usr/lib/python2.7/site-packages','/usr/lib/python2.7/site-packages/setuptools-0.6c11-py2.7.egg-info','/usr/lib64/python2.7/site-packages/wx-2.8-gtk2-unicode']
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            

import numpy as  np
print np.version.version
import scipy as sp
pi=np.pi
from scipy.interpolate import griddata
import spherepy as sph
    

if __name__=='__main__':
    if 'Model_data_coupling' in (sys.modules.keys()):
        reload(Model_data_coupling)
        from Model_data_coupling import *
    else:
        Dir=r"/home/username/HetGroteKoppelScript/GIA_Model/"
        os.chdir(Dir)
        import Model_data_coupling
        from Model_data_coupling import *

    load_data_conjuncted = np.real(np.zeros([grid1+1,grid1*2+1]))
    load_data_reverse = np.zeros([grid1+1,grid1*2+1])
    load_data_reverseSH01 = np.zeros([grid1+1,grid1*2+1])

    DataIce_in=np.loadtxt('DataIce_in.dat')
    i = np.loadtxt('Step.dat'); i=int(i) 
    load_data = np.loadtxt('DataIce_in.dat')

    ## !input definition is [0 360] long while output definition is [-180 180]!
    load_data_reverse = load_data
    DATA_Load=sph.ScalarPatternUniform(load_data_reverse[:,0:-1])
    clm=sph.spht(DATA_Load,Degree_initial,Degree_initial)
    
    if DisableSH_0_1 ==1:
        print('no Degree 0 & 1 for initial load enabled')
        clm_SH01 = clm[0:1,:]
    
        block_data_refined2 = np.real(sph.ispht(clm_SH01,grid1+1,grid1*2).cdata)
        block_data_refined2 = np.hstack([block_data_refined2, block_data_refined2[:,0:1]])
             
        load_data_reverseSH01 = block_data_refined2
        load_data_reverse = load_data_reverse - load_data_reverseSH01
       
    load_data_conjuncted = load_data_reverse
        
    fileout=open('DataLoad_in.dat','w')
    np.savetxt(fileout, load_data_conjuncted)
    fileout.close()

    
