# -*- coding: utf-8 -*-
# 3D GIA model using ABAQUS2019: developed at the Technical University of Delft, Astrodynamics and Space Missions. 
# Author 1: Bas Blank
# Author 2: Haiyang Hu
# Author 3: username van Calcar

# "Sph_tools" computes the deformation in the spherical domain.  
# 2014 - 2016: Haiyang hu developed the script.
# 2016 - 2019: Bas Blank (Blank et al., 2021)
# 2019 - 2020: username van Calcar adjusted the script to make it coincide with the new structure of Iter_ult.py to be able to restart the model at each timestep.

# References: 
	# Blank, B., Barletta, V., Hu, H., Pappa, F., & van der Wal, W. (2021). Effect of Lateral and Stress‐Dependent Viscosity Variations on GIA Induced Uplift Rates in the Amundsen Sea Embayment. Geochemistry, Geophysics, Geosystems, 22(9), e2021GC009807.


import sys
import os

sys.path=['','/usr/local/lib64/python2.7/site-packages/distribute-0.6.28-py2.7.egg','/usr/local/lib64/python2.7/site-packages/matplotlib-0_unknown-py2.7-linux-x86_64.egg','/usr/local/lib64/python2.7/site-packages/pyparsing-2.0.6-py2.7.egg','/usr/local/lib64/python2.7/site-packages/cycler-0.9.0-py2.7.egg','/usr/local/lib64/python2.7/site-packages/pytz-2015.7-py2.7.egg','/usr/local/lib64/python2.7/site-packages/functools32-3.2.3_2-py2.7.egg','/usr/local/lib64/python2.7/site-packages/python_dateutil-2.4.2-py2.7.egg','/usr/local/lib64/python2.7/site-packages/six-1.10.0-py2.7.egg','/usr/lib/python27.zip','/usr/lib64/python2.7','/usr/lib64/python2.7/plat-linux2','/usr/lib64/python2.7/lib-tk','/usr/lib64/python2.7/lib-old','/usr/lib64/python2.7/lib-dynload','/usr/lib64/python2.7/site-packages','/usr/local/lib64/python2.7/site-packages','/usr/local/lib/python2.7/site-packages','/usr/lib/python2.7/site-packages','/usr/lib/python2.7/site-packages/setuptools-0.6c11-py2.7.egg-info','/usr/lib64/python2.7/site-packages/wx-2.8-gtk2-unicode']

import numpy as  np
print np.version.version
import scipy as sp
pi=np.pi
from scipy.interpolate import griddata
from numpy import complex64
import spherepy as sph

def block_gen1(nodes_xyz,data,grid,Axis):
#   Generate n*2n grid and grid values, data at middle points
#   van FE grid naar regular grid interpoleren.
# nodes (FE grid) is not equiangular and you need an equiangular to use the spherical harmonics tool correctly. Therefore, grid is an equiangular grid.
# hoge resolutiegebied wil die alleen om de yas doen (sweeppartitioning) dus vandaar dat y de noordas is. 
    a=nodes_xyz
    a2=data;
    if len(a2.shape)==1:
        a2=a2.reshape(len(a2),1)
        D_dim=1
    else:
        D_dim=a2.shape[1]
    
    if Axis=='Z':
        c=np.zeros(a.shape)
        c[:,0]=(a[:,0]**2+a[:,1]**2+a[:,2]**2)**0.5
        c[:,1]=sp.arccos(a[:,2]/c[:,0])
        c[:,2]=sp.arctan2(a[:,1],a[:,0])
    elif Axis=='X':
        c=np.zeros(a.shape)
        c[:,0]=(a[:,0]**2+a[:,1]**2+a[:,2]**2)**0.5
        c[:,1]=sp.arccos(a[:,0]/c[:,0])
        c[:,2]=sp.arctan2(a[:,2],a[:,1])
    elif Axis=='Y':
        c=np.zeros(a.shape)
        c[:,0]=(a[:,0]**2+a[:,1]**2+a[:,2]**2)**0.5
        c[:,1]=sp.arccos(a[:,1]/c[:,0])
        c[:,2]=sp.arctan2(a[:,0],a[:,2])

    Mean_r=c[:,0].mean() #radius of the surface
    PoleN=np.nonzero(c[:,1]==c[:,1].min())[0]
    PoleS=np.nonzero(c[:,1]==c[:,1].max())[0]
    t1=np.nonzero(abs(c[:,2]-pi)<1e-4)
    t2=np.nonzero(abs(c[:,2]+pi)<1e-4)
    Meri=np.hstack([t1,t2])
    grid_x, grid_y = np.mgrid[0:pi:(grid+1)*1j, -pi:pi:(grid*2+1)*1j]
    #padding northpole
    ex_c=np.zeros([2*grid,3])      
    ex_c2=np.linspace(-pi,pi,num=2*grid)
    ex_c[:,2]=ex_c2    
    c=np.vstack([c,ex_c])
    #padding southpole
    ex_c[:,1]=pi
    c=np.vstack([c,ex_c])
    ex_a2=np.zeros([2*grid,D_dim])
    ex_a2[:]=a2[PoleN,:]
    a2=np.vstack([a2,ex_a2])
    ex_a2[:]=a2[PoleS,:]
    a2=np.vstack([a2,ex_a2])
#    ##padding -pi azimuth
    ex_c=np.zeros([Meri[0].size,3])
    ex_c[:,2]=-c[Meri,2]
    ex_c[:,1]=c[Meri,1]
    c=np.vstack([c,ex_c])
    ex_a2=np.zeros([Meri[0].size,D_dim])  
    ex_a2[:]=a2[Meri,:]
    a2=np.vstack([a2,ex_a2])
    grid_z = griddata(c[:,1:], a2[:,0], (grid_x, grid_y), method='linear')    
    return grid_z,Mean_r
    
class wrong_length(Exception):
    def __str__(self): return 'CLM,SLM,GRID must have the same number of elements'    
class m_1(Exception):
    def __str__(self): return 'm must be scalar'
    
class block_size(Exception):
    def __str__(self): return 'block must be size 2n*n'  

if __name__=='__main__':
    if 'Model_data_coupling' in (sys.modules.keys()):
        reload(Model_data_coupling)
        from Model_data_coupling import *
    else:
        Dir=r"/home/username/HetGroteKoppelScript/GIA_Model/"
        os.chdir(Dir)
        import Model_data_coupling
        from Model_data_coupling import *

# number of nodes in a layer
    Config=np.loadtxt('Nodes_config.dat')
    Config=np.array([int(j) for j in Config])
    Data=np.loadtxt('Data_output.dat')    
    i = np.loadtxt('Step.dat'); i=int(i) # CvC added +1
    Axis='Y'
    for j in range(N_layer):
        exec("Data_in"+str(j)+"=np.zeros([(grid1+1),(grid1*2+1)])")
        
    Deflection_Surface = np.real(np.zeros([grid1+1,grid1*2+1]))
    Deflection_surface = np.zeros([(grid1+1),grid1*2+1])
    
    if DisableSH_0_1==1:
        Deflection_SurfaceSH01 = np.zeros([grid1+1,grid1*2+1])
    Deflection_layers = np.real(np.zeros([(N_layer)*(grid1+1),grid1*2+1]))
    clm_stock=list()
    for j in range(N_layer):
        if N_layer==1:
            ur=Data[:,:]
        else:
            ur=Data[(sum(Config[0:j])):sum(Config[0:j+1]),:]
        
        if ur.max()!=0:

            block_data1,r1=block_gen1(ur[:,0:3],ur[:,-1],grid1,Axis)
            data_reverse = np.zeros([grid1+1,grid1*2+1])
            data_reverse[:, :(grid1+1)] = block_data1[:,(grid1):]
            data_reverse[:, (grid1):] = block_data1[:,:(grid1+1)]
            block_data1 = data_reverse
            
            if j == (N_layer-1):
                Deflection_Surface[:,:] = block_data1
            Deflection =  block_data1
                    
        else:
            print [i,j]
            block_data1=np.zeros([grid1+1,grid1*2+1])
            
        Deflection_layers[(j)*(grid1+1):(j+1)*(grid1+1),:] = Deflection
            
        DATA=sph.ScalarPatternUniform(block_data1[:,:-1])
        clm=sph.spht(DATA,Degree,Degree)
##      Append coefficients of each layer.      
        clm_stock.append(clm)
		
#==============================================================================       
        ## output surface deformation without 0 and 1 degree components 
        if DisableSH_0_1==1:            
            if j == (N_layer-1):
                clm_SH01 = clm[0:1,:]
                block_data_refined2 = np.real(sph.ispht(clm_SH01,grid1+1,grid1*2).cdata)
                block_data_refined2 = np.hstack([block_data_refined2, block_data_refined2[:,0:1]])
                 
                Deflection_SurfaceSH01[:,:] = block_data_refined2
                Deflection_Surface[:,:] = Deflection_Surface[:,:] - Deflection_SurfaceSH01[:,:]
                    
        block_data_refined=np.zeros(block_data1.shape)
        
        block_data_refined=np.real(sph.ispht(clm,grid1+1,grid1*2).cdata)
        block_data_refined=np.hstack([block_data_refined, block_data_refined[:,0:1]])
         
        Load_check=np.real(sph.ispht(clm,grid1+1,grid1*2).cdata)
        Load_check=np.hstack([Load_check, Load_check[:,0:1]])


#==============================================================================
#       For triggering loads

	DataIce=np.loadtxt('DataIce_in.dat')
	Ice_data_allTimes = DataIce*Density_Ice
    Total_load_allTimes =  Ice_data_allTimes

    load_data = Total_load_allTimes[:,:]
    
    ## !input definition is [0 360] long while output definition is [-180 180]!
    load_data_reverse = load_data
    DATA_Load=sph.ScalarPatternUniform(load_data_reverse[:,0:-1])
    clm=sph.spht(DATA_Load,Degree,Degree)

#==============================================================================         
                
    for j in range(N_layer):
    # check if this is the layer below, upper or in between because you need a different formula (see paper Wu, 2004, formulas 16a, b and c. There are a few mistakes in these formulas but this is fixed in the code.).
        if N_layer==1:
            flag_cis=2
        elif j==0:
            flag_cis=0
        elif j<N_layer-1:
            flag_cis=1
        else:
            flag_cis=2
        
        Zero=sph.ScalarPatternUniform(np.zeros([grid1+1,2*grid1]))
        Clm  = sph.spht(Zero,Degree,Degree)
        
        if flag_cis==0:
                           
            
            for ii in range(Degree+1):

                fac=4*pi*G/(2*ii+1)*Radius[0]
                Clm[ii,:]=clm[ii,:]*fac
                  
                for k in range(N_layer):
                    fac=4*pi*G/(2*ii+1)*Radius[0]*(Density[k]-Density[k+1])*(Radius[0]/Radius[k])**(ii-1)
                    Clm[ii,:]=Clm[ii,:]+fac*clm_stock[k][ii,:]

                         
        elif flag_cis==1:
            for ii in range(Degree+1):
                fac=4*pi*G/(2*ii+1)*Radius[j]
                Clm[ii,:]=clm[ii,:]*fac
                 
                for k in range(j+1):
                    fac=4*pi*G/(2*ii+1)*Radius[k]*(Density[k]-Density[k+1])*(Radius[k]/Radius[j])**(ii+1)
                    Clm[ii,:]=Clm[ii,:]+fac*clm_stock[k][ii,:]
                 
                for k in range(j+1,N_layer):
                    fac=4*pi*G/(2*ii+1)*Radius[j]*(Density[k]-Density[k+1])*(Radius[j]/Radius[k])**(ii-1)
                    Clm[ii,:]=Clm[ii,:]+fac*clm_stock[k][ii,:]
             
##                
        else: ##Surface layer
            for ii in range(Degree+1):
                fac=4*pi*G/(2*ii+1)*Radius[-1]
                Clm[ii,:]= clm[ii,:]*fac
                                          
                for k in range(N_layer):
                    fac=4*pi*G/(2*ii+1)*Radius[k]*(Density[k]-Density[k+1])*(Radius[k]/Radius[-1])**(ii+1)
                    Clm[ii,:]=Clm[ii,:]+fac*clm_stock[k][ii,:]
    
        if DisableSH_0_1==1:
            Clm[0,0]=0
            Clm[1,:]=[0,0,0]

        Phi=np.real(sph.ispht(Clm,grid1+1,grid1*2).cdata)
        Phi=np.hstack([Phi, Phi[:,0:1]])
        
        exec("Data_in"+str(j)+"=Phi")


    U = Deflection_Surface[:,:]
    eval("np.savetxt('Deflection"+str(i)+".dat',U,fmt='%1.4e')")
    if i > 0:
        Deflection_lasttimestep = np.loadtxt('Deflection'+str(i-1)+'.dat')
        Udiff = Deflection_Surface - Deflection_lasttimestep
        eval("np.savetxt('DeflectionDiff.dat',Udiff,fmt='%1.4e')")   
        if i == 19:
            Udiff20 = Udiff/5
            exec("np.savetxt('Deflection19to20.dat',Udiff20,fmt='%1.4e')" )
            exec("np.savetxt('/home/username/HetGroteKoppelScript/GIA_Model/Deflection_storage/Deflection19to20.dat',Udiff20,fmt='%1.4e')" )

        if i == 24:
            Udiff25 = Udiff/2
            exec("np.savetxt('Deflection24to25.dat',Udiff25,fmt='%1.4e')" )
            exec("np.savetxt('/home/username/HetGroteKoppelScript/GIA_Model/Deflection_storage/Deflection24to25.dat',Udiff25,fmt='%1.4e')" )
            
        if i == 44:
            Udiff45 = Udiff*2
            exec("np.savetxt('Deflection44to45.dat',Udiff45,fmt='%1.4e')" )
            exec("np.savetxt('/home/username/HetGroteKoppelScript/GIA_Model/Deflection_storage/Deflection44to45.dat',Udiff45,fmt='%1.4e')" )
            
        if i == 48:
            Udiff49 = Udiff/2
            exec("np.savetxt('Deflection48to49.dat',Udiff49,fmt='%1.4e')" )
            exec("np.savetxt('/home/username/HetGroteKoppelScript/GIA_Model/Deflection_storage/Deflection48to49.dat',Udiff49,fmt='%1.4e')" )                                                                   
        
    for j in range(N_layer):
        eval("np.savetxt(r'Data_in"+str(j)+".dat',Data_in"+str(j)+",fmt='%1.4e')")
